/*
DOCUMENT.READY
PragmaTNI
Plein écran
Navbar principale
Copie d'écran
Modales annexes
Grille interactive
Calque
*/

/*******************************************/
/* DOCUMENT.READY                          */
/*******************************************/

$(document).ready(function () {

  /*******************************************/
  /* PragmaTNI                               */
  /*******************************************/

  genererModaleFonds();
  genererModaleTirage();
  genererModaleLecteur();
  genererModaleTemps();
  genererModaleDeplacement();
  genererModaleGroupe();
  afficherHeure("outils_heure");
  activerinitImageSelector();
  $(".aff_espaces_insecables").html(espacesInsecables);


  /* Vérifie si l'URL commence par "file://" pour supprimer le bouton de copie d'écran */
  if (window.location.protocol === "file:") {
      $(".outils_bt_exporter_copie_ecran").hide();
  }

  /* Gérer les paramètres à l'ouverture */
  let paramUrl = location.search.substring(1);
  if (paramUrl == "touslesoutils" || paramUrl == "documentation" || paramUrl == "autresoutils") {
    $('.bts_accueil').removeClass("btn-dark").addClass('btn-outline-dark');
    $(".bts_accueil[data-ac='"+paramUrl+"']").removeClass("btn-outline-dark").addClass("btn-dark");
    $(".accueil_content").hide();
    $("#ac_"+paramUrl).fadeIn(2000);
  }
  changeUrl("PragmaTNI", nomDuFichierSansParametre);

  /* Changer de module */
  $('.bt_ouvrir_module').on('click', function () {
    const ecran = $(this).attr("data-ecran");
    const act = $(this).attr("data-act");
    if (ecran !== "") {
      $("#outils_bts_options").show();
      if (ecran === "accueil") {
        $("#outils_bts_options").hide();
        $("#header_accueil_droit").show();
      } 
      $(".outils_ecran_tous").hide();
      $("#outils_ecran_"+ecran).fadeIn(1000);
      if (act !== "") {
        const modale = new bootstrap.Modal(document.getElementById('outils_modal_act_'+act));
        modale.show();
        $("#customBackdrop").addClass("show").show();
        $("#header_accueil_droit").hide();
      }
    }
  });

  /* Zoom le logo au survol de l'item */
  $('.pave_accueil_2 li').on('mouseenter', function () {
    $(this).find("img").addClass("zoomer");
  });
  $('.pave_accueil_2 li').on('mouseleave', function () {
    $(this).find("img").removeClass("zoomer");
  });

  /* Ouvrir le modèle d'écriture depuis l'accueil */
  $('.outils_bt_ecrire_modele_accueil').on('click', function () {
    $("#outils_bts_options").show();
    $("#header_accueil_droit").hide();
    $(".outils_ecran_tous").hide();
    $("#outils_ecran_activites").fadeIn(1000);
  });

  /* Ouvrir tel onglet de de la modale fond d'écran */
  $('.ouvrir_onglet_fond').on('click', function () {
    const onglet = $(this).attr(("data-onglet"));
    $("#outils_modal_act_fonds .nav-link").removeClass("active");
    $("#fonds_"+onglet+"_tab").addClass("active");
    $("#outils_modal_act_fonds .tab-pane").removeClass("active show");
    $("#fonds_"+onglet).addClass("active show");
  });

  /* Effacer le modèle d'écriture */
  $('#bt_sup_ctn_modele').on('click', function () {
    $("#modele_saisi").val("");
    afficherModeleSaisi();
  });

  /* Gérer les boutons d'accueil */
  $('.bts_accueil').on('click', function () {
    const ac = $(this).attr("data-ac");
    $('.bts_accueil').removeClass("btn-dark").addClass('btn-outline-dark');
    $(this).removeClass("btn-outline-dark").addClass("btn-dark");
    $(".accueil_content").hide();
    $("#ac_"+ac).fadeIn(2000);
    //changeUrl("PragmaTNI", nomDuFichierSansParametre+"?"+ac);
  });

  /* Ouvrir l'onglet de l'affichage de l'heure */
  $('#outils_heure').on('click', function () {
    afficherModaleOnglet("temps","heure");
  });

  /* Ouvrir l'onglet de l'affichage de l'alarme */
  $('#outils_alarme_cloche').on('click', function () {
    afficherModaleOnglet("temps","minuterie");
  });

/*******************************************/
/* Plein écran                             */
/*******************************************/

  /* Passer en plein écran */
  $('#toggleFullscreen').click(() => { pleinEcran(); });

  /* Ecouter si on est en plein écran ou non */
  $(document).on('fullscreenchange webkitfullscreenchange mozfullscreenchange MSFullscreenChange', mettreAJourBoutonPleinEcran);

/*******************************************/
/* Navbar principale                       */
/*******************************************/

  /* Positionner la navbar en bas ou en haut outils_bt_annoter*/
  $('#outils_bt_switcher_pos_navbar').on('click', function () {
    $("#outils_modal").toggleClass('navbar_bas');
    $("#conteneur_ptni").toggleClass('navbar_bas');
  });

  $('#outils_bt_annoter').on('click', function () {
    waitingForZoomClick = false;
    $("#calque_navbar").show();
    $("#outils_calque").show();
    $("#calque_cursor_circle").show();

    if (!annotator) {
      annotator = new Annotator(canvas);
    }
    annotator.setSize(5); // ← important !
    annotator.setColor("#000000"); // ← couleur par défaut
    annotator.setTool("pen"); // ← s'assurer qu'on est bien en mode dessin
    annotator.resizeCanvas(); // ← utile si la taille du canvas a pu changer

  });

  $('#calque_bt_quitter').on('click', function () {
    $("#calque_overlay").hide();
    $("#calque_navbar").hide();
    $("#outils_calque").hide();
    $("#calque_cursor_circle").hide();
    $('.ecran_zoom_ok').css('cursor', 'default');
  });

/*******************************************/
/* Copie d'écran                           */
/*******************************************/

  /* Exporter la copie d'écran en image PNG => ne fonctionne pas en local */
  $('.outils_bt_exporter_copie_ecran').click(() => { copierEcran("outils_modal-body"); });

/*******************************************/
/* Grille interactive                      */
/*******************************************/

  grilleNormalizeCellSizes();
  grilleRenderGrid();

  let etatGrille = 0;
  /* Ouvrir ou fermer la grille depuis le bouton de la navbar */
  $('#outils_bt_grille').click(() => {
    if (etatGrille === 0) {
      $("#grille_contenu").fadeIn(1000);
      etatGrille = 1;
      infoFlashTop("Double-cliquer sur une cellule pour accéder aux options",5000);
      $("#outils_bt_grille").attr({"title":"Fermer la grille dynamique" , "alt":"Fermer la grille dynamique"});
    } else {
      $("#grille_contenu").fadeOut(1000);
      etatGrille = 0;
      $("#outils_bt_grille").attr({"title":"Ouvrir la grille dynamique" , "alt":"Ouvrir la grille dynamique"});
    }
  });

  /* Fermer la grille depuis la modale d'options */
  $('.grille_bt_fermer_grille').on('click', function () {
    bootstrap.Modal.getInstance(document.getElementById('grille_modal_options')).hide();
    $("#grille_contenu").fadeOut(1000);
    etatGrille = 0;
    $("#outils_bt_grille").attr({"title":"Ouvrir la grille dynamique" , "alt":"Ouvrir la grille dynamique"});
  });

/*******************************************/
/* Gérer le retour en haut de page         */
/*******************************************/

$('body').append('<div id="returnOnTop" title="Retour en haut">&nbsp;</div>');
  //Aller en haut de page au clic sur le bouton retour
  $('#returnOnTop').click( function() {
  $('html,body').animate({scrollTop: 0}, 'slow');
});
retourHaut();

/*******************************************/
/* Filtrer le tableau des outils           */
/*******************************************/

// Échapper les caractères spéciaux du terme pour construire une RegExp sûre
function escapeRegExp(str) {
  return str.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
}

// Supprime proprement les <mark> sans toucher le reste du HTML
function unmark(root) {
  $(root).find('mark').each(function () {
    const text = document.createTextNode(this.textContent);
    this.replaceWith(text);
    if (text.parentNode) text.parentNode.normalize(); // fusionne les nœuds texte adjacents
  });
}

// Surligne uniquement dans les nœuds texte (pas dans les balises/attributs)
function highlightIn(element, term) {
  if (!term) return;
  const re = new RegExp(escapeRegExp(term), 'gi');

  const walker = document.createTreeWalker(
    element,
    NodeFilter.SHOW_TEXT,
    {
      acceptNode(node) {
        if (!node.nodeValue || !node.nodeValue.trim()) return NodeFilter.FILTER_REJECT;
        if (node.parentNode && node.parentNode.nodeName === 'MARK') return NodeFilter.FILTER_REJECT;
        return NodeFilter.FILTER_ACCEPT;
      }
    },
    false
  );

  const nodesToProcess = [];
  let node;
  while ((node = walker.nextNode())) {
    if (re.test(node.nodeValue)) nodesToProcess.push(node);
  }

  nodesToProcess.forEach(function (textNode) {
    const text = textNode.nodeValue;
    const frag = document.createDocumentFragment();
    let lastIndex = 0;

    text.replace(re, function (match, offset) {
      if (offset > lastIndex) {
        frag.appendChild(document.createTextNode(text.slice(lastIndex, offset)));
      }
      const m = document.createElement('mark');
      m.textContent = match;
      frag.appendChild(m);
      lastIndex = offset + match.length;
      return match;
    });

    if (lastIndex < text.length) {
      frag.appendChild(document.createTextNode(text.slice(lastIndex)));
    }

    textNode.parentNode.replaceChild(frag, textNode);
  });
}

$("#tablo_outils_filtre").on("input", function () {
  const value = $(this).val().trim().toLowerCase();

  // 1) Enlever les anciens surlignages
  unmark('#tablo_outils');

  // 2) Filtrer les lignes "contenu" (pas les titres)
  $("#tablo_outils tbody tr").each(function () {
    if ($(this).find("td[colspan]").length === 0) {
      const match = value === "" ? true : $(this).text().toLowerCase().indexOf(value) > -1;
      $(this).toggle(match);
    }
  });

  // 3) Afficher/masquer les titres selon la visibilité des lignes suivantes
  $("#tablo_outils tbody tr td[colspan]").each(function () {
    const $titleRow = $(this).parent();
    const $nextRows = $titleRow.nextUntil("tr:has(td[colspan])");
    const anyVisible = $nextRows.is(":visible");
    $titleRow.toggle(anyVisible);
  });

  // 4) Surligner dans les lignes visibles (si une recherche est saisie)
  if (value.length > 0) {
    $("#tablo_outils tbody tr:visible").each(function () {
      if ($(this).find("td[colspan]").length === 0) {
        $(this).find("th, td").each(function () {
          highlightIn(this, value);
        });
      }
    });
  }
});


// Montrer cacher les volets de la doc
$('#ac_documentation h3').click(function () {
  if ($(this).next().is(":visible")) {
    $('#ac_documentation h3').next().slideUp();
  } else {
    $('#ac_documentation h3').next().hide();
    $(this).next().slideDown();
  }
  $('html,body').animate({scrollTop: $(this).offset().top-48}, 'slow');
});

// Ouvrir tous les volets de la doc
$('.bt_ouvrir_volets_doc').click(function () {
  $('#ac_documentation h3').next().slideDown();
  $('html,body').animate({scrollTop: $("#ac_documentation").offset().top-48}, 'slow');
});

/*****************************************/
/* Impression                            */
/*****************************************/

$('.bt_imprimer').click(function () {
  window.print();
});

/*****************************************/
/* Modèles d'écriture                    */
/*****************************************/

$('#calque_bt_ouvrir_fond').click(function () {
  const modale = new bootstrap.Modal(document.getElementById('outils_modal_act_fonds'));
  modale.show();
});

afficherModeleSaisi();
modeleSelectPolice();

$('#modele_bt_agrandir').on('click', function () {
  const taille = parseInt($("#modele_zone_ecriture").attr("data-taille"));
  if (taille <= 300) {
    $("#modele_zone_ecriture").attr("data-taille", taille + 5).css("font-size", taille + 5 + "px");
    $(".zone_supplementaire").attr("data-taille", taille + 5).css("font-size", taille + 5 + "px");
    $('#modele_bt_reduire').css("visibility", "visible");
  } else {
    $('#modele_bt_agrandir').css("visibility", "hidden");
  }
  setTimeout(modeleResizeCanvas, 50);
});

$('#modele_bt_reduire').on('click', function () {
  const taille = parseInt($("#modele_zone_ecriture").attr("data-taille"));
  if (taille >= 15) {
    $("#modele_zone_ecriture").attr("data-taille", taille - 5).css("font-size", taille - 5 + "px");
    $(".zone_supplementaire").attr("data-taille", taille - 5).css("font-size", taille - 5 + "px");
    $('#modele_bt_agrandir').css("visibility", "visible");
  } else {
    $('#modele_bt_reduire').css("visibility", "hidden");
  }
  setTimeout(modeleResizeCanvas, 50);
});

$('#modele_choix_police').on('change', function () {
  modeleSelectPolice();
  afficherModeleSaisi();
  setTimeout(modeleResizeCanvas, 50);
});

$('#modele_choix_police_ecriture').on('change', function () {
  const choix = $("#modele_choix_police_ecriture").val();
  $(".zone_supplementaire").hide();
  if (choix !== "") $("#zs_"+choix).show();
  setTimeout(modeleResizeCanvas, 50);
});

function modeleSelectPolice() {
  const choix = $("#modele_choix_police").val();
  $("#modele_zone_ecriture").attr("class", choix);
}

// Initialisation et resize dynamique
window.addEventListener("resize", modeleResizeCanvas);

// Quand la modale est affichée, recalculer le canvas
$('#modal_ecrire_modele').on('shown.bs.modal', function () {
  modeleResizeCanvas();
});

// ---- Souris ----
canvasModele.addEventListener("mousedown", (e) => {
  drawingModele = true;
  ctxModele.beginPath();
  ctxModele.moveTo(e.offsetX, e.offsetY);
});

canvasModele.addEventListener("mousemove", (e) => {
  if (!drawingModele) return;
  drawLine(e.offsetX, e.offsetY);
});

canvasModele.addEventListener("mouseup", () => stopDrawing());
canvasModele.addEventListener("mouseleave", () => stopDrawing());

// ---- Tactile ----
canvasModele.addEventListener("touchstart", (e) => {
  e.preventDefault();
  let pos = getTouchPos(e);
  drawingModele = true;
  ctxModele.beginPath();
  ctxModele.moveTo(pos.x, pos.y);
});

canvasModele.addEventListener("touchmove", (e) => {
  e.preventDefault();
  if (!drawingModele) return;
  let pos = getTouchPos(e);
  drawLine(pos.x, pos.y);
});

canvasModele.addEventListener("touchend", () => stopDrawing());

// ---- Bouton vider ----
$("#modele_bt_vider").on("click", function () {
  ctxModele.clearRect(0, 0, canvasModele.width, canvasModele.height);
});




});// fin $(document).ready

