// plateau_images.js
const plateauImagesBase64 = {
  arrivee: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAA81BMVEVHcEz//v3P3+j//fz////2+O709ur5wFuRw0rpdiZXtmz79/D2wp+23a3/2or35dbpcB/0toteuXCVxUrJ3dn059Tm6NHf6tji7ej1uJD8363/35r5vWPR4eTy7tzyrX/62Leqz3Kg0o/V4+TrfjTqeCuQw0Pf6udUtWllvHjpcR/6ynbO4sr6zn9vwYGLwDiCyZH92pX6x27xpnPsh0L7xXSZ06aExZff1If6yXP/1oBVtWqOwT+MwDtQs2bQ4OvL3eRJsGD5u0/oahTW4vOHvjKVxVF0vFG00p7/3ISr08HmWwFwvoRguGT/1XqnzX/dznbxFmk7AAAAO3RSTlMAAv4EAQ8U/en9/AhZY+4m/m7k4PwvOk5sZmbA9eAde0azjMXR5+uJ9NXvvaKswPiioM+Pw+Z79+rD66z+7bgAAAKzSURBVHichVSJUuJAEO3JJFFyLCABBOVSQEXXe8/cThJYj2X//2u2ZxLIcFT5CqpmOo/Xrw8CsIZansqjDJUAAWtMxOkTUOjMKKxphBCaX1Qq/fZ5AISamkpBH1tAVNBOfj/gj4lKqOSIwBPTi/OAVTlR//LnW70qInq9WSaCPkD3+vGhCbqGUUE8ZbWnqtYfTN7qQAtF7uLrC0eb39ScOKuw2qTGKqyzIvJKui8HHKda7oUTa5VKhX9LomUR+JUTUbLKva2IHGydejYx4fEgJ3ahg55EMRMmNNnMWhVjmipazIktIJoo5u8JDJ8ZY2PL3Oh2SxBfriHvmyACtKwh3RwgducUi77GdmIXCyIVjabl1LHIgQZ6tzsEGFpFH5HI50Lk5VBhzMzCQv1NjND8+e8E9uxHB+cGVYsvVwcHRsEOghHsXSR8OHgzxRry51eBe2TC7k5Svo/NujgioB0bRmyLDhC6TVdXleHnNjCM4Kq47giL1SPQsqEVG65rxG2eqXms7bHAS4pj+14Qg1vMrfWiG6BbJJX35yw2Li9dDiNuARxHSlTdqZ8vYk7Kifdg9hQlutiSbFIMfOdZVwi0dqQoiqNLLikmuQBiHrmGJHl2zonRcSmJQ+uFTh9sWdAN3kPkKWGv7D0Vri9wIhvE14QrbkjCOQZ624JKgfPSoXCd/AjcHcEwCcOwXUgSIagkr+4GHLQYOgvHWYxyIv4TIiXEaPIuS84XCeotU8/z0/xtQeEmSiInjJJXmeh7iyha+B4iFZIE+nfZMsuScEPyA59nWeoJ3PWRhgNOvdT3l5GymMuCmNMreOkZl9Sm4uZnme9/SIIypviyUe1C30eBuSwoIbWxmIYc3C/o+Q0AFPRLzHk5QTCXYwguOZo2Go3DNY4EDiU0OKYj0AT0Fbau64j2H5bMkMCPb4NNAAAAAElFTkSuQmCC",        // oie_arrivee.png
  depart: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAk1BMVEVHcEz////mg5L//vzjsmv///7yxHTaeoT77+Hx06T55tr238/9+fP88uv02rHktG/03cHrq7Pqw4vouG700ZX24b/jlp/ovoHisGfjmaHxvsXxxHf1z4zpj53rwH7k6Ozcg4zisGfyw3LwwGvntmrhrWLgq13XcXvsvG3ke4v4yHP58OHDomlLUVn91ImbiGbsxInRvmXAAAAAIXRSTlMAAf4E+gP4/COIMUIJFW/kT5Gp/KdZtcH0rm7hvNPR/t77618VAAACHElEQVR4nM2U2XriMAyF5exxVrJAWrZxHDsb0Hn/pxvZIUOAdsrVfD0XhC/5LUtHsgF+iIhtkxcw29a/9yh5XomYFwQRgLnk9PsHLtg4nDsFXXwiEIV3CxUXi65GcZ6qT8RUItTY07tsTChF7ijQqTm9ZfbeG/37IhsCYdLkw6DJYYcf6EprbxhGv47+kjakLO/Yaai7oT41HsC6RfW9odQbwW1nn1n843z5OJ/q86lUoOu6xqx+NdlsavD38ajAy3GcwQU5WYWKcetxHDirL+OIO71p0F1ERC5IPYiapmFNXQ/ozzYkU45tO5GqcLR0I6XYpFmTI8uxah5jzsH6TekXBu33HlZrQyYtiwlZNVp51xSgkr762LrtavLRE4wxC1k2kZZPpuFAYeDWTa/tjqWKp2jWobb4HqJ45+vsCVA0eyp3IyyRBVmFoO6Lsyt9HI4u1vuRW/sOwpIUM0hEozuNVXPEeTERt3lMhfAhBCqUOZpB4R8K9yNrQoSdDcGXFoKxv+VKTuHB42iHoX4kjOV8hwvTYnvwPXji0iTJgpBmQoFzqTBXulAlmJSJ0PboHU37MwzByWxLPzA5+tm5UyorNFtBUpmed8XTqZsVlRshcfdYmy4OX2B6vRf7pTk36cuIxLSvhnqYr0wfjvEDa9rE1OORhPDd7YPHRlbS/1fAa1iIEpl48P11hpdAEMIr1x4BeIlTB/w17j/rD+qvM1nn2vr7AAAAAElFTkSuQmCC",        // oie_depart.png
  hotel: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAABBVBMVEVHcEz6/f4Ckf8Olv2IxFkRl/8Aj/+23/DW7fRLsf/f8vaGxmRhuv+n1o1hu/+w2pkzpv/G5LWEyv8ypv+a0HxSsJiYz3pJrZrQ5fWz2oUwpf9DraTr9uZovf8AkP+AxFwAi//81AN5wFEDkf3x8/b5zgL60gH51BJwro7t1nT29v7/2QCj0IH1+v/yzSXw7+Xy9PsAh//u4Kjv4IfrzF7v6dPs25f3ygMMi/HqyUXs2YjxyMvw9P/z3nPd6fDv37P5n4X62S72p5fcaE7wdFHz1lvxWjD2lWvw4Zrw0EGsaGr2vKfg7/rxgDH6yKf0h2f12dqix13D0kqZwrycxMH4rgDowyZMu8+EAAAAHnRSTlMAA/v+99vwPiCXEuKElIKFuVZatbH4u/L5k7T2FH1F5iVNAAADEElEQVR4nHWVCXuiMBCGEfHW3nd3AwESql1AEHBlddUu3rZ2e/3/n7KTAFat+z3qhPF9JpNMMghCqkwGvoWDo1xeFPO5o4NCJvbtClzFak5RFMQFg1y1yN27XLkkOkgTNQ0hDWkwQI5YKu+Q8HSSd5D4c0sicvInW0FhWAJM0+bjP0wR+xnPISxyShskDG4cERLT5gOmyWLyNBmM5yxX0bnZjHmqZLnmi8UCwEH0vFpE89innH4GLKGr30zLaDweR6txNF5FqyhacucVKsUhM8KJk+2aDRM+z7829Gw2GuDrZp0TRsK+5JH2VudqbSqMfW8ayrNdgokdUbnDhJB2u03IrsV3iujwyYsi0pS7e4POgumMYoyt0B0RsKTu1olxf6doSIQaCVVH5CAJTLPfxpiOTNNuY4qtrtm1KANFpwo55lAckdR9P4RIZOb7Lgd9349BhHIZoQCWgZR6QeABSDtBEHIwCIIE1JSCcKAkObKpIRImX6dGonIgHCUgpfV+PzRgEaO+G1gAzlzXnaXgkZBDcY5k6E6n7ohSYwq2RyltgW0lOaKckE9A4z9KwLzATg3KLhvNWLqp275vg0kcjWWWn6IYRK+juF71nrd4AC28XuIYvaIYTKaGElIKBXufPDwMgJy8Y0KZC6dTp4sxMLEsQh/7j0+TyRMYSq2ZRY31Yk7X+1jXmwHBHx7XB3B+01/v46lQXYMh1JrQTrcB6nYItppbG15Q0GYJaUfnYmAYhmmtoYRwKLQkoq4HKdhkoK3bMaixQ8GOGXJ4jrYdboHJ6YGL7HyH81i8PD+/lTCUEDQkn2ALnlsUS7fn55e8uVyrkvwyHA57vV44MlLQYM+9+nD4IkvqNb+H5Yoq2/CnDdJtL16MZzdt7tBtWa2U42t4rEp6I5HtNbn17NSjS+pxerFr6o+1/m4ZJrX22VPO1LXkLcN0ttnMzlR5vyTGbbazmipLezAZ5t1pkMeSugeTjoUvPbdck1V5HRYspFf7tq+JC8XDClsG49kiKof7mn36+ji8qEAwqXJxuPP6+AdojMfSb0+UnAAAAABJRU5ErkJggg==",        // oie_hotel.png
  labyrinthe: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAaVBMVEVHcEwqY+H4+/9zpPYvh/3a5/00i/1Xnv07jv2Yvfi1z/pUg+g3buQuhv0fWN6U5Pojff0mX+Aogv2P3fqw+f6H1fm2/v5xvvg/lf57yPhRpf1jsPeh7f5Mjeheou06d+Wp8/4xbOJEg+fJzfoeAAAADXRSTlMA/gSR9xz+t9tdQr7hLV6sKAAAAmlJREFUeJyVlQmu4jAQRHECYfVux3Gc/f6HnGoHCKD58xlLRFH0VL24utntHqco8LuUx9N+z9jtWl6K9dvnwadDeTLGcM6Z1lroW3nInz+5Q2kUUQTmAxZo8Sl33iu+J8oYBURnVrDzmyheyxUzijdt2y8jE2JFyxcSL0dVAVO8jbJzTkobU88yKq7Fi+ZRZbnWurp202StxIl9TkBcN8Fy5QIoG9o02X4ZItAw6zV6sXLnHJer4GzLlWomOSLDBagfKbw4E4m+7Nem8KohrI2TTf0shB4sSGhqRl26B0a59Ghi52oUI32atehBUvQ1+MHk/AI9U1fXk/UhWtktmhEZKE2NO8qCqq1dY0xwrguIr9k4DIykBil7ce/miRRtbblKztlG4R4RFSnixpmOMpLirdhdDDXQuVY1nbOV4snbGHroabbMYlkl9WVXAlSRBGPdNary6HmXWyiGLgkWZVpjHymyrAME8eC+nnwaAoqgBP0M2pP6dXdCZARtVeumBmlOgdyDFvZizA9Pdevbbp9TBBMQ3vjaq2zcIMO4eDkIPbNsuTuI7GLtTSXrhPvMfbE4lN/qzA+Q/wp+EToXM31RzNft+bHh0JKvDX+/Qv68QkLg2/55hZspzJspRlhtIPphirvNnEvqYTNUPQ8eo+jHF5vdjevd1KpsXFkZNgPzYL3fjLuOgqm6TGIUkANj0acR1Vi7jcJ9uMgYU6LhqnJoDBcbAG7D9RhXItdxNQa7TLD+Y1yfC8BQC2kBNNU49n9ZAM+VYh4rpfN/XynbkjK0pKZ/LKmf155+W3vfL9LvV/N/LPtf/z7+AEj6UZDMohi9AAAAAElFTkSuQmCC",  // oie_labyrinthe.png
  moins3: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAS1BMVEVHcEwglPAAAgMFGiohmPcglfATVosJLUkRTHsTV48dgdIXaasaeMMglvMjmPT///8jn/8UkPM4ofVMq/bW7P3x+f+Jx/my2/tnt/cnynGIAAAADXRSTlMA/AMX9uqINGd2w5a5QLgfagAAAd5JREFUeJyNldmWgyAMhl2wrkRAEd//SScJe+3M9L/wKP1OdtKmSeo6fPTj9EJNYx9PHsLDftoGFTRsU8+HH7BVKAWyZUlQSqxPFD9noRACGYWwEvMb2TX9gpgEqWUhRJe+JLtmHFQrJWhjZKVWDWMmkRPgOWtBQkWCSCT6HTx32N1WJoHIIXtfvN9j3wmEd+9LNDh77t5JZ6lDk001k0l0LNiJ2Z+6NJsX5LxrVjIopXa/ga1auSEiBKMvivE+goxLFslk00zeIEWJpAXtxR4C2KoJwS2CPh/M2qsCt4ZqmMum7yu/X9m1xFqOqiywDr0mk9JlUI05xAD4BwWJUUaQgnxVYDALlDWykLrz+gDKw1kqlO/LHyBYoohN5AME7qV1t5Hm3HdXgkUyoYCcO9e0AKeqPNyQUCWymKojYSwLbrzw+zoxRuvSLzS8sYUUG08MXQZ+O032vOWhYNBay/7u6zqLrP1QpDGTwJ4pTBofbPUZTQreBGvOmyA0DdrfoDN6XnnCC5M8XmY/rwNobl2e2y5drrozO6dzhJswx/u61N053Fn0Ol3XtADK6TE8PcwVCyCulGIoqUfgOVEvn+EtToBwW8olldfemx5rr1ikBfVpkX6/mr9f9v/+ffwAYY9BfheNoa0AAAAASUVORK5CYII=",      // oie_moins3.png
  mort: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAABDlBMVEVHcEz9/v72+fsEX4ZNjqkDKUIAW4JgmrIAWYGKrr/X5OqqxdEzfJzO4OcUaY0NZIozfZxKaXsQNk5hfIwzVGnO190zVGgzfJoAXIP///8AJT4DXoUAUHoDKEH+/fwAFjEAWYEAVn4AHjgAU3w4NTX7+/oDL0koMTPn7O4hHBsVGRr96eD38O/61817e3uRmqH+9vTd4+VqamvGzND/3khqorpYXF99TD0UEA+hXUhvh5b9kmeNjY1SU1NGRUUBWH6JtcfWno0zfZzLbVBTkqywsbEYa45cd4dIJhz8qZD2d1N2NyTN2d6jo6L5vqX2//+hxNL+87K0zNfqUzL/9+jBhXT+qnb/2Qb/vwMnRluMF9eNAAAAGHRSTlMAAQT7lvnwhPtaE0CyINnduZ7hi7slv7kGuleEAAADRElEQVR4nGWViVrqMBCFK1DW6371Jk1burGWlgrIDiqbiKjg7vu/yJ2kaQE5Hx8k5edMZ5oZBCHQQUQQIpnEyXE8mYwfnyQydH8g7AkuHyaOdFPXEEiDxVHikF3eEdilY0lZI1HCFSWanIylf5nCJhWXUZQgQjQTpCPKIjmeYl9ucTHAEAIXfTaaTCYjIusEwSU5tkXC4o8MbojI5HqZw1TF1cjUIEBU/hOSPgcYMidFjHN4vVY9FeMVYaYbMgJxWVhthdXPXs9rNCqLxcLDxZlPxvzcI0KKcgjdvILb8+JT/fpWe28PsCnOaK2icoqSB0I6jtj93eKcqto9Z/31vXbeHKzm8KtMv0HxNGBBYH2E4b4gttf4+m5UenSTw/fyJvhhksYlJg0Mqrw3QO82Xau4LkHqCCXhGQkJZngz88vCpKrh8oeSUTkBuRzR3xBzwiJTRmVvbAexs/kbgrSjiJChJfBTwXvK4WpWoaSeERJmdAPa3sMz/YQy3Xk2B6X8TdRMCCdbjt6i89gaP2B815rPWx3PBymp/ROO2fkj8jV+eR5bhUKhdIfxR7tcbpdasOqCI5D6sRBHfnVGGD/MC5ZlFTq2/VgulUrlNoBNQ5EoGRdYFYEkxfcx5SxrXKl0yqUyvFqVIvWjyoegfJtjYGFO77HNLDs5mosvHhqOxOzFeYRbtMZOve50yu1ye+685LmhJPJkWDp2D5J+s6+awyv70Sq1Pux7bqhIZ7w8vEJOz3bwtDmsYsf+cHAYWDEuecGZ9CV+oV2wrBfZc6kbYWDjnD/CoJY76oaZKEaGHwoOTmvT/rT/1Her7tPgqbuJfBbhxywAC0/Nfs2tDdxhv70Bxey5EBxcH7yyasPmoDm0htagtNw4ShdhD/qgN+j7jrWha3lBccTsKWBBc1Fwgt1qrer23aY7cGuYg4ok0ubatCvtrwpTkaqCfwzFN0wFjc2DE3OFw25R8TTgTvnwC0YKRZebKtb95yxm//4aPrTFNNStXzHVuxI7icAd7Iwzf+whJMMhVUBGlvqJEsTdnrpbgxTlDZYqSFSy4u4g3RrNMGbznALT0/T+vA+HPQJSkgzDODu/2B/2u38fefHs8vzX38d/oNipBvGWIOUAAAAASUVORK5CYII=",        // oie_mort.png
  oie: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAmVBMVEVHcEz+/v212X7m5+f2c3Pz6Nvh783A35HI4p7q7da12X7y9ebh7c71+u3n6OW93Y3R567s7er0YGDul5fq6+m924/O5qn5kpLrt7fopp36r6/0XFzvsbHm5ua02H2x13e12YDp5+yv1nTl5OP0XV31U1Tg5drp8PDQ4Li82o3F3aHa48zq6+vtb2WFhYXa09JCQkKsrKztjIz3oGGIAAAAHXRSTlMAA/v60TJfvqZF7SB0EdXUgp/8+Lz6i4X7/WP5u9yZ1ZMAAAIGSURBVHicdZWJdqowEIYxyC6g3mpv720SkrAIbm3f/+E6SRASlvHoEc7nP/NPhtFx7NjozyTaHd7cT2c1gPMAyVwhsGh+3vsfLmB+hoHBt4a5ovlTRYsk3DsA5LqCPR/PmwT/e3NyA3fehOtiDEkfX49GguWchMv0gCUGcfv++laKx7L655ioNBGeRM8BCS/RfFQlkO+bkYSvZ8qvDJshmr9VWZbHausNbXOSnJMTxkugEn3peYgiemET8vYsVRxBNOk5ggipJxxm+F6VlYyy2koujSkitLMFGRN1/XG/b3Uo7wEHPTszE5euJaRAfPeyvHF8ydmZ2aWllKigiSLhvcllgbQ183Y9RQji4UtSC5qZWcfJGL2k4wRUgWO32cXkEN9rMInVdTGWKApigjS3MreGEUqsQDr3WYNGF9sJx/X0htT2wq5kCvoK1F7I4GWeue+5BkcvrJuBewM02t2uKKoaDS+iXalxz22wLsiy64jaBzgDSZyqhqfxBJwK0qA/6xByGyddr5QIuWWR1/XUfWY54OB7HIkJOAyPfLS4OTv2UaNBUJJ7fhIrDX/1po+gcPHiESJ+NjjYJ/m4dUxQPjD2IkuzgRynB5EJpzRhg6rVCPOoQYQo3TkLyzHK5LLV/UEI1HjgLe1lEPUzIXrblMdh5CxvennT28H/AeviPPQTvavH+AWlIn0ycJTUqwAAAABJRU5ErkJggg==",         // oie_oie.png
  plus3: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAQlBMVEVHcEwglPElmfUAAgMFGioVYJsglfAJLUkTV44RTHsdgdIaeMMhlvP///8UkPMjn/+UzPrw+P9QrPY4ofXU6/1wvPjUtDE4AAAADHRSTlMA+/4DF5LqNHtnw7ks4HR5AAAB1ElEQVR4nI2V17aEMAhFFVvUmGr+/1cvkK6udYeHKWYP5UCYYSg2Tfgyb7tYFrFvc37yMnw47+cKmg3Wc5/54Qe2jFpLObJJqfW4vFH8KkBLArLhZw3iQU7DfCAmG1PESn3MLTkN26o7TErvFSCq162SyI3w4MDaSMJYSIy7Pjnp7WVdJNca/XjGZfC6HCeqj+xQMKfc3dpFFiIpyCUGBk5KmettPiZMwadhYYefoImK6oUbEvNj8PYuG+VoVBafOr/HShjEExWNiqmc3hE8OxCie+lTJQk8MfIq5QtEC5VDQy03XUHT9rr+Bk1vOUU8CXfxAUxKkE2SonZFNaND5UOTpEgqtq7w1XBjrKng0oOoS5aem5gFIlC0oAuO3ow12DvELdTQewP6dASUrpKouVelmK2qQO2wqQIsufFI8mTBafgdTav3wCOH/qxTVfDcQuXKzAQVJ8kG1bQwJ4mg5dPrxng+BFOrjkMxj11o77NQNGkp9siboChZisGrSmXf5dYsPOEz9PIAEsZ5CFeSZ+SrUC5XETx2xpYRT5eru67cQu61Lb0u17VbANBMj4cYty6A90qB6PyxUr6XVHTeL6nPtcfYc+39vkh/X82/L/t//z7+AD+sOW1Yww/YAAAAAElFTkSuQmCC",       // oie_plus3.png
  pont: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAeFBMVEVHcExwsuJUkcn7/f+fzOy92e9Gh8aCrtl3uObo8/ptseHh7vhondG92u+Iv+dSjsrExcSLwOax0+xuseFEhcVmrN7hYkRor+FAgsSrb3nWRDRmuu+nzep2tOGVweOv0+2XxumEu+M2fMHtbUvD3PD+0a3rWDS/wsRBO6qEAAAAE3RSTlMA/PoEjUz3jdsS8CC1/bXb/brnaKBkFQAAAe5JREFUeJyFlIl2gyAQRaGCGo1NUwXSFhCXpP//hx1A3DDNOycJvFwZdRaEgpIEPpRc8wLjIr8SmnhvL7BKkgsmaidY5KR09p47EUth7EH4hS057cgEghZspmaWFXRzKCwJYHUkQMmKhMU7wwecPZW9r88ErmYs5sBzZDiQAFdzHoPWwxA98Ry13FMQSGpJeC+FfQ7FB7XnvIfrwr6lKbDohqETWy54U/DS/c3kMMjd4yyegBz5A2vVct7uYs8edm8zF9herDk32yMXD4scHtlGZmZknLPRrEhmqsUTFBGBBXit4Fy0lVmqx1SSBQ8LYpPSjVJ5ULVjBwzQW8+m51OOUmrVuqtrLe3WfXUb7xNVWnbGhKuN7qRpWy3VzquQUbrTurb3w2StYQNbZezXxkPfQY/Hd6SVh76CHo+vSCsP5T+TOP+JtHg5ujK8KqmjMnM5vE6pfgkSn8JXoE2hL4r/QVcUIbY4AIPnygyVvmLUcNAKwRPl3IPi937/3bfC5PlW8M2Fxcf9/iHwRsHzzWXbtXnzSt9igdfQ0NhZn94aq9tWzkv7bJkp5z5tnijtz+th9pR03HqcZX1zgKYNxN0NSJpGKGApRdHMPWW3/rbmYJudjoY4KrPLzMLikh0Ne48imp0vcAPp5ZxRtMH+AAjXZeOCt4t9AAAAAElFTkSuQmCC",        // oie_pont.png
  prison: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAjVBMVEVHcEzMzMv+/v61trfW1tba2trQ0NC6urjY2NfY2NjFxcX39/e7u7vu7u7s7Oy2traXl5W1tbXowZzOzs6UlJHP0NCMjIftxJyal5OkZTWxsrKSj4iOiIGJgHXRvKehXiycnJvyyqPR1NjBuK/XsY7EsJ+knJNWUk67o46rb0K2lHbHw8DOnXPVzMK1flJZd7jDAAAAEXRSTlMA/gP7moffl1+2vRTgJUL38nIfnq8AAALGSURBVHicbZWHmqsgEIXBFpN4kwURESyxraa+/+PdoZg17pIvKMPPYRhgRGgpngf/U7iPsFA42ocnz9q2BUz/dlGKcZoKlepntPtnzFvuGIgSqNSCULBSwXFDQiuO8EXhbA0KhqP4QxReAxC78AW0yowBHaxIeNlDVwZgirOuu6iuy7SvDMbh/VpTcwbMOjzOqpxHDKgBDbkI7u6ZBTt8uzZNWTXN9YY7ZsD0vrOSHopLbEE1XpuiKMoKquY6CmXMWMWahLh8uUVcqkJzBmzgx1lqQPalo+ShwK02u2glB75gSMmsIlOB2Q8XFjC8webR3pqiXOwshT1CITYg7ubqDT5a2j4aXs0dNiAOwccoc4ovC8KqVU4pkLx6OcUs8tAJWzC7a98aCMxDKKpLLqoC4mZAfIKZDYi7EeJXXF9D3gKYa01RFmOHLRjCpljFbnypcqDtMORC5VBTytgwdk5xj6LU+fhsvzltb9NzEGqY7kDCgKfzMY0QdmD2pALAappu3+I2TWULIH1CR6pBjOAom1ODcQ5gPkyTBqbJKoI51XHEGBFCREl0qWFqmret9hFq8FHVpoMpqNBZg1K3ewD1YqkLDzz7N3hGyRskYgty8gYTdJD+CqR/gJIpXx5QuAbrlWJOjW9G0ZchOsn31IyTWu+J3Zlat50ikSfkJQ6s6QwdfW0Va1gHm2ntfEzgPIbSgDWIKEmkVTZK3yBcG0WYGQ6uUey1U0vcuIurDkJvFE1yCRiXRC8jn/sVKPtR22rdDsydOX6VDhzlWlEuoOJHew3jyid9ruPxCeqp8574PF4u9k76RBu/P8FZDya+3P3kFNieHozit2KvN+Unp3hA6tND1iBhoga9g/eRzgJJfLYFuU9ksE2Q8VmKLajkOUa/cu4xYBXILiCIcf4rNS/JPpFSWhBekj+T/fvzcUjOjJ+Tw/bz8R9zt2j93hE9IQAAAABJRU5ErkJggg==",      // oie_prison.png
  puits: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAk1BMVEVHcExRwen8/v9axOqS2PFyze2D0+/F6vfx+v3d8/vj9fuq4fRPwOlRwObTiyhGwvRDvOdMw/DrfyH6tB1UvuBKv+j6qiNxuL1FyPttnJnqdiLYoUP/yg7xkB/jqkiSYSH+wxXxlyJ+fVyGcEDHv1pdrb9lt8iVWxTEjzqSvJdevdSPqJGaoHiSg1i+rFu3llyidTDHM6h2AAAADHRSTlMA/ATvn820VRQxKHvatgPyAAACXklEQVR4nI2Vi5aiMAyGKTdntLUUaLmruMogAvr+T7dpy010z85/MKeUj4SmaTSMUaZpGF8b27EwyHLszZeeWwumvm2Le5xLkMPAsr/V9BrbuvAQIYSVYAC37naFws0Oe2SARiHi4d0LaRqm62HGMFkIwwSgrjmTMHQ8xJJziDmlTF5gCExUOPScidQcDv/8XOMmmkTi808SM7QgDddDBMBj0vQiOxzUlUXV+ZhUVYg8d3S4A38KrOssywYuq+vn8VnvWxp6O+nSNLZyhQq8snbiDhWTods2hmdb+X0y8ASGSiSqm5Ao8F7fKxlc7gdfeNQJpFUdMg1G7aNihMMeGbZ0OII6hQxArECGKcUEeTbUgbX0SNR49sh06rn1ZWw4WoGEXbuua7AG9WbyzRD5FezauINcL0CI7bx7pEAlCXvx6Bj6ExcgYU3W3/o+XIDwkcZUVOOqQ3o7SUV0AWI8goRxAGNVOpECG1UUa5DgJno+E1U21T2QulXdsa3eQHr39x9UN3hAh8UQ2u4/agBhMTo94PEj9wgVKNMzJBzj5iBAqTR+CabwhbjxOeHTFhK5ApFK65dgSh8WROctnIti74NSZVJt0vsAyqKYy2zpKghSEUweVZnNhXsQEhQSFPAN8BNjaK6ay3gU/hlaH4X5cJ3yPA/8U37KfQFGFHk+etzqYzgc17IoyiItwKY+GB+GyiPSx3VuAJkkSkmU8E4KbylwagBTS4HQOqYP5pQGYCE0ems+5HK5PHow/eMih9JE9KX1DG2PvmvV9uZGSl703kh/35o/NXvvY7P//9/HX5RIXvfskatIAAAAAElFTkSuQmCC",       // oie_puits.png
  question: "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAMAAAC7IEhfAAAAtFBMVEVHcExfsP4EBwlMg62G1v14z/tttfxUks9prc83X3xbmrh6x+8RISpotv+Gv/lhqe4oRVo/cqEYKziY2vuk3PkbLDX08vHi4uvh4evz8fD89PB60//r5erk5Oxsvv/19PP0+Pv/Q0KdyPbi6PH/gEOK5P+G3v/33c/e6/X/UVDqys634vnh7/bI5/ev4Pqz0fPrt73/jVb17Ofl2OD3eXz7Y2T5vqL9oHXvo6jP2+70i4/G1/B3hEJJAAAAFnRSTlMA/gSQ9/r8ublbmN4V8v3eQocj/f0iFvVMRgAAAjxJREFUeJyVlYmSojAQhkHR8RjPmYWEGCCCCIo3qOO8/3tthyQacKfW6SqqIPVV/52+MAxljQY842anb5H2YPQ2GTfEWd3gaNrsxzEBM8E8bzSZlsd17r0XLwixPtebzW43H7Y523yvkfDVtWJibRPsgs3A0Pe8bXqDbsUpvPYWpLUGyraxjR2EkAPsHLw2NRJeOovWR+YCxA073BCis6+h6b3pPoHb+q7EMKbcI2cpnZekcthbtNauLTA/CLATZlSQzmzO1RuC64I/xQXH8+VS5NdTUpJOSXY5CXmxyIevuOUhiiLGWLFXpDM0BzxLIBy3Mldyqyg6XM7XPGVMkoh+SfFpTNbiHtg/HqLDMgiyZFWw9BQKkotDjYzmwsJK+Mw5DHnMVim7SXGK2t4EYuyTravIS3QOeMKBvLFCBsldjhrGOCaJjNCfHaKlBJM9S1dK+9v0xkYzVsq2fVwuj35ZGRQ+QPji2h3y6SrQDgJflBBlV7iNyDq4HJpvRp+sHyAWt4eKhAXLQz1IwyKbByjMp0lyuyeSgztzYJAnEB9P+5yxm3JYgu0nkFcR6sJy3hI6aD2DUZoW15AqTkpXLqPAPU3QnZOXqaRHgfcMaunRE/4DKBL+KOFPoCyh3hQKZDWwbAqtzVTFz9cTRXVlvXFVYYKsEqBsXH0UZLet9lTj1CiI4dK5WoxUDld1XLkyvuRajPdxrS0ATvqhkq4sgPpKEf3o/GOl/GJJvbr2Xl+kr69m4fTPK8v+v7+Pv/rQgTSps+dtAAAAAElFTkSuQmCC"     // oie_question.png
};
