/*****************************************/
/* Fonctions de Tirage au sort           */
/*****************************************/

/* Générer et gérer la modale de tirage au sort */
function genererModaleTirage() {
  // Génération de la modale
  let c = "";
  c+= `<div class="modal fade premier_plan" id="outils_modal_act_tirage" tabindex="-1" aria-hidden="true">`;
  c+= `<div class="modal-dialog modal-lg">`;
  c+= `<div class="modal-content bg-info-subtle">`;
  c+= `<div class="modal-header bg-info d-flex align-items-start justify-content-between py-2 px-2">`;
  c+= `<h1 class="modal-title fs-4">Tirer au sort</h1>`;
  c+= `<div class="d-flex align-items-center">`;
  //c+= `<button id="outils_bt_importer_fond_ecran" class="btn btn-secondary">Importer un fond d'écran</button>`;
  //c+= `<input type="file" id="outils_input_importer_fond_ecran" accept="image/*" style="display:none">`;
  //c+= `<button id="outils_bt_supprimer_fond_ecran" class="btn btn-danger ms-2" title="Supprimer le fond d'écran"><i class="bi bi-trash3-fill"></i></button>`;
  c+= `<button class="btn btn-warning ms-2" data-bs-dismiss="modal" title="Fermer"><i class="bi bi-x-lg"></i></button>`;
  c+= `</div>`;
  c+= `</div>`;// fin .modal-header
  c+= `<div class="modal-body">`;

  c+= `<ul class="nav nav-tabs" id="tirage_tabs" role="tablist">`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link active" id="tirage_de_tab" data-bs-toggle="tab" data-bs-target="#tirage_de" type="button" role="tab" aria-controls="tirage_de" aria-selected="true">Dés</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="tirage_nombre_tab" data-bs-toggle="tab" data-bs-target="#tirage_nombre" type="button" role="tab" aria-controls="tirage_nombre" aria-selected="true">Nombres</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="tirage_mot_tab" data-bs-toggle="tab" data-bs-target="#tirage_mot" type="button" role="tab" aria-controls="tirage_mot" aria-selected="true">Mots</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="tirage_image_tab" data-bs-toggle="tab" data-bs-target="#tirage_image" type="button" role="tab" aria-controls="tirage_image" aria-selected="true">Images</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="tirage_repartition_tab" data-bs-toggle="tab" data-bs-target="#tirage_repartition" type="button" role="tab" aria-controls="tirage_repartition" aria-selected="true">Répartition</button>`;
  c+= `</li>`;

  c+= `</ul>`;// fin #tirage_tabs

  c+= `<div class="tab-content tab_content" id="tirage_content">`;

  c+= `<div class="tab-pane active fond_li" id="tirage_de" role="tabpanel" aria-labelledby="tirage_de_tab">`;
  //c+= `contenu onglet Dé`;
	c+= "<h4 class='premier'>Lancer des dés <button id='box_bt_lancer_des' class='btn btn-primary btn-sm'>Afficher</button></h4>";
	c+= "<h4>Lancer des chiffres <button id='box_bt_lancer_chiffres' class='btn btn-primary btn-sm'>Afficher</button></h4>";
	c+= "<h4>Lancer des lettres <button id='box_bt_lancer_lettres' class='btn btn-primary btn-sm'>Afficher</button></h4>";
	c+= "<h4>Lancer des images d'action <button id='box_bt_lancer_actions' class='btn btn-primary btn-sm'>Afficher</button></h4><p>Les images ont été téléchargées sur le site <a target='_blank' href='https://arasaac.org/'>ARASAAC</a> <em>(licence CC (BY-NC-SA))</em>.</p>";
  c+= `</div>`;//fin #tirage_de

  c+= `<div class="tab-pane fade fond_li" id="tirage_nombre" role="tabpanel" aria-labelledby="tirage_nombre_tab">`;
  //c+= `contenu onglet Nombre`;
	c+= "<h4 class='premier'>Afficher des nombres au hasard <button id='box_bt_nombre_hasard' class='btn btn-primary btn-sm'>Afficher</button></h4><p>La valeur maximale des nombres et la prise en compte ou non des décimales sont paramétrables.</p>";
  c+= `</div>`;//fin #tirage_nombre

  c+= `<div class="tab-pane fade fond_li" id="tirage_mot" role="tabpanel" aria-labelledby="tirage_mot_tab">`;
  //c+= `contenu onglet Mot`;
	c+= "<h4 class='premier'>Afficher des mots au hasard <button id='box_bt_mot_hasard' class='btn btn-primary btn-sm'>Afficher</button></h4><p>On peut choisir de supprimer ou non le mot pour le tirage suivant.</p>";
  c+= `</div>`;//fin #tirage_mot

  c+= `<div class="tab-pane fade fond_li" id="tirage_image" role="tabpanel" aria-labelledby="tirage_image_tab">`;
  //c+= `contenu onglet Image`;
	c+= "<h4 class='premier'>Afficher des images au hasard</h4>";

  c+= `<div class="zone-images" data-image-selector data-max-size="80">`;
  c+= `<h5>Déposer ou sélectionner des images</h5>`;
  c+= `<div class="inputs">`;
  c+= `<input type="file" multiple accept="image/*" class="input-fichiers">`;
  c+= `<input type="file" multiple accept="image/*" webkitdirectory class="input-dossier">`;
  c+= `</div>`;
  c+= `<button class="btn-fichiers btn btn-secondary btn-sm mx-1">Choisir des images</button>`;
  c+= `<button class="btn-dossier btn btn-secondary btn-sm mx-1">Choisir un dossier d'images</button>`;
  c+= `<button class="btn-supprimer-tout btn btn-secondary btn-sm mx-1" type="button">Tout supprimer</button>`;
  c+= `<div id="imhasard_apercu" class="apercu"></div>`;
  c+= `<button id="box_bt_image_hasard" class="btn-test-img-apercu btn btn-sm btn-success disabled" type="button" disabled>Valider ces images</button>`;
  c+= `</div>`;

  c+= `</div>`;//fin #tirage_image

  c+= `<div class="tab-pane fade fond_li" id="tirage_repartition" role="tabpanel" aria-labelledby="tirage_repartition_tab">`;
  //c+= `contenu onglet Répartition`;
	c+= "<h4 class='premier'>Répartir dans des groupes <button id='box_bt_repartir_groupe' class='btn btn-primary btn-sm'>Afficher</button></h4>";
  c+= `<ul><li>Les items à répartir sont soit des mots soit des images.</li>`;
  c+= `<li>On peut créer de 1 à 6 groupes, les nommer et leur associer une couleur.</li>`;
  c+= `<li>Il est plus confortable d'utiliser cet outil dans une fenêtre agrandie au maximum.</li>`;
  c+= `<li><b>Pour changer un item de groupe</b>, cliquer dessus, relâcher, puis cliquer dans le groupe souhaité.</li>`;
  c+= `<li>Les items peuvent être répartis aléatoirement, classés dans l'ordre alphabétique ou placés dans le premier groupe.</li>`;
  c+= `<li>Cet outil est également exploité avec l'outil "Présence" du module "Gérer le groupe".</li>`;
  c+= `<li><b>Pour exporter et importer les groupes</b>, <span style="color:red;">utiliser les boutons d'import/export de ce widget</span>, et non pas les boutons généraux d'import/export.</li></ul>`;
  c+= `</div>`;//fin #tirage_repartition

  c+= ``;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div></div></div>`;
  // Ajouter la modale dans le body
  $("body").append(c);

  modLancerDes();
  modLancerChiffres();
  modLancerLettres();
  modLancerActions();
  modNombreHasard();
  modMotHasard();
  modImageHasard();
  modRepartirGroupes();

}// FIN genererModaleTirage()

function modLancerDes() {
  let c = ``;
  c+= `<div class="d-flex justify-content-center text-center">`;
  c+= `<select id="de_choix_nb" style="width:100px;" class="me-2">`;
  c+= `<option value="1">1 dé</option>`;
  c+= `<option value="2">2 dés</option>`;
  c+= `<option value="3">3 dés</option>`;
  c+= `<option value="4">4 dés</option>`;
  c+= `<option value="5">5 dés</option>`;
  c+= `<option value="6">6 dés</option>`;
  c+= `</select>`;
  c+= `<button class="btn btn-success" id="de_bt_jouer">Lancer !</button>`;
  c+= `</div>`;
  c+= `<div id="de_lesdes" class="mt-3 text-center">`;
  c+= `<div class="de-container"><img id="de_1" src="medias/de/de_logo.png" alt="Dé 1" class="de"></div>`;
  c+= `</div>`;
  
  /* Ouvrir la box Lancer de dés */
  $('#box_bt_lancer_des').on('click', function () {
    creerBox('box_lancer_des', 350, 210, ["box-move", "box-resize"], 'Lancer de dés', 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_tirage')).hide();
    box_lancer_desCode();
  });
}

function box_lancer_desCode() {
  $('#de_choix_nb').val("1");
  function lancerDe(id) {
    const de = document.getElementById(id);
    // Applique une rotation aléatoire pour l’effet visuel
    const rotX = Math.floor(Math.random() * 4 + 1) * 360;
    const rotY = Math.floor(Math.random() * 4 + 1) * 360;
    de.style.transform = `rotateX(${rotX}deg) rotateY(${rotY}deg)`;
    // Simule l'animation de lancer (avec un délai)
    setTimeout(() => {
      const resultat = Math.floor(Math.random() * 6) + 1;
      de.src = `medias/de/de_${resultat}.png`;
    }, 900); // Affiche la face finale juste avant la fin de l’animation
  }

  $('#de_choix_nb').on('change', function () {
    const nbDes = parseInt($('#de_choix_nb').val());
    $('#de_choix_nb option[value="'+nbDes+'"]').prop('selected', true);
    //$('#de_choix_nb option[value="'+nbDes+'"]').attr("selected","selected");
    let tmp = "";
    for (let i=1 ; i <= nbDes ; i++) {
      tmp += `<div class="de-container"><img id="de_${i}" src="medias/de/de_logo.png" alt="Dé ${i}" class="de"></div>`;
    }
    $("#de_lesdes").html(tmp);
  });

  $('#de_bt_jouer').on('click', function () {
    const nbDes = parseInt($('#de_choix_nb').val());
    for (let i=1 ; i <= nbDes ; i++) {
      lancerDe(`de_${i}`);
    }
  });
}

function modLancerChiffres() {
  let c = ``;
  c+= `<div class="d-flex justify-content-center text-center">`;
  c+= `<select id="chiffre_choix_nb" style="width:100px;" class="me-2">`;
  c+= `<option value="1">1 chiffre</option>`;
  c+= `<option value="2">2 chiffres</option>`;
  c+= `<option value="3">3 chiffres</option>`;
  c+= `<option value="4">4 chiffres</option>`;
  c+= `<option value="5">5 chiffres</option>`;
  c+= `<option value="6">6 chiffres</option>`;
  c+= `</select>`;
  c+= `<button class="btn btn-success" id="chiffre_bt_jouer">Lancer !</button>`;
  c+= `</div>`;
  c+= `<div id="chiffre_lesdes" class="mt-3 text-center">`;
  c+= `<div class="de-container"><img id="chiffre_1" src="medias/chiffre/chiffre_logo.png" alt="Chiffre 1" class="de"></div>`;
  c+= `</div>`;

  /* Ouvrir la box Lancer de chiffres */
  $('#box_bt_lancer_chiffres').on('click', function () {
    creerBox('box_lancer_chiffres', 350, 210, ["box-move", "box-resize"], 'Lancer de chiffres', 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_tirage')).hide();
    box_lancer_chiffresCode();
  });
}

function box_lancer_chiffresCode() {
  $('#chiffre_choix_nb').val("1");
  function lancerChiffre(id) {
    const de = document.getElementById(id);
    // Applique une rotation aléatoire pour l’effet visuel
    const rotX = Math.floor(Math.random() * 4 + 1) * 360;
    const rotY = Math.floor(Math.random() * 4 + 1) * 360;
    de.style.transform = `rotateX(${rotX}deg) rotateY(${rotY}deg)`;
    // Simule l'animation de lancer (avec un délai)
    setTimeout(() => {
      const resultat = Math.floor(Math.random() * 10);
      de.src = `medias/chiffre/chiffre_${resultat}.png`;
    }, 900); // Affiche la face finale juste avant la fin de l’animation
  }

  $('#chiffre_choix_nb').on('change', function () {
    const nbDes = parseInt($('#chiffre_choix_nb').val());
    let tmp = "";
    for (let i=1 ; i <= nbDes ; i++) {
      tmp += `<div class="de-container"><img id="chiffre_${i}" src="medias/chiffre/chiffre_logo.png" alt="Chiffre ${i}" class="de"></div>`;
    }
    $("#chiffre_lesdes").html(tmp);
  });

  $('#chiffre_bt_jouer').on('click', function () {
    const nbDes = parseInt($('#chiffre_choix_nb').val());
    for (let i=1 ; i <= nbDes ; i++) {
      lancerChiffre(`chiffre_${i}`);
    }
  });
}

function modLancerLettres() {
  let c = ``;
  c+= `<div class="d-flex justify-content-center text-center">`;
  c+= `<select id="lettre_choix_nb" style="width:100px;" class="me-2">`;
  c+= `<option value="1">1 lettre</option>`;
  c+= `<option value="2">2 lettres</option>`;
  c+= `<option value="3">3 lettres</option>`;
  c+= `<option value="4">4 lettres</option>`;
  c+= `<option value="5">5 lettres</option>`;
  c+= `<option value="6">6 lettres</option>`;
  c+= `</select>`;
  c+= `<button class="btn btn-success" id="lettre_bt_jouer">Lancer !</button>`;
  c+= `</div>`;
  c+= `<div id="lettre_lesdes" class="mt-3 text-center">`;
  c+= `<div class="de-container"><img id="lettre_1" src="medias/lettre/lettre_logo.png" alt="Lettre A" class="de"></div>`;
  c+= `</div>`;

  /* Ouvrir la box Lancer de lettres */
  $('#box_bt_lancer_lettres').on('click', function () {
    creerBox('box_lancer_lettres', 350, 210, ["box-move", "box-resize"], 'Lancer de lettres', 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_tirage')).hide();
    box_lancer_lettresCode();
  });
}

function box_lancer_lettresCode() {
  $('#lettre_choix_nb').val("1");
  function lancerLettre(id) {
    const deLesLettres = ["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"];
    const de = document.getElementById(id);
    // Applique une rotation aléatoire pour l’effet visuel
    const rotX = Math.floor(Math.random() * 4 + 1) * 360;
    const rotY = Math.floor(Math.random() * 4 + 1) * 360;
    de.style.transform = `rotateX(${rotX}deg) rotateY(${rotY}deg)`;
    // Simule l'animation de lancer (avec un délai)
    setTimeout(() => {
      const resultat = deLesLettres[Math.floor(Math.random() * 26)];
      de.src = `medias/lettre/lettre_${resultat}.png`;
    }, 900); // Affiche la face finale juste avant la fin de l’animation
  }

  $('#lettre_choix_nb').on('change', function () {
    const nbDes = parseInt($('#lettre_choix_nb').val());
    let tmp = "";
    for (let i=1 ; i <= nbDes ; i++) {
      tmp += `<div class="de-container"><img id="lettre_${i}" src="medias/lettre/lettre_logo.png" alt="Lettre ${i}" class="de"></div>`;
    }
    $("#lettre_lesdes").html(tmp);
  });

  $('#lettre_bt_jouer').on('click', function () {
    const nbDes = parseInt($('#lettre_choix_nb').val());
    for (let i=1 ; i <= nbDes ; i++) {
      lancerLettre(`lettre_${i}`);
    }
  });
}

function modLancerActions() {
  let c = ``;
  c+= `<div class="d-flex justify-content-center text-center">`;
  c+= `<select id="action_choix_nb" style="width:100px;" class="me-2">`;
  c+= `<option value="1">1 image</option>`;
  c+= `<option value="2">2 images</option>`;
  c+= `<option value="3">3 images</option>`;
  c+= `<option value="4">4 images</option>`;
  c+= `<option value="5">5 images</option>`;
  c+= `<option value="6">6 images</option>`;
  c+= `</select>`;
  c+= `<button class="btn btn-success" id="action_bt_jouer">Lancer !</button>`;
  c+= `</div>`;
  c+= `<div id="action_lesdes" class="mt-3 text-center">`;
  c+= `<div class="de-container"><img id="action_1" src="medias/action/action_logo.png" alt="Image 1" class="de"></div>`;
  c+= `</div>`;

  /* Ouvrir la box Lancer d'images d'actions */
  $('#box_bt_lancer_actions').on('click', function () {
    creerBox('box_lancer_actions', 350, 210, ["box-move", "box-resize"], "Lancer d'images d'actions", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_tirage')).hide();
    box_lancer_actionsCode();
  });
}

function box_lancer_actionsCode() {
  $('#action_choix_nb').val("1");
  function lancerAction(id) {
    const de = document.getElementById(id);
    // Applique une rotation aléatoire pour l’effet visuel
    const rotX = Math.floor(Math.random() * 4 + 1) * 360;
    const rotY = Math.floor(Math.random() * 4 + 1) * 360;
    de.style.transform = `rotateX(${rotX}deg) rotateY(${rotY}deg)`;
    // Simule l'animation de lancer (avec un délai)
    setTimeout(() => {
      const resultat = Math.floor(Math.random() * 237);
      de.src = `medias/action/action_${resultat}.png`;
    }, 900); // Affiche la face finale juste avant la fin de l’animation
  }

  $('#action_choix_nb').on('change', function () {
    const nbDes = parseInt($('#action_choix_nb').val());
    let tmp = "";
    for (let i=1 ; i <= nbDes ; i++) {
      tmp += `<div class="de-container"><img id="action_${i}" src="medias/action/action_logo.png" alt="Image ${i}" class="de"></div>`;
    }
    $("#action_lesdes").html(tmp);
  });

  $('#action_bt_jouer').on('click', function () {
    const nbDes = parseInt($('#action_choix_nb').val());
    for (let i=1 ; i <= nbDes ; i++) {
      lancerAction(`action_${i}`);
    }
  });
}

function modNombreHasard() {
  let c = `<div class="d-flex justify-content-center text-center">`;
  c+= `<select id="nbalea_choix_nb" style="width:150px;" class="me-2">`;
  c+= `<option value="10">< 10</option>`;
  c+= `<option value="20">< 20</option>`;
  c+= `<option value="50">< 50</option>`;
  c+= `<option value="100">< 100</option>`;
  c+= `<option value="1000">< 1 000</option>`;
  c+= `<option value="10000">< 10 000</option>`;
  c+= `<option value="100000">< 100 000</option>`;
  c+= `<option value="1000000">< 1 000 000</option>`;
  c+= `<option value="1000000000">< 1 000 000 000</option>`;
  c+= `</select>`;
  c+= `<div class="form-check form-switch d-flex align-items-center mx-3">`;
  c+= `<input class="form-check-input" type="checkbox" role="switch" id="nbalea_choix_decimal">`;
  c+= `<label class="form-check-label" for="nbalea_choix_decimal">&nbsp;Décimales</label>`;
  c+= `</div>`;
  c+= `<button class="btn btn-success" id="nbalea_bt_jouer">Lancer !</button>`;
  c+= `</div>`;
  c+= `<div class="nbalea_resultats text-center mt-3">`;
  c+= `<button id="nbalea_bt_ecouter" class="nbalea_bt_montrer btn btn-primary mx-1" disabled="disabled" style="display:none;">Écouter</button>`;
  c+= `<button id="nbalea_bt_chiffre" class="nbalea_bt_montrer btn btn-primary mx-1" disabled="disabled" style="display:none;">Voir en chiffres</button>`;
  c+= `<button id="nbalea_bt_lettre" class="nbalea_bt_montrer btn btn-primary mx-1" disabled="disabled" style="display:none;">Voir en lettres</button>`;
  c+= `<div id="nbalea_chiffre_montrer" style="visibility:hidden"></div>`;
  c+= `<div id="nbalea_lettre_montrer" style="visibility:hidden"></div>`;
  c+= `<div id="nbalea_nb_tire" style="display:none;"></div>`;
  c+= `</div>`;

  /* Ouvrir la box Nombre au hasard */
  $('#box_bt_nombre_hasard').on('click', function () {
    creerBox('box_nombre_hasard', 450, 300, ["box-move", "box-resize"], "Nombre au hasard", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_tirage')).hide();
    box_nombre_hasardCode();
  });
}

function box_nombre_hasardCode() {
  $('.nbalea_bt_montrer').prop('disabled', true);

  $('#nbalea_bt_jouer').on('click', function () {
    setTimeout(function(){ $('.nbalea_bt_montrer').prop('disabled', false); }, 2000);
    $('.nbalea_bt_montrer').prop('disabled', true);
    $('.nbalea_bt_montrer').hide().fadeIn(2000);
    $("#nbalea_chiffre_montrer").css("visibility","hidden");
    $("#nbalea_lettre_montrer").css("visibility","hidden");
    const choixNb = parseInt($("#nbalea_choix_nb option:selected").val());
    let partieEntiere = aleatoire(0, choixNb-1);
    let partieDecimale = "";
    if ($("#nbalea_choix_decimal").is(":checked")) {
      // on détermine le nombre de chiffre de la partie décimale
      const nbChDec = aleatoire(1,3);
      if (nbChDec == 1) partieDecimale = aleatoire(1,9);
      if (nbChDec == 2) partieDecimale = aleatoire(0,9)+""+aleatoire(1,9);
      if (nbChDec == 3) partieDecimale = aleatoire(0,9)+""+aleatoire(0,9)+""+aleatoire(1,9);
      // on renseigne les champs
      $("#nbalea_nb_tire").text(partieEntiere+","+partieDecimale);
      $("#nbalea_chiffre_montrer").text(partieEntiere.toLocaleString('fr-FR')+","+partieDecimale);
      $("#nbalea_lettre_montrer").text(nombreEnLettres(partieEntiere)+" virgule "+nombreEnLettres(partieDecimale));
    } else {
      $("#nbalea_nb_tire").text(partieEntiere);
      $("#nbalea_chiffre_montrer").text(partieEntiere.toLocaleString('fr-FR'));
      $("#nbalea_lettre_montrer").text(nombreEnLettres(partieEntiere));
    }
  });

  $('#nbalea_bt_ecouter').on('click', function () {
    const nb = $("#nbalea_nb_tire").text();
    lireSVfr(nb);
  });

  $('#nbalea_bt_chiffre').on('click', function () {
    $("#nbalea_chiffre_montrer").css("visibility","visible");
    animerCaracteres("nbalea_chiffre_montrer", 2000,"0123456789");
    $('#nbalea_bt_chiffre').prop('disabled', true);
  });

  $('#nbalea_bt_lettre').on('click', function () {
    $("#nbalea_lettre_montrer").css("visibility","visible");
    animerCaracteres("nbalea_lettre_montrer", 2000,"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
    $('#nbalea_bt_lettre').prop('disabled', true);
  });

  function animerCaracteres(id, duree, char) {
    const el = document.getElementById(id);
    if (!el) return;

    const originalText = el.textContent;
    const textLength = originalText.length;

    const interval = setInterval(() => {
      let randomText = '';
      for (let i = 0; i < textLength; i++) {
        if (originalText[i] === ' ') {
          randomText += ' ';
        } else {
          const randomIndex = Math.floor(Math.random() * char.length);
          randomText += char[randomIndex];
        }
      }
      el.textContent = randomText;
    }, 100);

    setTimeout(() => {
      clearInterval(interval);
      el.textContent = originalText;
    }, duree);
  }

  /* Convertir un nombre en lettre */
  function nombreEnLettres(n) {
    if (isNaN(n)) return 'valeur non valide';

    const unités = ['', 'un', 'deux', 'trois', 'quatre', 'cinq', 'six', 'sept', 'huit', 'neuf'];
    const dizaines = ['', 'dix', 'vingt', 'trente', 'quarante', 'cinquante', 'soixante'];
    const dixAvingt = ['dix', 'onze', 'douze', 'treize', 'quatorze', 'quinze', 'seize'];

    function convertMoinsDe100(n) {
      if (n < 10) return unités[n];
      if (n < 17) return dixAvingt[n - 10];
      if (n < 20) return 'dix-' + unités[n - 10];
      if (n < 70) {
          let d = Math.floor(n / 10);
          let u = n % 10;
          return dizaines[d] + (u === 1 ? '-et-un' : (u ? '-' + unités[u] : ''));
      }
      if (n < 80) {
          return 'soixante' + (n === 71 ? '-et-onze' : '-' + convertMoinsDe100(n - 60));
      }
      if (n < 100) {
          return 'quatre-vingt' + (n === 80 ? 's' : '-' + convertMoinsDe100(n - 80));
      }
    }

    function convertMoinsDe1000(n) {
      if (n < 100) return convertMoinsDe100(n);
      let c = Math.floor(n / 100);
      let r = n % 100;
      let cent = (c === 1 ? 'cent' : unités[c] + ' cent');
      if (r === 0 && c > 1) cent += 's';
      return cent + (r ? ' ' + convertMoinsDe100(r) : '');
    }

    function convertGroup(n) {
      return convertMoinsDe1000(n);
    }

    function convertEntier(n) {
      const milliards = Math.floor(n / 1e9);
      const millions = Math.floor((n % 1e9) / 1e6);
      const milliers = Math.floor((n % 1e6) / 1000);
      const reste = n % 1000;

      let result = [];

      if (milliards) result.push(milliards === 1 ? 'un milliard' : convertGroup(milliards) + ' milliards');
      if (millions) result.push(millions === 1 ? 'un million' : convertGroup(millions) + ' millions');
      if (milliers) result.push(milliers === 1 ? 'mille' : convertGroup(milliers) + ' mille');
      if (reste) result.push(convertMoinsDe1000(reste));

      return result.join(' ');
    }

    function convertDécimales(decimalStr) {
      if (!decimalStr || Number(decimalStr) === 0) return '';
      let number = parseInt(decimalStr, 10);
      return convertEntier(number);
    }

    const [entierStr, décimaleStr] = n.toString().split(/[.,]/);
    const entier = parseInt(entierStr, 10);
    const partieEntière = entier === 0 ? 'zéro' : convertEntier(entier).trim();
    const partieDécimale = convertDécimales(décimaleStr);

    if (partieDécimale) {
      return `${partieEntière} virgule ${partieDécimale}`;
    } else {
      return partieEntière;
    }
  }
}

function modMotHasard() {
  let c = `<div id="mot_hasard_parametrage" class="text-center">`;
  c+= `<div class="bg-info d-flex align-items-center justify-content-between px-2 py-1 mb-3">`;
  c+= `<div>Paramétrage</div>`;
  c+= `<button id="mot_hasard_bt_valider_param" class="btn btn-success btn-sm">Valider</button>`;
  c+= `</div>`;
  c+= `<h5>Saisir les mots, séparés par un point-virgule.</h5>`;
  c+= `<textarea id="mot_hasard_saisie" class="form-control border border-2 mb-3"></textarea>`;
  c+= `<div class="text-center">`;
  c+= `<h5>Supprimer l'item après le tirage ?</h5>`;
  c+= `<div class="form-check form-check-inline">`;
  c+= `<input class="form-check-input" type="radio" name="mot_hasard_modalite" id="mot_hasard_retirer" value="oui">`;
  c+= `<label class="form-check-label" for="mot_hasard_retirer">oui</label>`;
  c+= `</div>`;
  c+= `<div class="form-check form-check-inline">`;
  c+= `<input class="form-check-input" type="radio" name="mot_hasard_modalite" id="mot_hasard_conserver" value="non" checked>`;
  c+= `<label class="form-check-label" for="mot_hasard_conserver">non</label>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div id="mot_hasard_tirage" class="text-center" style="display:none;">`;
  c+= `<div class="bg-info d-flex align-items-center justify-content-between px-2 py-1 mb-3">`;
  c+= `Mot tiré au sort`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<button id="mot_hasard_bt_retour" class="btn btn-secondary btn-sm me-1">Retour</button>`;
  c+= `<span id="mot_hasard_reste" class="bg-light px-2 me-1" title="Nombre de mots à tirer au sort">?</span>`;
  c+= `<button id="mot_hasard_bt_valider_tirage" class="btn btn-success btn-sm">Tirer au sort</button>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div id="mot_hasard_gagnant" class="border border-5 text-center mb-3">?????</div>`;
  c+= `</div>`;

  /* Ouvrir la box Nombre au hasard */
  $('#box_bt_mot_hasard').on('click', function () {
    creerBox('box_mot_hasard', 460, 280, ["box-move", "box-resize"], "Mot au hasard", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_tirage')).hide();
    box_mot_hasardCode();
  });
}
function box_mot_hasardCode() {
  let listeMots = [];
  let dernierMot = null;

  $('#mot_hasard_bt_valider_param').on('click', function () {
    const texte = $('#mot_hasard_saisie').val();
    listeMots = texte.split(';').map(m => m.trim()).filter(m => m.length > 0);
    dernierMot = null; // réinitialiser le mot précédent
    updateCompteur();
    $("#mot_hasard_parametrage").hide();
    $("#mot_hasard_tirage").show();
  });

  function updateCompteur() {
    $('#mot_hasard_reste').text(listeMots.length);
  }

  $('#mot_hasard_bt_valider_tirage').on('click', function () {
    motHasard();
  });

  $('#mot_hasard_bt_retour').on('click', function () {
    $("#mot_hasard_tirage").hide();
    $("#mot_hasard_parametrage").show();
  });

  function motHasard() {
    if (listeMots.length === 0) {
      $('#mot_hasard_gagnant').text("La liste est vide !");
      return;
    }

    const retirer = $('input[name="mot_hasard_modalite"]:checked').val() === 'oui';

    let tirables = retirer ? listeMots : listeMots.filter(m => m !== dernierMot);

    if (tirables.length === 0) {
      $('#mot_hasard_gagnant').text("Plus de mots à tirer temporairement !");
      return;
    }

    const index = Math.floor(Math.random() * tirables.length);
    const mot = tirables[index];

    // Animation de transition sur 1000ms
    const container = $('#mot_hasard_gagnant');
    const oldWord = container.text();
    const maxLength = Math.max(oldWord.length, mot.length);
    const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';

    let interval;
    let duration = 1000;
    let frame = 0;
    let fps = 30;
    let totalFrames = duration / (1000 / fps);

    clearInterval(interval);
    interval = setInterval(() => {
      let displayed = '';
      for (let i = 0; i < maxLength; i++) {
        if (frame < totalFrames - 2) {
          // Random character
          displayed += chars.charAt(Math.floor(Math.random() * chars.length));
        } else {
          // Final word
          displayed += mot[i] || '';
        }
      }
      container.text(displayed);
      frame++;
      if (frame >= totalFrames) {
        clearInterval(interval);
        container.text(mot);
      }
    }, 1000 / fps);

    if (retirer) {
      const i = listeMots.indexOf(mot);
      if (i !== -1) listeMots.splice(i, 1);
    } else {
      dernierMot = mot;
    }

    updateCompteur();
  }
}

function modImageHasard() {
  let c = ``;
  c+= `<div class="d-flex justify-content-center text-center">`;
  c+= `<select id="image_choix_nb" style="width:100px;" class="me-2">`;
  c+= `<option value="1">1 image</option>`;
  c+= `<option value="2">2 images</option>`;
  c+= `<option value="3">3 images</option>`;
  c+= `<option value="4">4 images</option>`;
  c+= `<option value="5">5 images</option>`;
  c+= `<option value="6">6 images</option>`;
  c+= `</select>`;
  c+= `<button class="btn btn-success" id="image_bt_jouer">Lancer !</button>`;
  c+= `</div>`;
  c+= `<div id="image_lesdes" class="mt-3 text-center">`;
  c+= `<div class="image-container"><img id="image_1" src="medias/de/image_logo.png" alt="Image 1" class="de"></div>`;
  c+= `</div>`;

  /* Ouvrir la box Image au hasard */
  $('#box_bt_image_hasard').on('click', function () {

    creerBox('box_image_hasard', 350, 210, ["box-move", "box-resize"], "Image au hasard", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_tirage')).hide();

    const htmlImages = $("#imhasard_apercu").html();
    $("#box_image_hasard .box-content").append("<div id='images_images_hasard' style='display:none;'>"+htmlImages+"</div>");

    box_bt_image_hasardCode();

  });
 
}// fin function modImageHasard() {

function box_bt_image_hasardCode() {

  let nbImages = $("#images_images_hasard img").length;
  let tabImages = [];
  $("#images_images_hasard img").each(function(i) {
    const src = $(this).attr("src");
    tabImages.push(src);
  });
  console.log(tabImages.length)

  $('#image_choix_nb').val("1");
  function lancerDe(id) {
    const de = document.getElementById(id);
    // Applique une rotation aléatoire pour l’effet visuel
    const rotX = Math.floor(Math.random() * 4 + 1) * 360;
    const rotY = Math.floor(Math.random() * 4 + 1) * 360;
    de.style.transform = `rotateX(${rotX}deg) rotateY(${rotY}deg)`;
    // Simule l'animation de lancer (avec un délai)
    setTimeout(() => {
      const resultat = Math.floor(Math.random() * nbImages);
      console.log(resultat)
      de.src = tabImages[resultat];
    }, 900); // Affiche la face finale juste avant la fin de l’animation
  }

  $('#image_choix_nb').on('change', function () {
    const nbDes = parseInt($('#image_choix_nb').val());
    let tmp = "";
    for (let i=1 ; i <= nbDes ; i++) {
      tmp += `<div class="de-container"><img id="image_${i}" src="medias/de/image_logo.png" alt="Image ${i}" class="de"></div>`;
    }
    $("#image_lesdes").html(tmp);
  });

  $('#image_bt_jouer').on('click', function () {
    const nbDes = parseInt($('#image_choix_nb').val());
    for (let i=1 ; i <= nbDes ; i++) {
      lancerDe(`image_${i}`);
    }
  });
}

function modRepartirGroupes() {
  let c = `<div class="container-fluid">`;
  c+= `<div id="repart_aff_param">`;
  c+= `<div class="bg-info d-flex align-items-center justify-content-between px-2 py-1 mb-3">`;
  c+= `<div>`;
  c+= `<button id="repart_bt_choix_texte" class="btn btn-dark btn-sm repart_choix_type_item me-1" title="Répartir des items sous forme de texte">Texte</button>`;
  c+= `<button id="repart_bt_choix_image" class="btn btn-outline-dark btn-sm repart_choix_type_item me-1" title="Répartir des items sous forme d'image">Image</button>`;
  c+= `<input type="file" id="repart_input_importer_json" accept=".json" style="display:none;" />`;
  c+= `</div>`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<button id="repart_bt_importer_json" class="btn btn-outline-dark btn-sm me-1 px-2 py-0" title="Importer un fichier JSON"><i class="bi bi-download" style="font-size:1.4em;"></i></button>`;
  c+= `<button id="repart_bt_afficher_tout" class="btn btn-success btn-sm">Générer les groupes</button>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div id="repart_si_texte" class="repart_texteouimage text-center">`;
  c+= `<h5>Saisir les items séparés par un point-virgule.</h5>`;
  c+= `<textarea id="repart_saisie_mots" class="form-control mb-3"></textarea>`;
  c+= `</div>`;
  c+= `<div id="repart_si_image" class="repart_texteouimage" style="display:none;">`;
  c+= `<div class="zone-images zone_repart" data-image-selector data-max-size="80">`;
  c+= `<h5>Déposer ou sélectionner des images</h5>`;
  c+= `<div class="inputs">`;
  c+= `<input type="file" multiple accept="image/*" class="input-fichiers">`;
  c+= `<input type="file" multiple accept="image/*" webkitdirectory class="input-dossier">`;
  c+= `</div>`;
  c+= `<button class="btn-fichiers btn btn-secondary btn-sm mx-1">Choisir des images</button>`;
  c+= `<button class="btn-dossier btn btn-secondary btn-sm mx-1">Choisir un dossier d'images</button>`;
  c+= `<button class="btn-supprimer-tout btn btn-secondary btn-sm mx-1" type="button">Tout supprimer</button>`;
  c+= `<div id="repart_img_selectionnees" class="apercu"></div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<h5 class="text-center">Ajouter ou supprimer des groupes, et les nommer</h5>`;
  c+= `<div id="repart_groupes_a_ajouter" class="mb-3"></div>`;
  c+= `</div>`;
  c+= `<div id="repart_aff_groupes" style="display:none;">`;
  c+= `<div class="bg-info d-flex align-items-center justify-content-between px-2 py-1 mb-3">`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<button id="repart_bt_items_col1" class="btn btn-secondary btn-sm me-1 px-2 py-0" title="Placer tous les items dans la 1ère colonne"><i class="bi bi-layout-sidebar-inset" style="font-size:1.4em;"></i></button>`;
  c+= `<button id="repart_bt_items_alea" class="btn btn-secondary btn-sm me-1 px-2 py-0" title="Répartir aléatoirement"><i class="bi bi-shuffle" style="font-size:1.4em;"></i></button>`;
  c+= `<button id="repart_bt_item_alpha" class="btn btn-secondary btn-sm me-1 px-2 py-0" title="Présenter les items dans l'ordre alphabétique"><i class="bi bi-sort-alpha-down" style="font-size:1.4em;"></i></button>`;
  c+= `</div>`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<input id="repart_taille" type="number" min="1" max="6" value="2" style="font-size:1.05em;" class="ms-1" title="Changer la taille des items">`;
  c+= `<button id="repart_bt_exporter_json" class="btn btn-outline-dark btn-sm ms-1 px-2 py-0" title="Exporter au format JSON"><i class="bi bi-upload" style="font-size:1.4em;"></i></button>`;
  c+= `<button id="repart_bt_retour" class="btn btn-success btn-sm ms-1 px-2 py-0" title="Retourner au paramétrage"><i class="bi bi-escape" style="font-size:1.4em;"></i></button>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div id="repart_conteneur">`;
  c+= `<div class="row"></div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div>`;
  

  /* Ouvrir la box Répartir dans des groupes */
  $('#box_bt_repartir_groupe').on('click', function () {
    creerBox('box_repartir_groupe', 600, 430, ["box-move", "box-resize"], "Répartir dans des groupes", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_tirage')).hide();
    box_repartir_groupeCode();
  });
}

function box_repartir_groupeCode() {
  const repartHtmlSaisieGroupe =    `<div class="input-group mb-1 repart_gpe_bts_saisie">
                                      <input type="color" value="#FFFFFF" class="repart_color">
                                      <input type="text" class="form-control repart_saisie_nom_groupe" placeholder="Nom du groupe">
                                      <button class="btn btn-outline-secondary repart_bt_ajouter_groupe repart_bts_aj_sup_gpe py-0 px-2"><i class="bi bi-plus-circle" style="font-size:1.5em;"></i></button>
                                      <button class="btn btn-outline-secondary repart_bt_supprimer_groupe repart_bts_aj_sup_gpe py-0 px-2"><i class="bi bi-dash-circle" style="font-size:1.5em;"></i></button>
                                    </div>`;
  let repartNbGroupes = 1;
  let repartTabItems = [];// tableau des items
  let repartTypeItem = "texte";
  let repartData = [];
  let repartTabColHtml = [];

  $("#repart_groupes_a_ajouter").html(repartHtmlSaisieGroupe);
  if ($("#repart_aff_param").hasClass("repart_presence")) repartPresence();
  verifierNbGroupe();

  /* Ajout pour présence */
  function repartPresence() {
    $("#repart_groupes_a_ajouter").append(repartHtmlSaisieGroupe);
    $("#repart_groupes_a_ajouter").append(repartHtmlSaisieGroupe);
    repartNbGroupes = 3;
    $(".repart_gpe_bts_saisie:nth-child(1) .repart_saisie_nom_groupe").val("🏠 À la maison");
    $(".repart_gpe_bts_saisie:nth-child(2) .repart_saisie_nom_groupe").val("🕑 À l'école");
    $(".repart_gpe_bts_saisie:nth-child(3) .repart_saisie_nom_groupe").val("🥣 À la cantine");
  }

  /* Switcher entre item texte ou item image */
  $('.repart_choix_type_item').on('click', function () {
    $('.repart_choix_type_item').removeClass("btn-dark").addClass("btn-outline-dark");
    $(this).removeClass("btn-outline-dark").addClass("btn-dark");
    $(".repart_texteouimage").hide();
    if ($(this).attr("id") === "repart_bt_choix_texte") {
      repartTypeItem = "texte";
      $("#repart_si_texte").fadeIn(); 
    } else {
      repartTypeItem = "image";
      $("#repart_si_image").fadeIn();
    } 
  });

  /* Ajouter un groupe */
  $("#repart_groupes_a_ajouter").on("click", ".repart_bt_ajouter_groupe", function () {
    if (repartNbGroupes < 5) $(this).parent().after(repartHtmlSaisieGroupe);
    repartNbGroupes++;
    $(this).parent().next().find("input").focus();
    verifierNbGroupe();
  });

  /* Supprimer un groupe */
  $("#repart_groupes_a_ajouter").on("click", ".repart_bt_supprimer_groupe", function () {
    if (repartNbGroupes > 1) $(this).parent().remove();
    repartNbGroupes--;
    verifierNbGroupe();
  });

  /* Gérer le disabled des + et - */
  function verifierNbGroupe() {
    $(".repart_bts_aj_sup_gpe").prop("disabled",true);
    if (repartNbGroupes > 1) $(".repart_bt_supprimer_groupe").prop("disabled",false);
    if (repartNbGroupes < 5) $(".repart_bt_ajouter_groupe").prop("disabled",false);
  }

  /* Générer et afficher les groupes */
  $('#repart_bt_afficher_tout').on('click', function () {
    repartGenererItems();
    if (repartTabItems.length > 0) {
      $("#repart_aff_param").hide();
      $("#repart_aff_groupes").fadeIn();
      genererRepartDataAvecItems(repartTabItems);
      repartAfficherItems();
    } else {
      if (repartTypeItem === "texte") alert("Saisir des mots séparés par un point-virgule.");
      if (repartTypeItem === "image") alert("Déposer ou sélectionner des images.");
    }
  });

  /* Identifier l'item cliqué avec la class on */
  $("#repart_conteneur").on("click", ".repart_item", function (e) {
    $(".repart_item").removeClass("on");
    $(this).addClass("on");
    $('#repart_conteneur .repart_col').css("cursor","crosshair");
    e.stopPropagation();
  });

  /* Déplacer l'item actif */
  $("#repart_conteneur").on("click", ".repart_col", function (e) {
    if ($('#repart_conteneur .repart_col').css("cursor") === "crosshair") {
      const indice = $('#repart_conteneur .repart_col').index(this);
      if (repartTypeItem === "texte") {
        const cntItem = $(".repart_item.on").text();
        $(".repart_col:eq("+indice+") .repart_conteneur_items").append("<li class='repart_item'>"+cntItem+"</li>");
      } else {
        const src = $(".repart_item.on").attr("src");
        const alt = $(".repart_item.on").attr("alt");
        $(".repart_col:eq("+indice+") .repart_conteneur_items").append("<img alt=\""+alt+"\" title=\""+alt+"\" class='repart_item' src='"+src+"'>");
      }
      $(".repart_item.on").remove();
      $('#repart_conteneur .repart_col').css("cursor","default");
      repartCompterItems();
    }
  });

  /* Retourner aux paramètres */
  $('#repart_bt_retour').on('click', function () {
    $("#repart_aff_groupes").hide();
    $("#repart_aff_param").fadeIn();
  });

  /* Changer la taille */
  $('#repart_taille').on('change', function () {
    repartChangerTaille();
  });

  /* Déplacer les items dans la colonne 1 */
  $('#repart_bt_items_col1').on('click', function () {
    repartItemsCol1();
  });

  /* Placer les items aléatoirement */
  $('#repart_bt_items_alea').on('click', function () {
    repartItemsAlea();
  });

  /* Placer les items dans l'ordre alpha */
  $('#repart_bt_item_alpha').on('click', function () {
    repartItemsAlpha();
  });

  /* Exporter en JSON */
  $('#repart_bt_exporter_json').on('click', function () {
    let data = [];
    $('#repart_conteneur .repart_col').each(function() {
      let lacol = $(this);
      let titre = lacol.find(".repart_titre_gpe").text();
      let coul = lacol.css("background-color");
      let tabIt = [];
      $(lacol).find(".repart_item").each(function() {
        if (repartTypeItem === "texte") {
          const litem = $(this).text();
          tabIt.push("<li class='repart_item'>"+litem+"</li>");
        }
        if (repartTypeItem === "image") {
          const src = $(this).attr("src");
          const alt = $(this).attr("alt");
          tabIt.push("<img alt=\""+alt+"\" title=\""+alt+"\" class='repart_item' src='"+src+"'>");
        }
      });
      data.push({
        titre: titre,
        couleur: coul,
        items: tabIt
      });
    });

    const blob = new Blob([JSON.stringify(data)], { type: "application/json" });
    const url = URL.createObjectURL(blob);
    const a = document.createElement("a");
    a.href = url;
    //a.download = "TEST.json";
    a.download = "repartition-"+afficherDateEnr()+".json";
    a.click();
    URL.revokeObjectURL(url);

  });

  /* Importer un fichier Json exporté (déclenchement) */
  $('#repart_bt_importer_json').on('click', () => {
    $('#repart_input_importer_json').click();
  });
  $('#repart_input_importer_json').on('change', function () {
    const file = this.files[0];
    if (!file) return;
    const reader = new FileReader();
    reader.onload = function (e) {
      try {
        repartData = JSON.parse(e.target.result);
        repartImporterJson();
      } catch (err) {
        alert('Erreur lors de l\'import : ' + err.message);
      }
    };
    reader.readAsText(file);
  });

  /* Importer un fichier Json exporté (fonction) */
  function repartImporterJson() {
    // restaurer l'état des boutons texte et image
    $('.repart_choix_type_item').removeClass("btn-dark").addClass("btn-outline-dark");
    $(".repart_texteouimage").hide();
    if (repartData[0]["items"][0][1] === "i") {
      repartTypeItem = "image";
      $("#repart_bt_choix_image").removeClass("btn-outline-dark").addClass("btn-dark");
      $("#repart_si_image").fadeIn();
    } else {
      repartTypeItem = "texte";
      $("#repart_bt_choix_texte").removeClass("btn-outline-dark").addClass("btn-dark");
      $("#repart_si_texte").fadeIn();
    }
    // restaurer le tableau des items repartTabItems
    repartTabItems = repartData.flatMap(group => group.items);
    // restaurer le textarea ou les images de l'aperçu
    if (repartTypeItem === "image") {
      let tabTmp = [];
      for (let i=0 ; i < repartTabItems.length ; i++) {
        tabTmp.push("<div class='image-container'>"+repartTabItems[i]+"<button class='close-btn'>×</button></div>");
      }
      $("#repart_img_selectionnees").html(tabTmp.join(""));
      $("#repart_img_selectionnees img").removeClass("repart_item");
      $("#repart_img_selectionnees").on("click", ".close-btn", function () {// Réactiver le clic sur les boutons de suppression après import
        $(this).closest(".image-container").remove();
      });
    } else {
      let itemsEnTexte = repartTabItems.map(item => item.match(/>(.*?)</)[1]).join(";");
      $("#repart_saisie_mots").val(itemsEnTexte);
    }
    // restaurer les groupes//#repart_groupes_a_ajouter
    $("#repart_groupes_a_ajouter").html("");
    repartData.forEach((gpe, index) => {
      const titre = gpe.titre === "" ? "&nbsp;" : gpe.titre;
      const coul = gpe.couleur;
      $("#repart_groupes_a_ajouter").append(
        `<div class="input-group mb-1 repart_gpe_bts_saisie">
          <input type="color" value="`+coul+`" class="repart_color">
          <input type="text" class="form-control repart_saisie_nom_groupe" placeholder="Nom du groupe" value="`+titre+`">
          <button class="btn btn-outline-secondary repart_bt_ajouter_groupe repart_bts_aj_sup_gpe py-0 px-2"><i class="bi bi-plus-circle" style="font-size:1.5em;"></i></button>
          <button class="btn btn-outline-secondary repart_bt_supprimer_groupe repart_bts_aj_sup_gpe py-0 px-2"><i class="bi bi-dash-circle" style="font-size:1.5em;"></i></button>
        </div>`);
    })

    // afficher les groupes
    $("#repart_aff_param").hide();
    $("#repart_aff_groupes").fadeIn();
    repartAfficherItems();
  }

  /* Changer la taille  */
  function repartChangerTaille() {
    const taille = parseInt($("#repart_taille").val());
    if (taille >= 1 && taille <= 6) $(".repart_conteneur_items").removeClass("taille_1 taille_2 taille_3 taille_4 taille_5 taille_6").addClass("taille_"+taille);
  }

  /* Générer le tableau des items => maj de repartTabItems */
  function repartGenererItems() {
    repartTabItems = [];
    let tabTmp = [];
    if (repartTypeItem === "texte") {
      let ctnListe = $("#repart_saisie_mots").val().trim();
      if (ctnListe !== "") {
        tabTmp = ctnListe.split(";");
        for (let i=0 ; i < tabTmp.length ; i++) {
          let litem = tabTmp[i].trim();
          if (litem !== "") repartTabItems.push("<li class='repart_item'>"+litem+"</li>");
        }
      }
    } else {
      // s'il y a des images, on récupère leurs propriétés
      if ($("#repart_img_selectionnees .image-container > img").length > 0) {
        $("#repart_img_selectionnees .image-container > img").each(function(i) {
          const src = $(this).attr("src");
          const alt = $(this).attr("alt");
          repartTabItems[i] = "<img alt=\""+alt+"\" title=\""+alt+"\" class='repart_item' src='"+src+"'>";
        });
      }
    }
  }

  /* Renseigner repartData */
  function genererRepartDataAvecItems(repartTabItems) {
    repartData = [];

    // Récupérer les titres et les couleurs, et initialiser les groupes
    $('#repart_groupes_a_ajouter .repart_saisie_nom_groupe').each(function() {
      let titre = $(this).val();
      let coul = $(this).prev().val();
      repartData.push({
        titre: titre,
        couleur: coul,
        items: []
      });
    });

    // Répartir les items dans les groupes (répartition cyclique)
    repartTabItems.forEach((item, index) => {
      let groupIndex = index % repartData.length;
      repartData[groupIndex].items.push(item);
    });
  }

  /* Placer les items dans l'odre alpha */
  function repartItemsAlpha() {
    $('#repart_conteneur .repart_conteneur_items').each(function(c) {
      let colIt = $(this);
      let ctnIt = $(this).html();
      let tabIt = [];
      if (repartTypeItem === "texte") {
        let tabItGpe = [];
        $(colIt).find("li").each(function(i) {
          tabItGpe.push($(this).text());
        });
        for (let t=0 ; t < tabItGpe.length ; t++) {
          tabItGpe[t] = "<li class='repart_item'>"+tabItGpe[t]+"</li>";
        }
        tabItGpe.sort();
        $('#repart_conteneur .repart_conteneur_items:eq('+c+')').html(tabItGpe.join(""));
      }
      if (repartTypeItem === "image") {
        let tabItGpe = [];
        $(colIt).find("img").each(function(i) {
          tabItGpe.push([$(this).attr("src") , $(this).attr("alt")]);
        });
        for (let t=0 ; t < tabItGpe.length ; t++) {
          tabItGpe[t] = "<img alt=\""+tabItGpe[t][1]+"\" title=\""+tabItGpe[t][1]+"\" class='repart_item' src='"+tabItGpe[t][0]+"'>";
        }
        tabItGpe.sort();
        $('#repart_conteneur .repart_conteneur_items:eq('+c+')').html(tabItGpe.join(""));
      }
    });
  }

  /* Placer les items dans la 1ère colonne */
  function repartItemsCol1() {
    for (let i=0 ; i < repartNbGroupes ; i++) {
      if (i === 0) repartData[i].items = repartTabItems;
      else repartData[i].items = [];
    }
    repartAfficherItems();
  }

  /* Placer les items aléatoirement dans les colonnes */
  function repartItemsAlea() {
    shuffle(repartTabItems);
    genererRepartDataAvecItems(repartTabItems);  
    repartAfficherItems();
  }

  /* Afficher les items dans les groupes */
  function repartAfficherItems() {
    $("#repart_conteneur > .row").html("");
    repartData.forEach((gpe, index) => {
      const titre = gpe.titre === "" ? "&nbsp;" : gpe.titre;
      $("#repart_conteneur > .row").append(`<div class="col-md"><div class="repart_col" style="background-color:`+gpe.couleur+`;"><h5><span class='repart_titre_gpe'>`+titre+`</span> <span class='repart_nb_items'>(0)</span></h5><div class="repart_conteneur_items">`+gpe.items.join("")+`</div></div></div>`);
    })
    repartChangerTaille();
    repartCompterItems();
  }

  function repartCompterItems() {
    $(".repart_col").each(function() {
      const col = $(this);
      const nb = col.find(".repart_item").length;
      const titre = col.find(".repart_titre_gpe").text();
      col.find("h5").html(`<span class='repart_titre_gpe'>`+titre+`</span> <span class='repart_nb_items'>(`+nb+`)</span>`);
    });
  }

  initImageSelectorZone(document.querySelector('.zone_repart'));
}


/*
function modNombreHasard() {
  let c = ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;

  /* Ouvrir la box Nombre au hasard MODELE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  $('#box_bt_nombre_hasard').on('click', function () {
    creerBox('box_nombre_hasard', 350, 210, ["box-move", "box-resize"], "Nombre au hasard", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_tirage')).hide();
    box_nombre_hasardCode();
  });
}
function box_nombre_hasardCode() {
  // script....
}
*/