/*****************************************/
/* Fonctions de Temps                    */
/*****************************************/

/* Générer et gérer la modale de temps */
function genererModaleTemps() {
  // Génération de la modale
  let c = "";
  c+= `<div class="modal fade premier_plan" id="outils_modal_act_temps" tabindex="-1" aria-hidden="true">`;
  c+= `<div class="modal-dialog modal-lg">`;
  c+= `<div class="modal-content bg-info-subtle">`;
  c+= `<div class="modal-header bg-info d-flex align-items-start justify-content-between py-2 px-2">`;
  c+= `<h1 class="modal-title fs-4">Gérer le temps</h1>`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<button class="btn btn-warning ms-2" data-bs-dismiss="modal" title="Fermer"><i class="bi bi-x-lg"></i></button>`;
  c+= `</div>`;
  c+= `</div>`;// fin .modal-header
  c+= `<div class="modal-body">`;

  c+= `<ul class="nav nav-tabs" id="temps_tabs" role="tablist">`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link active" id="temps_minuterie_tab" data-bs-toggle="tab" data-bs-target="#temps_minuterie" type="button" role="tab" aria-controls="temps_minuterie" aria-selected="true">Minuterie</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="temps_chronometre_tab" data-bs-toggle="tab" data-bs-target="#temps_chronometre" type="button" role="tab" aria-controls="temps_chronometre" aria-selected="true">Chronomètre</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="temps_metronome_tab" data-bs-toggle="tab" data-bs-target="#temps_metronome" type="button" role="tab" aria-controls="temps_metronome" aria-selected="true">Métronome</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="temps_heure_tab" data-bs-toggle="tab" data-bs-target="#temps_heure" type="button" role="tab" aria-controls="temps_heure" aria-selected="true">Heure</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="temps_calendrier_tab" data-bs-toggle="tab" data-bs-target="#temps_calendrier" type="button" role="tab" aria-controls="temps_calendrier" aria-selected="true">Calendrier</button>`;
  c+= `</li>`;

  c+= `</ul>`;// fin #temps_tabs

  c+= `<div class="tab-content tab_content" id="temps_content">`;

  c+= `<div class="tab-pane active" id="temps_minuterie" role="tabpanel" aria-labelledby="temps_minuterie_tab">`;
  //c+= `contenu onglet Minuterie`;
	c+= "<h4 class='premier'>Programmer une minuterie <em>(un timer)</em> <button id='box_bt_minuterie' class='btn btn-primary btn-sm'>Afficher</button></h4>";
  c+= `<p>La minuterie peut être utilisée comme un timer "classique", ou dans une situation où jusqu'à 6 équipes <em>(ou joueurs)</em> visualisent leur temps imparti, chaque équipe étant alors reconnaissable par une couleur.</p>`;
	c+= `<h4 class='premier'>Programmer une alarme <div style="font-size:16px; color:black;" class="ms-2 form-check form-switch form-check-inline"><input class="form-check-input" type="checkbox" role="switch" id="outils_bt_choix_alarme"><label class="form-check-label" for="outils_bt_choix_alarme">Alarme désactivée</label></div></h4>`;
  c+= `<p>L'état <em>(activée ou non)</em> de l'alarme est symbolisé dans la barre d'outils par une cloche barrée ou non.</p>`;
  c+= `<div id="outils_alarme_medias">`;
  c+= `<h5>Sélectionner l'heure à laquelle déclencher l'alarme : <select id="outil_alarme_heure">`+retournerOptionsHeure()+`</select> h. <select id="outil_alarme_minute">`+retournerOptionsMinute()+`</select> min.</h5>`;
  c+= `<h5 class='mt-3'>Sélectionner l'audio écouté au déclenchement de l'alarme :</h5>`;
  c+= `<div id="outils_alarme_choix_media" class="mb-2">`;
  c+= `<img data-choix="muet" alt="aucun son" title="aucun son" class="effet_bt_zoom on" src="medias/alarmes/muet.png">`;
  c+= `<img data-choix="accident" alt="accident" title="accident" class="effet_bt_zoom" src="medias/alarmes/accident.png">`;
  c+= `<img data-choix="bateau" alt="bateau" title="bateau" class="effet_bt_zoom" src="medias/alarmes/bateau.png">`;
  c+= `<img data-choix="cartoon" alt="cartoon" title="cartoon" class="effet_bt_zoom" src="medias/alarmes/cartoon.png">`;
  c+= `<img data-choix="coq" alt="coq" title="coq" class="effet_bt_zoom" src="medias/alarmes/coq.png">`;
  c+= `<img data-choix="farwest" alt="farwest" title="farwest" class="effet_bt_zoom" src="medias/alarmes/farwest.png">`;
  c+= `<img data-choix="gameover" alt="gameover" title="gameover" class="effet_bt_zoom" src="medias/alarmes/gameover.png">`;
  c+= `<img data-choix="loup" alt="loup" title="loup" class="effet_bt_zoom" src="medias/alarmes/loup.png">`;
  c+= `<img data-choix="sirene" alt="sirène" title="sirène" class="effet_bt_zoom" src="medias/alarmes/sirene.png">`;
  c+= `<img data-choix="train" alt="train" title="train" class="effet_bt_zoom" src="medias/alarmes/train.png">`;
  c+= `<img data-choix="trophee" alt="trophee" title="trophee" class="effet_bt_zoom" src="medias/alarmes/trophee.png">`;
  c+= `</div>`;
  c+= `<h5 class='mt-3'>Saisir le texte affiché au déclenchement de l'alarme <em>(facultatif)</em> :</h5>`;
  c+= `<input id="outils_saisie_texte_alarme" type="text" class="form-control bg-primary-subtle">`;
  c+= `</div>`;
  c+= `</div>`;//fin #temps_minuterie

  c+= `<div class="tab-pane fade" id="temps_chronometre" role="tabpanel" aria-labelledby="temps_chronometre_tab">`;
  //c+= `contenu onglet Chronomètre`;
	c+= "<h4 class='premier'>Utiliser un chronomètre redimensionnable <button id='box_bt_chrono_redim' class='btn btn-primary btn-sm'>Afficher</button></h4>";
	c+= "<h4>Utiliser un chronomètre multifonctions <button id='box_bt_chrono_multi' class='btn btn-primary btn-sm'>Afficher</button></h4><p>Ce chronomètre permet d'enregistrer des temps intermédiaires, et d'être averti <em>(via un flash ou une sonnerie)</em> toutes les X secondes, X étant paramétrable.</p>";
  c+= `</div>`;//fin #temps_chronometre

  c+= `<div class="tab-pane fade" id="temps_metronome" role="tabpanel" aria-labelledby="temps_metronome_tab">`;
  //c+= `contenu onglet Métronome`;
	c+= "<h4 class='premier'>Utiliser un métronome <button id='box_bt_metronome' class='btn btn-primary btn-sm'>Afficher</button></h4>";
  c+= `<p>Ce métronome permet de sélectionner l'intrument marquant les temps fort et celui marquant les temps faibles, le nombre de temps <em>(de 1 à 4)</em>, l'émission ou non d'un son ou d'un flash à chaque temps, et de définir le tempo.</p>`;
  c+= `</div>`;//fin #temps_metronome

  c+= `<div class="tab-pane fade" id="temps_heure" role="tabpanel" aria-labelledby="temps_heure_tab">`;
  //c+= `contenu onglet Heure`;
	c+= `<h4 class='premier'>Afficher l'heure dans la barre d'outils <div style="font-size:16px; color:black;" class="ms-2 form-check form-switch form-check-inline"><input class="form-check-input" type="checkbox" role="switch" id="outils_bt_choix_heure" checked><label class="form-check-label" for="outils_bt_choix_heure">Heure visible</label></div></h4>`;
	c+= "<h4>Afficher une horloge analogique <button id='box_bt_horloge' class='btn btn-primary btn-sm'>Afficher</button></h4>";
  c+= `</div>`;//fin #temps_heure

  c+= `<div class="tab-pane fade" id="temps_calendrier" role="tabpanel" aria-labelledby="temps_calendrier_tab">`;
  //c+= `contenu onglet Calendrier`;
	c+= "<h4 class='premier'>Gérer un mini-agenda <button id='box_bt_agenda' class='btn btn-primary btn-sm'>Afficher</button></h4>";
  c+= `Cliquer sur un jour du calendrier permet de saisir une note. Les notes peuvent être exportées et importées, et sont automatiquement enregistrées dans l'espace LocalStorage du navigateur Web utilisé.`;
	c+= "<h4>Afficher le jour dans plusieurs langues <button id='box_bt_jour' class='btn btn-primary btn-sm'>Afficher</button></h4><p>Français, Anglais GB, Anglais US, Italien, Espagnol, Allemand et Portugais</p>";
  c+= `</div>`;//fin #temps_calendrier

  c+= ``;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div></div></div>`;
  // Ajouter la modale dans le body
  $("body").append(c);

  //alert("id_"+Date.now())
  modHorloge();
  modNinuterie();
  modChronoRedim();
  modChronoMulti();
  modMetronome();
  modAgenda();
  modJour();

  /* Switcher entre l'affichage de l'heure ou non */
  $('#outils_bt_choix_heure').on('click', function () {
    if ($(this).is(":checked")) {
      $(this).next().text("Heure visible");
      $("#outils_heure").show();
    } else {
      $(this).next().text("Heure masquée");
      $("#outils_heure").hide();
    }
  });

  /* Switcher entre l'activation de l'alarme ou non */
  $('#outils_bt_choix_alarme').on('click', function () {
    if ($(this).is(":checked")) {
      $(this).next().text("Alarme activée");
      $("#outils_alarme_cloche").html("<i class='bi bi-bell'></i>");
      $('#outils_alarme_medias').addClass("active");
    } else {
      $(this).next().text("Alarme désactivée");
      $("#outils_alarme_cloche").html("<i class='bi bi-bell-slash'></i>");
      $('#outils_alarme_medias').removeClass("active");
    }
  });

  /* Sélectionner le média de l'alarme */
  $('#outils_alarme_choix_media img').on('click', function () {
    $("#outils_alarme_choix_media img").removeClass("on");
    $(this).addClass("on");
    const choix = $(this).attr("data-choix");
    if (choix === "muet") alert("Aucun son ne sera émis.");
    else {
      let sonNew = new Audio();
      sonNew.src = "medias/alarmes/"+choix+".mp3";
      sonNew.play();
    } 
  });

  /* Générer et afficher les heures du select */
  function retournerOptionsHeure() {
    let h = "";
    for (let i=0 ; i <= 24 ; i++) {
      const lheure = i < 10 ? "0"+i : i ;
      h += "<option>"+lheure+"</option>";
    }
    return h;
  }

  /* Générer et afficher les minutes du select */
  function retournerOptionsMinute() {
    let m = "";
    for (let i=0 ; i <= 60 ; i++) {
      const lamin = i < 10 ? "0"+i : i ;
      m += "<option>"+lamin+"</option>";
    }
    return m;
  }

}// FIN genererModaleTemps()

let timerHorloge;
function modHorloge() {
  let c = `<div id="horloge-container"></div>`;

  /* Ouvrir la box Horloge analogique */
  $('#box_bt_horloge').on('click', function () {
    creerBox('box_horloge', 180, 210, ["box-move"], "Horloge", 10, 10, html=c, null, true, $('#box-container'),
      function (boxId) {
        //console.log('Box fermée :', boxId);
        if (timerHorloge) {
          clearInterval(timerHorloge);
          //console.log(`Horloge de ${boxId} arrêtée.`);
        }
      }
    );
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_temps')).hide();
    box_horlogeCode();
  });
}
function box_horlogeCode() {
  function afficherHorloge(id, diameter) {
    const radius = diameter / 2;
    const svgNS = "http://www.w3.org/2000/svg";
    const container = document.getElementById(id);
    container.innerHTML = ""; // Vide le conteneur

    const svg = document.createElementNS(svgNS, "svg");
    svg.setAttribute("width", diameter);
    svg.setAttribute("height", diameter);
    svg.setAttribute("viewBox", `0 0 ${diameter} ${diameter}`);

    const defs = document.createElementNS(svgNS, "defs");
    const filter = document.createElementNS(svgNS, "filter");
    filter.setAttribute("id", "ombre");
    filter.setAttribute("x", "-50%");
    filter.setAttribute("y", "-50%");
    filter.setAttribute("width", "200%");
    filter.setAttribute("height", "200%");

    const feDropShadow = document.createElementNS(svgNS, "feDropShadow");
    feDropShadow.setAttribute("dx", "1.5");
    feDropShadow.setAttribute("dy", "1.5");
    feDropShadow.setAttribute("stdDeviation", "1.5");
    feDropShadow.setAttribute("flood-color", "#000");
    feDropShadow.setAttribute("flood-opacity", "0.5");

    filter.appendChild(feDropShadow);
    defs.appendChild(filter);
    svg.appendChild(defs);

    // Cercle extérieur
    const circle = document.createElementNS(svgNS, "circle");
    circle.setAttribute("cx", radius);
    circle.setAttribute("cy", radius);
    circle.setAttribute("r", radius - 2);
    circle.setAttribute("fill", "#fff");
    circle.setAttribute("stroke", "#000");
    circle.setAttribute("filter", "url(#ombre)");
    svg.appendChild(circle);

    // Marquages : traits pour chaque minute
    for (let i = 0; i < 60; i++) {
      const angle = (i * 6) * Math.PI / 180;
      const inner = i % 5 === 0 ? radius - 10 : radius - 5;
      const outer = radius - 1;

      const x1 = radius + inner * Math.sin(angle);
      const y1 = radius - inner * Math.cos(angle);
      const x2 = radius + outer * Math.sin(angle);
      const y2 = radius - outer * Math.cos(angle);

      const line = document.createElementNS(svgNS, "line");
      line.setAttribute("x1", x1);
      line.setAttribute("y1", y1);
      line.setAttribute("x2", x2);
      line.setAttribute("y2", y2);
      line.setAttribute("stroke", "#000");
      line.setAttribute("stroke-width", i % 5 === 0 ? "2" : "1");
      svg.appendChild(line);
    }

    // Nombres toutes les 5 minutes
    for (let i = 1; i <= 12; i++) {
      const angle = (i * 30) * Math.PI / 180;
      const x = radius + (radius - 25) * Math.sin(angle);
      const y = radius - (radius - 25) * Math.cos(angle);

      const text = document.createElementNS(svgNS, "text");
      text.setAttribute("x", x);
      text.setAttribute("y", y + 4); // ajustement vertical
      text.setAttribute("text-anchor", "middle");
      text.setAttribute("font-size", "16");
      text.setAttribute("font-weight", "bold");
      //text.textContent = i * 5;
      text.textContent = i;
      svg.appendChild(text);
    }

    // Création des aiguilles
    function createHand(id, length, width, color) {
      const group = document.createElementNS(svgNS, "g");
      group.setAttribute("id", id);

      const line = document.createElementNS(svgNS, "line");
      line.setAttribute("x1", 0);
      line.setAttribute("y1", 0);
      line.setAttribute("x2", 0);
      line.setAttribute("y2", -length);
      line.setAttribute("stroke", color);
      line.setAttribute("stroke-width", width);
      line.setAttribute("stroke-linecap", "round");

      group.appendChild(line);
      group.setAttribute("transform", `translate(${radius}, ${radius})`);
      svg.appendChild(group);
    }

    createHand("heure", radius * 0.5, 4, "black");
    createHand("minute", radius * 0.7, 3, "black");
    createHand("seconde", radius * 0.85, 1.5, "red");

    container.appendChild(svg);

    // Mise à jour des aiguilles
    function updateClock() {
      const now = new Date();
      const seconds = now.getSeconds();
      const minutes = now.getMinutes();
      const hours = now.getHours();

      const heureAngle = ((hours % 12) + minutes / 60) * 30;
      const minuteAngle = (minutes + seconds / 60) * 6;
      const secondeAngle = seconds * 6;

      svg.getElementById("heure").setAttribute("transform", `translate(${radius}, ${radius}) rotate(${heureAngle})`);
      svg.getElementById("minute").setAttribute("transform", `translate(${radius}, ${radius}) rotate(${minuteAngle})`);
      svg.getElementById("seconde").setAttribute("transform", `translate(${radius}, ${radius}) rotate(${secondeAngle})`);
    }

    updateClock();
    timerHorloge = setInterval(updateClock, 1000);
  }

  // Appel de la fonction
  afficherHorloge("horloge-container", 160);

}

const timers = {}; // Ajout constante pour stopper toute minuterie lors le la fermeture des box
function modNinuterie() {
  let c = `<div class="timer-wrapper">`;
  c+= `<div class="timer-param">`;
  c+= `<div class="time-inputs">`;
  c+= `<input class="minutes" type="number" min="0" max="59" value="0" title="Nombre de minutes">`;
  c+= `<input class="seconds" type="number" min="0" max="59" value="30" title="Nombre de secondes">`;
  c+= `</div>`;
  c+= `<div class="form-check form-switch form-check-inline">`;
  c+= `<label class="form-check-label"><input class="form-check-input timer_bt_sonnerie" checked type="checkbox"> Sonnerie</label>`;
  c+= `</div>`;
  c+= `<div class="form-check form-switch form-check-inline">`;
  c+= `<label class="form-check-label"><input class="form-check-input timer_bt_boucle" type="checkbox"> En boucle</label>`;
  c+= `</div>`;
  c+= `<div class="input-group input-group-sm mb-3 timer_nb_equipes">`;
  c+= `<input type="number" min="1" max="6" value="1" class="form-control timer_saisie_nb_equipes">`;
  c+= `<span class="input-group-text">équipe(s)</span>`;
  c+= `</div>`;
  c+= `<div class="text-center"><button class="btn btn-success timer_bt_valider_param p-x1 py-0" type="button"><i class="bi bi-check-lg" style="font-size:1.3em"></i> Valider</button></div>`;
  c+= `</div>`;
  c+= `<div class="timer-compteur">`;
  c+= `<div class="time-display">00:30</div>`;
  c+= `<div class="timer-progress progress" style="height: 10px;">`;
  c+= `<div class="progress-bar bg-success" role="progressbar" style="width: 100%;"></div>`;
  c+= `</div>`;
  c+= `<div class="timer-buttons">`;
  c+= `<button class="btn btn-outline-success startPauseBtn px-2 py-0" title="Démarrer la minuterie"><i class="bi bi-play-fill" style="font-size:1.5em;"></i></button>`;
  c+= `<button class="btn btn-outline-warning resetBtn px-2 py-0" title="Initialiser"><i class="bi bi-arrow-clockwise" style="font-size:1.5em;"></i></button>`;
  c+= `<button class="btn btn-outline-secondary timer_retour_param px-2 py-0" title="Modifier les paramètres"><i class="bi bi-escape" style="font-size:1.5em;""></i></button>`;
  c+= `</div>`;
  c+= `</div>`;

  /* Ouvrir la box Minuterie */
  $('#box_bt_minuterie').on('click', function () {
    //creerBox("box_minuterie", 220, 230, ["box-move", "box-resize", "timer"], "Minuterie", 10, 10, html=c, null, true,);
    creerBox("box_minuterie", 220, 230, ["box-move", "box-resize", "timer"], "Minuterie", 10, 10, html=c, null, true, $('#box-container'),
      function (boxId) {
        //console.log('Box fermée :', boxId);
        if (timers[boxId]) {
          clearInterval(timers[boxId]);
          timers[boxId] = null;
          //console.log(`Minuterie de ${boxId} arrêtée.`);
        }
      }
    );
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_temps')).hide();
    box_minuterieCode();
  });
}

function box_minuterieCode() {// attention, version adaptée avec la constante timers
  document.querySelectorAll('.timer').forEach(container => {
    let remainingTime = 0;
    let totalTime = 0;
    let timerInterval = null;
    let hasStarted = false;
    let couleurEC = 0;
    let nbEquipes = 1;
    const couleursEquipes = ['#007bff', '#28a745', '#ffc107', '#dc3545', '#6f42c1' , 'black'];

    const minutesInput = container.querySelector('.minutes');
    const secondsInput = container.querySelector('.seconds');
    const timeDisplay = container.querySelector('.time-display');
    const progressBar = container.querySelector('.progress-bar');
    const startPauseBtn = container.querySelector('.startPauseBtn');
    const resetBtn = container.querySelector('.resetBtn');
    const boxContent = container.querySelector('.box-content');
    const inputSonnerie = container.querySelector('.timer_bt_sonnerie');
    const inputBoucle = container.querySelector('.timer_bt_boucle');
    const selectTimerParam = container.querySelector('.timer-param');
    const selectTimerCompteur = container.querySelector('.timer-compteur');
    const selectNbEquipe = container.querySelector('.timer_nb_equipes');
    const selectSaisieNbEquipe = container.querySelector('.timer_saisie_nb_equipes');

    // Fonction utilitaire : récupère l'ID de la box parente
    function getBoxId() {
      const boxEl = container.closest('.box-widget');
      return boxEl ? boxEl.id : null;
    }

    $(selectTimerCompteur).hide();
    $(selectNbEquipe).hide();
    $(inputBoucle).prop('checked', false);
    
    function updateDisplay(time) {
      const mins = Math.floor(time / 60);
      const secs = time % 60;
      timeDisplay.textContent =
        String(mins).padStart(2, '0') + ':' +
        String(secs).padStart(2, '0');

      const percent = totalTime > 0 ? (time / totalTime) * 100 : 0;
      progressBar.style.width = percent + '%';
      adjustFontSize();
    }

    function adjustFontSize() {
      const targetWidth = boxContent.clientWidth - 35;
      const targetHeight = boxContent.clientHeight * 0.5;
      const canvas = document.createElement('canvas');
      const context = canvas.getContext('2d');

      let fontSize = 10;
      const text = timeDisplay.textContent;

      while (fontSize < 200) {
        context.font = `${fontSize}px sans-serif`;
        const textWidth = context.measureText(text).width;
        const textHeight = fontSize;
        if (textWidth > targetWidth || textHeight > targetHeight) break;
        fontSize += 1;
      }

      timeDisplay.style.fontSize = `${fontSize - 1}px`;
    }

    const resizeObserver = new ResizeObserver(adjustFontSize);
    resizeObserver.observe(boxContent);

    function startTimer() {
      const boxId = getBoxId();

      if (!hasStarted) {
        const m = parseInt(minutesInput.value, 10) || 0;
        const s = parseInt(secondsInput.value, 10) || 0;
        remainingTime = m * 60 + s;
        totalTime = remainingTime;
        hasStarted = true;
      }

      updateDisplay(remainingTime);

      if (timerInterval) clearInterval(timerInterval);

      timerInterval = setInterval(() => {
        if (remainingTime > 0) {
          remainingTime--;
          updateDisplay(remainingTime);
        } else {
          clearInterval(timerInterval);
          timerInterval = null;
          if (boxId) timers[boxId] = null;
          startPauseBtn.innerHTML = '<i class="bi bi-play-fill" style="font-size:1.5em;"></i>';
          hasStarted = false;

          if ($(inputSonnerie).is(":checked")) {
            const sonNew = new Audio("medias/sons/sonnette.mp3");
            sonNew.play();
          }

          if ($(inputBoucle).is(":checked")) {
            hasStarted = false;
            couleurEC++;
            const nouvelleCouleur = couleursEquipes[couleurEC % nbEquipes];
            container.querySelector('.box-header').style.backgroundColor = nouvelleCouleur;
            startTimer();
          }
        }
      }, 1000);

      if (boxId) timers[boxId] = timerInterval;
      startPauseBtn.innerHTML = '<i class="bi bi-pause-fill" style="font-size:1.5em;"></i>';
    }

    startPauseBtn.addEventListener('click', () => {
      const boxId = getBoxId();

      if (!timerInterval) {
        startTimer();
      } else {
        clearInterval(timerInterval);
        timerInterval = null;
        if (boxId) timers[boxId] = null;
        startPauseBtn.innerHTML = '<i class="bi bi-play-fill" style="font-size:1.5em;"></i>';
      }
    });

    resetBtn.addEventListener('click', () => {
      const boxId = getBoxId();

      clearInterval(timerInterval);
      timerInterval = null;
      if (boxId) timers[boxId] = null;
      hasStarted = false;
      const m = parseInt(minutesInput.value) || 0;
      const s = parseInt(secondsInput.value) || 0;
      remainingTime = m * 60 + s;
      totalTime = m * 60 + s;
      updateDisplay(remainingTime);
      startPauseBtn.innerHTML = '<i class="bi bi-play-fill" style="font-size:1.5em;"></i>';
    });

    remainingTime = (parseInt(minutesInput.value) || 0) * 60 + (parseInt(secondsInput.value) || 0);
    updateDisplay(remainingTime);

    $('.timer_bt_boucle').on('change', function () {
      if ($(this).is(":checked")) $(this).closest(".timer-param").find(".timer_nb_equipes").show();
      else  $(this).closest(".timer-param").find(".timer_nb_equipes").hide();
    });

    $('.timer_bt_valider_param').on('click', function () {
      const m = parseInt(minutesInput.value);
      const s = parseInt(secondsInput.value);
      if (m >= 0 && s > 0) {
        $(this).closest(".timer-param").hide();
        $(this).closest(".timer-wrapper").find(".timer-compteur").show();
        nbEquipes = parseInt($(selectSaisieNbEquipe).val());
        if ($(inputBoucle).is(":checked")) container.querySelector('.box-header').style.backgroundColor = couleursEquipes[0];
        timeDisplay.textContent = (m<10 ? "0"+m : m)+":"+(s<10 ? "0"+s : s);
      } else alert("Oups ! La durée sélectionnée ne permet pas de lancer la minuterie...")
    });

    $('.timer_retour_param').on('click', function () {
      $(this).closest(".timer-compteur").hide();
      $(this).closest(".timer-wrapper").find(".timer-param").show();
    });
  });
}

function modChronoRedim() {
  let c = `<div class="chrono-wrapper">`;
  c+= `<div class="chrono">00:00:00</div>`;
  c+= `<div class="chrono-buttons">`;
  c+= `<button class="btn btn-outline-success startPauseBtn px-2 py-0" style="font-size:1.5em;"><i class="bi bi-play-fill"></i></button>`;
  c+= `<button class="btn btn-outline-warning resetBtn px-2 py-0" style="font-size:1.5em;"><i class="bi bi-arrow-clockwise"></i></button>`;
 
  /* Ouvrir la box Chronomètre redimensionnable */
  $('#box_bt_chrono_redim').on('click', function () {
    creerBox('box_chrono_redim', 190, 160, ["box-move", "box-resize", "chronometer"], "Chronomètre", 10, 10, html=c, null, true, $('#box-container'),
      function (boxId) {
        //console.log('Box fermée :', boxId);
        clearInterval(chronoRedimTimer); // stoppe réellement le chrono
        chronoRedimTimer = null; // remet la variable à zéro
      }
    );
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_temps')).hide();
    box_chrono_redimCode();
  });
}

let chronoRedimTimer = null; // on le déclare globalement
function box_chrono_redimCode() {
  document.querySelectorAll('.chronometer').forEach(container => {
    let startTime = 0;
    let elapsedTime = 0;
    let timerInterval = null;

    const chronoText = container.querySelector('.chrono');
    const boxContent = container.querySelector('.box-content');
    const startPauseBtn = container.querySelector('.startPauseBtn');
    const resetBtn = container.querySelector('.resetBtn');

    function adjustFontSizeToWidth() {
      const targetWidth = boxContent.clientWidth - 35;
      const canvas = document.createElement('canvas');
      const context = canvas.getContext('2d');

      let fontSize = 10;
      const text = chronoText.textContent;

      while (fontSize < 300) {
        context.font = `${fontSize}px sans-serif`;
        const textWidth = context.measureText(text).width;
        if (textWidth > targetWidth) break;
        fontSize += 1;
      }

      chronoText.style.fontSize = `${fontSize - 1}px`;
    }

    const resizeObserver = new ResizeObserver(adjustFontSizeToWidth);
    resizeObserver.observe(boxContent);

    function updateChronoDisplay(hours, minutes, seconds) {
      chronoText.textContent =
        `${String(hours).padStart(2, '0')}:` +
        `${String(minutes).padStart(2, '0')}:` +
        `${String(seconds).padStart(2, '0')}`;
      adjustFontSizeToWidth();
    }

    function updateChrono() {
      const time = elapsedTime + (Date.now() - startTime);
      const seconds = Math.floor(time / 1000) % 60;
      const minutes = Math.floor(time / 60000) % 60;
      const hours = Math.floor(time / 3600000);
      updateChronoDisplay(hours, minutes, seconds);
    }

    startPauseBtn.addEventListener('click', () => {
      if (!chronoRedimTimer) {
        // Start
        startTime = Date.now();
        chronoRedimTimer = setInterval(updateChrono, 1000);
        startPauseBtn.innerHTML =  '<i class="bi bi-pause-fill"></i>';
      } else {
        // Pause
        clearInterval(chronoRedimTimer);
        elapsedTime += Date.now() - startTime;
        chronoRedimTimer = null;
        startPauseBtn.innerHTML = '<i class="bi bi-play-fill"></i>';
      }
    });

    resetBtn.addEventListener('click', () => {
      clearInterval(chronoRedimTimer);
      startTime = 0;
      elapsedTime = 0;
      chronoRedimTimer = null;
      updateChronoDisplay(0, 0, 0);
      startPauseBtn.innerHTML = '<i class="bi bi-play-fill"></i>';
    });

    // Initial
    updateChronoDisplay(0, 0, 0);
  });

}

function modChronoMulti() {
  let c = `<div id="chrono_multi">`;
  c+= `<div id="chp_header" class="p-1">`;
  c+= `<div id="chp_temps"><span id="chp_heure">00</span>:<span id="chp_min">00</span>:<span id="chp_sec">00</span>&nbsp;<span id="chp_ms">000</span></div>`;
  c+= `<div class="d-flex justify-content-between">`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<button id="chp_bt_play_pause" class="btn btn-success btn-sm py-0 me-1"><i class="bi bi-play-fill" style="font-size:1.5em;"></i></button>`;
  c+= `<button id="chp_bt_init" class="btn btn-warning btn-sm py-0" title="Réinitialiser le compteur"><i class="bi bi-arrow-repeat" style="font-size:1.5em;"></i></button>`;
  c+= `</div>`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<button id="chp_bt_inter" class="btn btn-danger btn-sm py-0 me-2" title="Ajouter un temps intermédiaire"><i class="bi bi-stopwatch" style="font-size:1.5em;"></i></button>`;
  c+= `<input id="chp_input_step" type="number" min="0" max="900" style="font-size: 1.1em;" title="Intervalle entre 2 alertes">`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div class="d-flex justify-content-between mt-1">`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<div class="form-check form-switch" title="Envoyer ou non un flash toutes les X secondes">`;
  c+= `<input class="form-check-input" type="checkbox" role="switch" id="chp_flash">`;
  c+= `<label class="form-check-label" for="chp_flash">Flash</label>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<div class="form-check form-switch" title="Écouter ou non une sonnnerie toutes les X secondes">`;
  c+= `<input class="form-check-input" type="checkbox" role="switch" id="chp_son">`;
  c+= `<label class="form-check-label" for="chp_son">Son</label>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div id="chp_ctn_inter">`;
  c+= `<table id="chp_inter" class="table table-sm table-bordered table-striped mb-0">`;
  c+= `<tbody></tbody>`;
  c+= `</table>`;
  c+= `</div>`;
  c+= `</div>`;

  /* Ouvrir la box Chronomètre multifonctions */
  $('#box_bt_chrono_multi').on('click', function () {
    creerBox('box_chrono_multi', 230, 315, ["box-move"], "Chronomètre MF", 10, 10, html=c, null, true, $('#box-container'),
      function (boxId) {
        //console.log('Box fermée :', boxId);
        clearInterval(ChpTimerInterval); // stoppe réellement le chrono
        ChpTimerInterval = null; // remet la variable à zéro
      }
    );
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_temps')).hide();
    box_chrono_multiCode();
  });
}

let ChpTimerInterval;
function box_chrono_multiCode() {
  let ChpSstartTime = 0;
  let ChpElapsedTime = 0;
  let ChpIsRunning = false;
  let ChpTourCount = 0;
  let ChpStepCheckInterval = 100;
  let ChpLastStepCheck = 0;

  function formatTime(ms) {
    const msPart = ms % 1000;
    const totalSec = Math.floor(ms / 1000);
    const sec = totalSec % 60;
    const min = Math.floor(totalSec / 60) % 60;
    const hr = Math.floor(totalSec / 3600);
    return {
      hr: String(hr).padStart(2, '0'),
      min: String(min).padStart(2, '0'),
      sec: String(sec).padStart(2, '0'),
      ms: String(msPart).padStart(3, '0')
    };
  }

  function updateDisplay() {
    const time = formatTime(ChpElapsedTime);
    $('#chp_heure').text(time.hr);
    $('#chp_min').text(time.min);
    $('#chp_sec').text(time.sec);
    $('#chp_ms').text(time.ms);
  }

  function startChrono() {
    ChpSstartTime = Date.now() - ChpElapsedTime;
    ChpTimerInterval = setInterval(() => {
      ChpElapsedTime = Date.now() - ChpSstartTime;
      updateDisplay();

      const step = parseInt($('#chp_input_step').val(), 10);
      if (!isNaN(step) && step > 0) {
        if (Math.floor(ChpElapsedTime / 1000) !== ChpLastStepCheck &&
            ChpElapsedTime >= step * 1000 &&
            Math.floor(ChpElapsedTime / 1000) % step === 0) {
          ChpLastStepCheck = Math.floor(ChpElapsedTime / 1000);

          if ($('#chp_flash').is(':checked')) {
            $('#chp_header').addClass('flash-anim');
            setTimeout(() => $('#chp_header').removeClass('flash-anim'), 1000);
          }

          if ($('#chp_son').is(':checked')) {
            let sonNew = new Audio();
            sonNew.src = "medias/sons/sonnette.mp3";
            sonNew.play();
          }

        }
      }
    }, ChpStepCheckInterval);
    ChpIsRunning = true;
    $('#chp_bt_play_pause i').removeClass('bi-play-fill').addClass('bi-pause-fill');
  }

  function stopChrono() {
    clearInterval(ChpTimerInterval);
    ChpIsRunning = false;
    $('#chp_bt_play_pause i').removeClass('bi-pause-fill').addClass('bi-play-fill');
  }

  function resetChrono() {
    stopChrono();
    ChpElapsedTime = 0;
    updateDisplay();
    ChpTourCount = 0;
    $('#chp_inter tbody').empty();
    ChpLastStepCheck = 0;
  }

  function addInterTime() {
    const time = formatTime(ChpElapsedTime);
    ChpTourCount++;
    const row = `
      <tr>
        <th class="chp_tour">${ChpTourCount}</th>
        <td><span class="chp_inter_h">${time.hr}</span>:<span class="chp_inter_m">${time.min}</span>:<span class="chp_inter_s">${time.sec}</span>&nbsp;<span class="chp_inter_ms">${time.ms}</span></td>
      </tr>
    `;
    $('#chp_inter tbody').prepend(row);
  }

  $('#chp_bt_play_pause').on('click', () => {
    if (ChpIsRunning) {
      stopChrono();
    } else {
      startChrono();
    }
  });

  $('#chp_bt_init').on('click', resetChrono);
  $('#chp_bt_inter').on('click', addInterTime);

}

function modMetronome() {
  let c = ``;
  c+= `<div id="metronome" class="container-fluid">`;
  c+= `<div id="metro_temps" class="row gx-1">`;
  c+= `<input type="hidden" id="metro_input_temps_fort">`;
  c+= `<input type="hidden" id="metro_input_temps_faible">`;
  c+= `<div class="col-5">Temps fort<select id="metro_temps_fort" class="form-select metro_select_sons"></select></div>`;
  c+= `<div class="col-2">Temps<input type="number" id="metro_nb_temps" min="1" max="4" class="form-control px-1" value="1"></div>`;
  c+= `<div class="col-5">Temps faible<select id="metro_temps_faible" class="form-select metro_select_sons"></select></div>`;
  c+= `</div>`;
  c+= `<div class="row mt-3">`;
  c+= `<div class="col"><button id="metro_play_pause" class="btn btn-success btn-lg px-2 py-0"><i class="bi bi-play-fill" style="font-size: 1.5em;"></i></button></div>`;
  c+= `<div class="col"><input type="number" id="metro_tempo" min="1" class="form-control form-control-lg" value="60"></div>`;
  c+= `<div class="col">`;
  c+= `<div class="form-check form-switch">`;
  c+= `<input class="form-check-input" type="checkbox" id="metro_son" checked>`;
  c+= `<label class="form-check-label" for="metro_son">Son</label>`;
  c+= `</div>`;
  c+= `<div class="form-check form-switch">`;
  c+= `<input class="form-check-input" type="checkbox" id="metro_flash" checked>`;
  c+= `<label class="form-check-label" for="metro_flash">Flash</label>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div class="row g-0 mt-3">`;
  c+= `<div class="col"><div id="metro_flash_temps_fort" class="metro_flash"></div></div>`;
  c+= `<div class="col"><div id="metro_flash_temps_faible_1" class="metro_flash"></div></div>`;
  c+= `<div class="col"><div id="metro_flash_temps_faible_2" class="metro_flash"></div></div>`;
  c+= `<div class="col"><div id="metro_flash_temps_faible_3" class="metro_flash"></div></div>`;
  c+= `</div>`;
  c+= `</div>`;
  
  /* Ouvrir la box Métronome */
  $('#box_bt_metronome').on('click', function () {
    creerBox('box_metronome', 360, 260, ["box-move"], "Métronome", 10, 10, html=c, null, true, $('#box-container'),
      function (boxId) {
        //console.log('Box fermée :', boxId);
        clearInterval(schedulerTimerID); // stoppe réellement le chrono
        schedulerTimerID = null; // remet la variable à zéro
      }
    );
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_temps')).hide();
    box_metronomeCode();
  });
}

let schedulerTimerID;
function box_metronomeCode() {
  const metroSons = [
    ["Baguette","baguette.mp3"],
    ["Bip 1","bip_1.mp3"],
    ["Bip 2","bip_2.mp3"],
    ["Bip 3","bip_3.mp3"],
    ["Bip 4","bip_4.mp3"],
    ["Bip 5","bip_5.mp3"],
    ["Bip 6","bip_6.mp3"],
    ["C. claire 1","caisse_claire_1.mp3"],
    ["C. claire 2","caisse_claire_2.mp3"],
    ["C. claire 3","caisse_claire_3.mp3"],
    ["C. claire 4","caisse_claire_4.mp3"],
    ["Charlest. 1","charleston_1.mp3"],
    ["Charlest. 2","charleston_2.mp3"],
    ["G. caisse 1","grosse_caisse_1.mp3"],
    ["G. caisse 2","grosse_caisse_2.mp3"]
  ];

  // Remplir les listes déroulantes
  let metroListeSon = "";
  for (let i=0 ; i < metroSons.length ; i++) {
    metroListeSon += `<option value="${metroSons[i][1]}">${metroSons[i][0]}</option>`;
  }
  document.querySelectorAll(".metro_select_sons").forEach(sel => sel.innerHTML = metroListeSon);
  document.getElementById('metro_temps_fort').value = "grosse_caisse_1.mp3";
  document.getElementById('metro_temps_faible').value = "caisse_claire_1.mp3";

  // Variables Audio
  let audioCtx;
  let isPlaying = false;
  let currentNote = 0;
  let nextNoteTime = 0.0;
  //let schedulerTimerID;
  let buffers = {};

  const lookahead = 25.0; // ms
  const scheduleAheadTime = 0.1; // s
  const metroDureeFlash = 200;

  function getParams() {
    return {
      nbTemps: Math.min(Math.max(parseInt(document.getElementById('metro_nb_temps').value) || 1, 1), 4),
      tempo: Math.max(parseInt(document.getElementById('metro_tempo').value) || 60, 1),
      tempsFortSon: document.getElementById('metro_temps_fort').value,
      tempsFaibleSon: document.getElementById('metro_temps_faible').value,
      jouerSonActive: document.getElementById('metro_son').checked,
      flashActive: document.getElementById('metro_flash').checked,
    };
  }

  async function chargerSon(nomFichier) {
    if (buffers[nomFichier]) return buffers[nomFichier];
    if (!metroSonsBase64[nomFichier]) {
      console.error(`Son manquant : ${nomFichier}`);
      return null;
    }
    const res = await fetch(metroSonsBase64[nomFichier]);
    const arrayBuffer = await res.arrayBuffer();
    const audioBuffer = await audioCtx.decodeAudioData(arrayBuffer);
    buffers[nomFichier] = audioBuffer;
    return audioBuffer;
  }

  async function planifierNote(temps, noteIndex) {
    const params = getParams();
    const isTempsFort = noteIndex === 0;
    const flashId = isTempsFort ? 'metro_flash_temps_fort' : `metro_flash_temps_faible_${noteIndex}`;
    const fichier = isTempsFort ? params.tempsFortSon : params.tempsFaibleSon;

    if (params.jouerSonActive) {
      const buffer = await chargerSon(fichier);
      if (buffer) {
        const source = audioCtx.createBufferSource();
        source.buffer = buffer;
        source.connect(audioCtx.destination);
        source.start(temps);
      }
    }
    if (params.flashActive) {
      setTimeout(() => {
        const el = document.getElementById(flashId);
        el.style.backgroundColor = 'red';
        setTimeout(() => { el.style.backgroundColor = '#FFF'; }, metroDureeFlash);
      }, (temps - audioCtx.currentTime) * 1000);
    }
  }

  function nextNote() {
    const { tempo, nbTemps } = getParams();
    const secondsPerBeat = 60.0 / tempo;
    nextNoteTime += secondsPerBeat;
    currentNote = (currentNote + 1) % nbTemps;
  }

  function scheduler() {
    while (nextNoteTime < audioCtx.currentTime + scheduleAheadTime) {
      planifierNote(nextNoteTime, currentNote);
      nextNote();
    }
    schedulerTimerID = setTimeout(scheduler, lookahead);
  }

  async function startMetronome() {
    if (!audioCtx) {
      audioCtx = new (window.AudioContext || window.webkitAudioContext)();
    }
    isPlaying = true;
    currentNote = 0;
    nextNoteTime = audioCtx.currentTime + 0.05;
    scheduler();
  }

  function stopMetronome() {
    isPlaying = false;
    clearTimeout(schedulerTimerID);
  }

  document.getElementById('metro_play_pause').addEventListener('click', async () => {
    const icon = document.querySelector('#metro_play_pause i');
    if (!isPlaying) {
      await startMetronome();
      icon.classList.replace('bi-play-fill', 'bi-pause-fill');
    } else {
      stopMetronome();
      icon.classList.replace('bi-pause-fill', 'bi-play-fill');
    }
  });

  // astuce pour renseigner les select lors de l'importation
  $('#metro_temps_fort').on('change', function () {
    $("#metro_input_temps_fort").val($('#metro_temps_fort').val());
  });
  $('#metro_temps_faible').on('change', function () {
    $("#metro_input_temps_faible").val($('#metro_temps_faible').val());
  });

}

function modAgenda() {
  let c = `<div id="calendar-container" style="width: 100%; max-width: 600px;"></div>`;

  /* Ouvrir la box Mini-agenda */
  $('#box_bt_agenda').on('click', function () {
    creerBox('box_agenda', 450, 350, ["box-move"], "Mini-agenda", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_temps')).hide();
    box_agendaCode();
  });
}
function box_agendaCode() {
  function GenererCalendrier(id) {
    const container = document.getElementById(id);
    const mois = ["Janvier", "Février", "Mars", "Avril", "Mai", "Juin", "Juillet", "Août", "Septembre", "Octobre", "Novembre", "Décembre"];
    let dateActuelle = new Date();
    let notes = JSON.parse(localStorage.getItem("notesCalendrier") || '{}');

    function afficherCalendrier(date) {
      container.innerHTML = '';
      const annee = date.getFullYear();
      const moisIndex = date.getMonth();
      const premierJour = (new Date(annee, moisIndex, 1).getDay() + 6) % 7;
      const dernierJour = new Date(annee, moisIndex + 1, 0).getDate();

      const header = document.createElement('div');
      header.className = "d-flex justify-content-between align-items-center mb-2";
      header.innerHTML = `
        <button class="btn btn-sm btn-outline-secondary px-2 py-0" id="prev"><i class="bi bi-caret-left-fill" style="font-size:1.5em"></i></button>
        <h5 class="mb-0">${mois[moisIndex]} ${annee}</h5>
        <button class="btn btn-sm btn-outline-secondary px-2 py-0" id="next"><i class="bi bi-caret-right-fill" style="font-size:1.5em"></i></button>
      `;
      container.appendChild(header);

      const table = document.createElement('table');
      table.className = 'table table-bordered text-center table-sm';
      const thead = document.createElement('thead');
      thead.innerHTML = '<tr>' + ["Lun", "Mar", "Mer", "Jeu", "Ven", "Sam", "Dim"].map(j => `<th>${j}</th>`).join('') + '</tr>';
      table.appendChild(thead);

      const tbody = document.createElement('tbody');
      let jour = 1;
      for (let i = 0; i < 6; i++) {
        const row = document.createElement('tr');
        for (let j = 0; j < 7; j++) {
          const cell = document.createElement('td');
          if ((i === 0 && j < premierJour) || jour > dernierJour) {
            cell.innerHTML = '';
          } else {
            const currentDay = jour;
            const dateKey = `${annee}-${moisIndex + 1}-${currentDay}`;
            cell.innerHTML = `<div class="day-cell ${isToday(annee, moisIndex, currentDay) ? 'bg-primary text-white' : ''} ${notes[dateKey] ? 'bg-warning' : ''}" style="cursor:pointer;">${currentDay}</div>`;
            cell.onclick = () => afficherNote(dateKey, currentDay, mois[moisIndex], annee);
            jour++;
          }
          row.appendChild(cell);
        }
        tbody.appendChild(row);
      }
      table.appendChild(tbody);
      container.appendChild(table);

      document.getElementById('prev').onclick = () => {
        dateActuelle.setMonth(dateActuelle.getMonth() - 1);
        afficherCalendrier(dateActuelle);
      };
      document.getElementById('next').onclick = () => {
        dateActuelle.setMonth(dateActuelle.getMonth() + 1);
        afficherCalendrier(dateActuelle);
      };
    }

    function isToday(y, m, d) {
      const now = new Date();
      return now.getFullYear() === y && now.getMonth() === m && now.getDate() === d;
    }

  function afficherNote(dateKey, jour, moisNom, annee) {
    container.innerHTML = '';

    const header = document.createElement('div');
    header.className = 'mb-2';
    const dateComplete = new Date(annee, mois.indexOf(moisNom), jour).toLocaleDateString('fr-FR', {
      weekday: 'long',
      year: 'numeric',
      month: 'long',
      day: 'numeric'
    });
    header.innerHTML = `<h5 class="text-capitalize">${dateComplete}</h5>`;

    container.appendChild(header);

    const content = document.createElement('div');
    content.innerHTML = '<div id="editor"></div>';
    container.appendChild(content);

    const quill = new Quill('#editor', {
      theme: 'snow',
      modules: {
        toolbar: [
          ['bold', 'strike'],
          [{ 'list': 'ordered'}, { 'list': 'bullet' }],
          [{ 'align': [] }],
          [{ 'size': ['small', false, 'large', 'huge'] }],
          [{ 'color': [] }, { 'background': [] }],
          ['link'],
        ]
      }
    });

    if (notes[dateKey]) {
      quill.root.innerHTML = notes[dateKey];
    }

    setTimeout(() => {
      quill.focus();
    }, 100);

    const footer = document.createElement('div');
    footer.className = 'mt-4 d-flex justify-content-between flex-wrap gap-2 align-items-center';

    // Bloc gauche : Exporter, Importer, Vider
    const leftGroup = document.createElement('div');
    leftGroup.className = 'd-flex gap-2';

    const btnExport = document.createElement('button');
    btnExport.className = 'btn btn-outline-dark px-2 py-0';
    btnExport.innerHTML = '<i class="bi bi-upload" style="font-size:1.5em;" title="Exporter les notes au format JSON"></i>';

    const btnImport = document.createElement('button');
    btnImport.className = 'btn btn-outline-dark px-2 py-0';
    btnImport.innerHTML = '<i class="bi bi-download" style="font-size:1.5em;" title="Importer des notes"></i>';

    const inputImport = document.createElement('input');
    inputImport.type = 'file';
    inputImport.accept = 'application/json';
    inputImport.style.display = 'none';

    const btnClear = document.createElement('button');
    btnClear.className = 'btn btn-outline-warning px-2 py-0';
    btnClear.innerHTML = '<i class="bi bi-trash3-fill" style="font-size:1.5em;" title="Supprimer toutes les notes"></i>';

    leftGroup.appendChild(btnExport);
    leftGroup.appendChild(btnImport);
    leftGroup.appendChild(inputImport);
    leftGroup.appendChild(btnClear);

    // Bloc droit : Supprimer, Annuler, Enregistrer
    const rightGroup = document.createElement('div');
    rightGroup.className = 'd-flex gap-2';

    const btnDelete = document.createElement('button');
    btnDelete.className = 'btn btn-danger px-2 py-0';
    btnDelete.innerHTML = '<i class="bi bi-calendar-x-fill" style="font-size:1.5em;" title="Supprimer cette note"></i>';

    const btnCancel = document.createElement('button');
    btnCancel.className = 'btn btn-secondary px-2 py-0';
    btnCancel.innerHTML = '<i class="bi bi-escape" style="font-size:1.5em;" title="Quitter sans enregistrer"></i>';

    const btnSave = document.createElement('button');
    btnSave.className = 'btn btn-success px-2 py-0';
    btnSave.innerHTML = '<i class="bi bi-floppy-fill" style="font-size:1.5em;" title="Enregistrer cette note"></i>';

    rightGroup.appendChild(btnDelete);
    rightGroup.appendChild(btnCancel);
    rightGroup.appendChild(btnSave);

    footer.appendChild(leftGroup);
    footer.appendChild(rightGroup);
    container.appendChild(footer);

    // Boutons - actions
    btnSave.onclick = () => {
      notes[dateKey] = quill.root.innerHTML;
      localStorage.setItem("notesCalendrier", JSON.stringify(notes));
      afficherCalendrier(dateActuelle);
    };

    btnCancel.onclick = () => afficherCalendrier(dateActuelle);

    btnDelete.onclick = () => {
      delete notes[dateKey];
      localStorage.setItem("notesCalendrier", JSON.stringify(notes));
      afficherCalendrier(dateActuelle);
    };

    btnExport.onclick = () => {
      const blob = new Blob([JSON.stringify(notes, null, 2)], { type: 'application/json' });
      const url = URL.createObjectURL(blob);
      const a = document.createElement('a');
      a.href = url;
      //a.download = 'notes.json';
      a.download = "agenda-"+afficherDateEnr()+".json";
      a.click();
      URL.revokeObjectURL(url);
    };

    btnImport.onclick = () => {
      inputImport.click();
    };

    inputImport.onchange = (e) => {
      const file = e.target.files[0];
      if (!file) return;
      const reader = new FileReader();
      reader.onload = (evt) => {
        try {
          const imported = JSON.parse(evt.target.result);
          notes = { ...notes, ...imported };
          localStorage.setItem("notesCalendrier", JSON.stringify(notes));
          alert("Importation réussie !");
          afficherCalendrier(dateActuelle);
        } catch (err) {
          alert("Fichier JSON invalide");
        }
      };
      reader.readAsText(file);
    };

    btnClear.onclick = () => {
      if (confirm("Voulez-vous vraiment vider toutes les notes ?")) {
        localStorage.removeItem("notesCalendrier");
        notes = {};
        afficherCalendrier(dateActuelle);
      }
    };
  }

    afficherCalendrier(dateActuelle);

  }

  // Initialisation du calendrier
  GenererCalendrier("calendar-container");
}

function modJour() {
  let c = `<div id="dateContainer" style="font-size:1.5em;"></div>`;

  /* Ouvrir la box Jour multilangues*/
  $('#box_bt_jour').on('click', function () {
    creerBox('box_jour', 400, 80, ["box-move", "box-resize"], "Jour multilangues", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_temps')).hide();
    box_jourCode();
  });
}
function box_jourCode() {
  $("#dateContainer").html("");
  function afficherDate(id) {
      const langues = [
        { code: 'fr-FR', image: 'medias/drapeau/fr.png', title:'Français' },
        { code: 'en-GB', image: 'medias/drapeau/en-gb.png', title:'Anglais GB' },
        { code: 'en-US', image: 'medias/drapeau/en-us.png', title:'Anglais US' },
        { code: 'it-IT', image: 'medias/drapeau/it.png', title:'Italien' },
        { code: 'es-ES', image: 'medias/drapeau/es.png', title:'Espagnol' },
        { code: 'de-DE', image: 'medias/drapeau/de.png', title:'Allemand' },
        { code: 'pt-PT', image: 'medias/drapeau/pt.png', title:'Portugais' },
      ];

      let currentLangIndex = 0;

      const container = document.getElementById(id);
      if (!container) return;

      const flag = document.createElement('img');
      flag.style.cursor = 'pointer';
      flag.style.verticalAlign = 'middle';
      flag.style.marginRight = '0.5em';
      flag.width = 32;
      flag.height = 32;

      const dateText = document.createElement('span');

      function updateDisplay() {
          const { code, image, title } = langues[currentLangIndex];
          const date = new Date();
          const formattedDate = date.toLocaleDateString(code, {
              weekday: 'long',
              year: 'numeric',
              month: 'long',
              day: 'numeric'
          });

          flag.src = image;
          flag.alt = code;
          flag.title = title;
          dateText.textContent = formattedDate;
      }

      flag.addEventListener('click', () => {
          currentLangIndex = (currentLangIndex + 1) % langues.length;
          updateDisplay();
      });

      container.appendChild(flag);
      container.appendChild(dateText);

      updateDisplay();
  }

  // Appel de la fonction
  afficherDate('dateContainer');

}

