/*****************************************/
/* Fonctions de lecteur                  */
/*****************************************/

/* Générer et gérer la modale des lecteurs */
function genererModaleLecteur() {
  // Génération de la modale
  let c = "";
  c+= `<div class="modal fade premier_plan" id="outils_modal_act_lecteur" tabindex="-1" aria-hidden="true">`;
  c+= `<div class="modal-dialog modal-lg">`;
  c+= `<div class="modal-content bg-info-subtle">`;
  c+= `<div class="modal-header bg-info d-flex align-items-start justify-content-between py-2 px-2">`;
  c+= `<h1 class="modal-title fs-4">Lire des médias</h1>`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<button class="btn btn-warning ms-2" data-bs-dismiss="modal" title="Fermer"><i class="bi bi-x-lg"></i></button>`;
  c+= `</div>`;
  c+= `</div>`;// fin .modal-header
  c+= `<div class="modal-body">`;

  c+= `<ul class="nav nav-tabs" id="lecteur_tabs" role="tablist">`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link active" id="lecteur_image_tab" data-bs-toggle="tab" data-bs-target="#lecteur_image" type="button" role="tab" aria-controls="lecteur_image" aria-selected="true">Images</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="lecteur_texte_tab" data-bs-toggle="tab" data-bs-target="#lecteur_texte" type="button" role="tab" aria-controls="lecteur_texte" aria-selected="true">Textes</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="lecteur_pdf_tab" data-bs-toggle="tab" data-bs-target="#lecteur_pdf" type="button" role="tab" aria-controls="lecteur_pdf" aria-selected="true">PDF</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="lecteur_audio_tab" data-bs-toggle="tab" data-bs-target="#lecteur_audio" type="button" role="tab" aria-controls="lecteur_audio" aria-selected="true">Audio</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="lecteur_video_tab" data-bs-toggle="tab" data-bs-target="#lecteur_video" type="button" role="tab" aria-controls="lecteur_video" aria-selected="true">Vidéo</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="lecteur_integration_tab" data-bs-toggle="tab" data-bs-target="#lecteur_integration" type="button" role="tab" aria-controls="lecteur_integration" aria-selected="true">Intégration</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="lecteur_lien_tab" data-bs-toggle="tab" data-bs-target="#lecteur_lien" type="button" role="tab" aria-controls="lecteur_lien" aria-selected="true">Lien</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="lecteur_recherche_tab" data-bs-toggle="tab" data-bs-target="#lecteur_recherche" type="button" role="tab" aria-controls="lecteur_recherche" aria-selected="true">Recherche</button>`;
  c+= `</li>`;

  c+= `</ul>`;// fin #lecteur_tabs

  c+= `<div class="tab-content tab_content" id="lecteur_content">`;

  c+= `<div class="tab-pane active" id="lecteur_image" role="tabpanel" aria-labelledby="lecteur_image_tab">`;
  //c+= `contenu onglet Image`;
	c+= "<h4 class='premier'>Explorer une galerie d'images</h4>";

  c+= `<div class="zone-images" data-image-selector data-max-size="300">`;
  c+= `<h5>Déposer ou sélectionner des images</h5>`;
  c+= `<div class="inputs">`;
  c+= `<input type="file" multiple accept="image/*" class="input-fichiers">`;
  c+= `<input type="file" multiple accept="image/*" webkitdirectory class="input-dossier">`;
  c+= `</div>`;
  c+= `<button class="btn-fichiers btn btn-secondary btn-sm mx-1">Choisir des images</button>`;
  c+= `<button class="btn-dossier btn btn-secondary btn-sm mx-1">Choisir un dossier d'images</button>`;
  c+= `<button class="btn-supprimer-tout btn btn-secondary btn-sm mx-1" type="button">Tout supprimer</button>`;
  c+= `<div id="galerie_images_apercu" class="apercu"></div>`;
  c+= `<button id="box_bt_galerie_images" class="btn-test-img-apercu btn btn-sm btn-success disabled" type="button" disabled>Valider ces images</button>`;
  c+= `</div>`;

  c+= `</div>`;//fin #lecteur_image

  c+= `<div class="tab-pane fade" id="lecteur_texte" role="tabpanel" aria-labelledby="lecteur_texte_tab">`;
  //c+= `contenu onglet Texte`;
	c+= "<h4 class='premier'>Lire un texte en synthèse vocale <button id='box_bt_svocale' class='btn btn-primary btn-sm'>Afficher</button></h4><p>Le texte saisi est lu en synthèse vocale pendant que les mots lus sont surlignés.</p>";
	c+= "<h4 class='premier'>Lire un texte avec un prompteur <button id='box_bt_prompteur' class='btn btn-primary btn-sm'>Afficher</button></h4>";
  c+= `<p>Saisir un texte, définir les paramètres du défilement <em>(vitesse, taille de la police, largeur du texte, ...)</em> et démarrer la lecture tout en pouvant visualiser le compteur du temps écoulé.</p>`;
  c+= `</div>`;//fin #lecteur_texte

  c+= `<div class="tab-pane fade" id="lecteur_pdf" role="tabpanel" aria-labelledby="lecteur_pdf_tab">`;
  //c+= `contenu onglet PDF`;
	c+= "<h4 class='premier'>Lire un fichier PDF</h4>";
  c+= `<div>`;
  c+= `<label for="box_bt_pdf" class="form-label">Sélectionner un fichier PDF</label>`;
  c+= `<input class="form-control" type="file" id="box_bt_pdf" accept=".pdf">`;
  c+= `</div>`;
  c+= `</div>`;//fin #lecteur_pdf

  c+= `<div class="tab-pane fade" id="lecteur_audio" role="tabpanel" aria-labelledby="lecteur_audio_tab">`;
  //c+= `contenu onglet Audio`;
	c+= "<h4 class='premier'>Lire un fichier audio</h4>";
  c+= `<div>`;
  c+= `<label for="box_bt_audio" class="form-label">Sélectionner un fichier audio</label>`;
  c+= `<input class="form-control" type="file" id="box_bt_audio" accept="audio/*,.mp3">`;
  c+= `</div>`;
	c+= "<h4>Écouter des musiques relaxantes</h4>";
  c+= `<button data-son="cascade-et-meditation" class="btn btn-secondary btn-sm bt_musique m-1">Cascade et méditation</button>`;
  c+= `<button data-son="guitare-et-piano" class="btn btn-secondary btn-sm bt_musique m-1">Guitare et piano</button>`;
  c+= `<button data-son="nature-et-meditation" class="btn btn-secondary btn-sm bt_musique m-1">Nature et méditation</button>`;
  c+= `<button data-son="piano-calme" class="btn btn-secondary btn-sm bt_musique m-1">Piano calme</button>`;
  c+= `<button data-son="saxophone-romantique" class="btn btn-secondary btn-sm bt_musique m-1">Saxophone romantique</button>`;
  c+= `<h6 class="mt-2">Rechercher d'autres musiques relaxantes libres de droits sur <a target='_blank' href='https://pixabay.com/fr/music/search/respiration/'>Pixabay</a><h6>`;
  c+= `</div>`;//fin #lecteur_audio

  c+= `<div class="tab-pane fade" id="lecteur_video" role="tabpanel" aria-labelledby="lecteur_video_tab">`;
  //c+= `contenu onglet Vidéo`;
	c+= "<h4 class='premier'>Lire un fichier vidéo</h4>";
  c+= `<div>`;
  c+= `<label for="box_bt_video" class="form-label">Sélectionner un fichier vidéo</label>`;
  c+= `<input class="form-control" type="file" id="box_bt_video" accept="video/*,.mp4,.webm,.ogg">`;
  c+= `</div>`;
  c+= `</div>`;//fin #lecteur_vidéo

  c+= `<div class="tab-pane fade" id="lecteur_integration" role="tabpanel" aria-labelledby="lecteur_integration_tab">`;
  //c+= `contenu onglet Intégration`;
	c+= "<h4 class='premier'>Insérer un code d'intégration <button id='box_bt_integration' class='btn btn-primary btn-sm'>Valider ce code</button> <button id='code_int_supprimer_saisie' class='btn btn-warning btn-sm px-2 py-0' title='Supprimer ce code'><i class='bi bi-trash3-fill' style='font-size:1.4em;'></i></button> </h4>";
  c+= `<textarea id="lect_saisie_code_integration" class="form-control mb-2" placeholder="Coller le code d'intégration et valider"></textarea>`;
  c+= `<p>Le code d'intégration permet d'afficher dans une iframe une vidéo ou une activité interactive. On le récupère généralement via un bouton "Partager" ou "Intégrer".</p>`;
  c+= `</div>`;//fin #lecteur_integration

  c+= `<div class="tab-pane fade" id="lecteur_lien" role="tabpanel" aria-labelledby="lecteur_lien_tab">`;
  //c+= `contenu onglet Lien`;
	c+= "<h4 class='premier'>Ouvrir un lien hypertexte et générer un QRCode <button id='box_bt_lienqrcode' class='btn btn-primary btn-sm'>Afficher</button></h4>";
  c+= `<p>Après avoir saisi l'URL du site et éventuellement son nom, valider, puis scanner le QRCode ou cliquer dessus pour ouvrir le lien dans une nouvelle fenêtre.</p>`;
	c+= "<h4 class='premier'>Répertorier mes liens favoris <button id='box_bt_lienfavori' class='btn btn-primary btn-sm'>Afficher</button></h4>";
  c+= `<p>Les liens sont matérialisés par des boutons proposant 5 couleurs au choix. Ils peuvent être exportés et importés, et sont automatiquement enregistrés dans l'espace LocalStorage du navigateur Web utilisé.</p>`;
  c+= `</div>`;//fin #lecteur_lien

  c+= `<div class="tab-pane fade" id="lecteur_recherche" role="tabpanel" aria-labelledby="lecteur_recherche_tab">`;
  //c+= `contenu onglet Recherche`;
	c+= "<h4 class='premier'>Rechercher sur Internet <button id='box_bt_recherche' class='btn btn-primary btn-sm'>Afficher</button></h4><p>Saisir un mot-clé et sélectionner le type de recherche et le site souhaités pour consulter le résultat de la recherche dans un nouveal onglet.</p>";
  c+= `</div>`;//fin #lecteur_recherche

  c+= ``;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div></div></div>`;
  // Ajouter la modale dans le body
  $("body").append(c);

  modGalerieImages();
  modSVocale();
  modPrompteur();
  modPdf();
  modAudio();
  modMusique();
  modVideo();
  modIntegration();
  modLienQrcode();
  modLienFavori();
  modRecherche();
  $('#lecteur_integration_tab').on('click', function () {
    $("#lect_saisie_code_integration").focus();
  });


}// FIN fondsGenererOngletLecteur()


function modGalerieImages() {
  let c = `<div id="conteneur_galerie" class="carousel slide h-100">`;
  c+= `<div class="carousel-inner h-100">`;
  // générer les items et ajouter active au premier
  c+= `</div>`;
  c+= `<button class="carousel-control-prev" type="button" data-bs-target="#conteneur_galerie" data-bs-slide="prev">`;
  c+= `<span class="carousel-control-prev-icon" aria-hidden="true"></span>`;
  c+= `<span class="visually-hidden">Previous</span>`;
  c+= `</button>`;
  c+= `<button class="carousel-control-next" type="button" data-bs-target="#conteneur_galerie" data-bs-slide="next">`;
  c+= `<span class="carousel-control-next-icon" aria-hidden="true"></span>`;
  c+= `<span class="visually-hidden">Next</span>`;
  c+= `</button>`;
  c+= `</div>`;

/* Ouvrir la box Galerie d'images */
  $('#box_bt_galerie_images').on('click', function () {

    creerBox('box_galerie_images', 350, 300, ["box-move", "box-resize"], "Galerie d'images", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_lecteur')).hide();

    ctn = "";
    $("#galerie_images_apercu .image-container img").each(function(i) {
      const src = $(this).attr("src");
      const alt = $(this).attr("alt");
      ctn += `<div class="carousel-item h-100`+(i == 0 ? ` active` : '')+`"><img src="`+src+`" alt="`+alt+`"></div>`;
    });
    $("#conteneur_galerie .carousel-inner").html(ctn);
  });

}


function modSVocale() {
  let c = `<div id="sv_saisie">`;
  c+= `<div id="sv_header_saisie">`;
  c+= `<div class="d-flex justify-content-between">`;
  c+= `<div class="mt-2">Saisir ou coller le texte à lire</div>`;
  c+= `<button id="sv_bt_valider" class="btn btn-success btn-sm">Valider</button>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<textarea id="sv_saisie_texte" class="form-control"></textarea>`;
  c+= `</div>`;
  c+= `<div id="sv_lecture" style="display:none;">`;
  c+= `<div id="sv_header_lecture">`;
  c+= `<div class="d-flex justify-content-between">`;
  c+= `<div>`;
  c+= `<button id="sv_bt_play" class="btn btn-success btn-sm py-0 me-1" disabled><i class="bi bi-play-fill" style="font-size: 1.4em;" title="Écouter"></i></button>`;
  c+= `<button id="sv_bt_reset" class="btn btn-warning btn-sm py-0" disabled><i class="bi bi-arrow-clockwise" style="font-size: 1.4em;" title="Réinitialiser"></i></button>`;
  c+= `</div>`;
  c+= `<button id="sv_bt_retour" class="btn btn-secondary btn-sm">Retour</button>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div id="sv_texte_lu"></div>`;
  c+= `</div>`;

  /* Ouvrir la box Synthèse vocale */
  $('#box_bt_svocale').on('click', function () {
    creerBox('box_svocale', 400, 300, ["box-move", "box-resize"], "Synthèse vocale", 10, 10, html=c, null, true, $('#box-container'),
      function (boxId) {
        //console.log('Box fermée :', boxId);
        synth.cancel();
      }
    );
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_lecteur')).hide();
    box_svocaleCode();
  });
}
function box_svocaleCode() {
    //const synth = window.speechSynthesis;// déjà déclaré en global
    let utterance;
    let words = [];
    let currentIndex = 0;
    let playing = false;
    let stopped = false;

    const textInput = document.getElementById("sv_saisie_texte");
    const output = document.getElementById("sv_texte_lu");
    const playBtn = document.getElementById("sv_bt_play");
    const resetBtn = document.getElementById("sv_bt_reset");

    textInput.addEventListener("input", () => {
      const hasText = textInput.value.trim().length > 0;
      playBtn.disabled = !hasText;
      resetBtn.disabled = !hasText;
    });

    function splitTextIntoWords(text) {
      return text.match(/\S+|\s+/g) || [];
    }

    function renderText(words, highlightIndex = -1) {
      output.innerHTML = words.map((word, i) => {
        const w = word.replace(/\n/g, "<br>");
        return i === highlightIndex ? `<span class="highlight">${w}</span>` : w;
      }).join('');
    }

    function getWordIndexFromCharIndex(charIndex, wordList) {
      let count = 0;
      for (let i = 0; i < wordList.length; i++) {
        count += wordList[i].length;
        if (count > charIndex) return i;
      }
      return wordList.length - 1;
    }

    function speakFromCurrentIndex() {
      const remainingText = words.slice(currentIndex).join('');
      if (!remainingText.trim()) return;

      utterance = new SpeechSynthesisUtterance(remainingText);
      utterance.lang = 'fr-FR';
      utterance.rate = 1;

      let lastSpokenIndex = currentIndex;

      utterance.onboundary = function (event) {
        if (event.name === "word" || event.charIndex !== undefined) {
          const offset = getWordIndexFromCharIndex(event.charIndex, words.slice(currentIndex));
          const absoluteIndex = currentIndex + offset;
          renderText(words, absoluteIndex);
          lastSpokenIndex = absoluteIndex;
        }
      };

      utterance.onend = () => {
        if (!stopped) {
          currentIndex = 0;
          renderText(words, -1);
        } else {
          currentIndex = lastSpokenIndex;
        }
        playing = false;
        //playBtn.textContent = "▶️ Reprendre";
        playBtn.innerHTML = "<i class='bi bi-play-fill' style='font-size: 1.4em;' title='Reprendre'></i>";
      };

      synth.speak(utterance);
      playing = true;
      stopped = false;
      //playBtn.textContent = "⏹️ Arrêter";
      playBtn.innerHTML = "<i class='bi bi-stop-fill' style='font-size: 1.4em;' title='Arrêter'></i>";
    }

    playBtn.addEventListener("click", () => {
      if (playing) {
        synth.cancel();
        playing = false;
        stopped = true;
        //playBtn.textContent = "▶️ Reprendre";
        playBtn.innerHTML = "<i class='bi bi-play-fill' style='font-size: 1.4em;' title='Reprendre'></i>";
      } else {
        if (currentIndex === 0) {
          words = splitTextIntoWords(textInput.value);
          renderText(words);
        }
        speakFromCurrentIndex();
      }
    });

    resetBtn.addEventListener("click", () => {
      synth.cancel();
      utterance = null;
      currentIndex = 0;
      playing = false;
      stopped = false;
      //playBtn.textContent = "▶️ Écouter";
      playBtn.innerHTML = "<i class='bi bi-play-fill' style='font-size: 1.4em;' title='Écouter'></i>";
      words = splitTextIntoWords(textInput.value);
      renderText(words);
    });

    $("#sv_saisie_texte").focus();

    /* Passer en mode lecture */
    $('#sv_bt_valider').on('click', function () {
      const texte_saisi = $("#sv_saisie_texte").val().trim();
      if (texte_saisi !== "") {
          $("#sv_saisie").hide();
          $("#sv_lecture").show();
      } else {
        alert("Oups ! Aucun texte n'est à lire !");
        setTimeout(() => $("#sv_saisie_texte").focus(), 100);
      }
    });

    /* Passer en mode saisie */
    $('#sv_bt_retour').on('click', function () {
      $("#sv_lecture").hide();
      $("#sv_saisie").show();
      $("#sv_saisie_texte").focus();
    });

}

function modPrompteur() {
  let c = `<div id="prompteur">`;
  c+= `<div id="promToolbar">`;
  c+= `<span class="btn btn-light btn-sm btn-light-static px-1 py-0" id="promTimer" title="Durée de lecture" style="font-size: 1.2em;">00:00</span>`;
  c+= `<button id="promToggleTheme" class="btn btn-light btn-sm px-1 py-0" title="Changer le thème"><i class="bi bi-brightness-low-fill" style="font-size:1.4em"></i></button>`;
  c+= `<button id="promToggleAlign" class="btn btn-light btn-sm px-1 py-0" title="Modifier l'alignement"><i class="bi bi-align-center" style="font-size:1.4em"></i></button>`;
  c+= `<button id="promPlayPause" class="btn btn-success btn-sm px-1 py-0"><i class="bi bi-play-fill" style="font-size:1.4em"></i></button>`;
  c+= `<button id="promStart" class="btn btn-warning btn-sm px-1 py-0 me-3" title="Réafficher le texte"><i class="bi bi-rewind-fill" style="font-size:1.4em"></i></button>`;
  c+= `V. <span id="promSpeedVal">5</span>`;
  c+= `<input id="promSpeed" type="range" min="1" max="10" value="3" title="Modifier la vitesse de défilement">`;
  c+= `T. <span id="promFontSizeVal">24px</span>`;
  c+= `<input id="promFontSize" type="range" min="16" max="60" value="24"  title="Modifier la taille du texte">`;
  c+= `L. <span id="promWidthVal">100%</span>`;
  c+= `<input id="promWidth" type="range" min="50" max="100" value="100" title="Modifier la largeur de la zone de texte">`;
  c+= `</div>`;
  c+= `<div id="promText">`;
  c+= `<div id="promTextWrapper" contenteditable="true">Coller ou saisir ici le texte à faire défiler...</div>`;
  c+= `</div>`;
  c+= `</div>`;

  /* Ouvrir la box Prompteur */
  $('#box_bt_prompteur').on('click', function () {
    creerBox('box_prompteur', 700, 400, ["box-move", "box-resize"], "Prompteur", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_lecteur')).hide();
    box_promteurCode();
  });
}
function box_promteurCode() {
    const promText = document.getElementById('promText');
    const promTextWrapper = document.getElementById('promTextWrapper');
    const promToggleTheme = document.getElementById('promToggleTheme');
    const promToggleAlign = document.getElementById('promToggleAlign');
    const promPlayPause = document.getElementById('promPlayPause');
    const promStart = document.getElementById('promStart');
    const promSpeed = document.getElementById('promSpeed');
    const promSpeedVal = document.getElementById('promSpeedVal');
    const promFontSize = document.getElementById('promFontSize');
    const promFontSizeVal = document.getElementById('promFontSizeVal');
    const promWidth = document.getElementById('promWidth');
    const promWidthVal = document.getElementById('promWidthVal');
    const promTimer = document.getElementById('promTimer');

    const promSpeedFactor = 0.1; // facteur d’échelle ajustable pour la vitesse

    let promIsDark = true;
    let promIsCentered = false;
    let promIsPlaying = false;
    let promScrollSpeed = 5;
    let promStartTime = null;
    let promAnimFrame = null;
    let promOffset = 0;

    function promUpdateSpeed() {
      promScrollSpeed = parseInt(promSpeed.value) * promSpeedFactor;
      promSpeedVal.textContent = promSpeed.value;
    }

    function promUpdateFontSize() {
      promTextWrapper.style.fontSize = promFontSize.value + 'px';
      promFontSizeVal.textContent = promFontSize.value + 'px';
    }

    function promUpdateWidth() {
      promTextWrapper.style.width = promWidth.value + '%';
      promWidthVal.textContent = promWidth.value + '%';
    }

    promToggleTheme.addEventListener('click', () => {
      promIsDark = !promIsDark;
      promText.style.backgroundColor = promIsDark ? '#000' : '#fff';
      promText.style.color = promIsDark ? '#fff' : '#000';
    });

    promToggleAlign.addEventListener('click', () => {
      promIsCentered = !promIsCentered;
      promTextWrapper.style.textAlign = promIsCentered ? 'center' : 'left';
    });

    promPlayPause.addEventListener('click', () => {
      if (promIsPlaying) {
        cancelAnimationFrame(promAnimFrame);
        promIsPlaying = false;
        //promPlayPause.textContent = 'Play';
        promPlayPause.innerHTML = '<i class="bi bi-play-fill" style="font-size:1.4em"></i>';
      } else {
        promStartTime = performance.now();
        promIsPlaying = true;
        //promPlayPause.textContent = 'Pause';
        promPlayPause.innerHTML = '<i class="bi bi-pause-fill" style="font-size:1.4em"></i>';
        promScroll();
      }
    });

    promStart.addEventListener('click', () => {
      promOffset = 0;
      promTextWrapper.style.transform = `translateY(${promOffset}px)`;
      promStartTime = performance.now();
      promTextWrapper.focus();
    });

    promSpeed.addEventListener('input', promUpdateSpeed);
    promFontSize.addEventListener('input', promUpdateFontSize);
    promWidth.addEventListener('input', promUpdateWidth);

    function promScroll(timestamp) {
      if (!promIsPlaying) return;
      if (promStartTime === null) promStartTime = timestamp;

      promOffset -= promScrollSpeed;
      promTextWrapper.style.transform = `translateY(${promOffset}px)`;

      const minutes = Math.floor((timestamp - promStartTime) / 60000);
      const seconds = Math.floor(((timestamp - promStartTime) % 60000) / 1000);
      promTimer.textContent = `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;

      const wrapperBottom = promTextWrapper.getBoundingClientRect().bottom;
      const containerTop = promText.getBoundingClientRect().top;

      if (wrapperBottom > containerTop) {
        promAnimFrame = requestAnimationFrame(promScroll);
      } else {
        promIsPlaying = false;
        //promPlayPause.textContent = 'Play';
        promPlayPause.innerHTML = '<i class="bi bi-play-fill" style="font-size:1.4em"></i>';
      }
    }

    // Initial setup
    promUpdateSpeed();
    promUpdateFontSize();
    promUpdateWidth();
    promStart.click();

}

function modPdf() {
  let c = `<iframe class='pdf_lecteur'></iframe>`;

   $('#box_bt_pdf').on('change', function (event) {
    const idAlea = "id_"+Date.now();
    const file = event.target.files[0];
    if (file && file.type === 'application/pdf') {
      const fileURL = URL.createObjectURL(file);
      creerBox(idAlea, 350, 210, ["box-move", "box-resize", "box-iframe" , "box-pdf" , "box-blob"], "Lecteur de PDF", 10, 10, html=c, null, true);
      $('#'+idAlea+' .pdf_lecteur').attr('src', fileURL);
      bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_lecteur')).hide();
    } else {
      alert('Veuillez sélectionner un fichier PDF valide.');
    }
  });
  
}

function modAudio() {

  /* Ouvrir la box Lecteur audio */
  $('#box_bt_audio').on('change', function (e) {
    const lectAlea = "lect_"+Date.now();
    const idAlea = "id_"+Date.now();
    creerBox(idAlea, 350, 100, ["box-move", "box-resize", "lecteur_audio", "box-blob"], "Lecteur audio", 10, 10, html="<div id='"+lectAlea+"'></div>", null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_lecteur')).hide();

    const lecteurDiv = document.getElementById(lectAlea);
    let objectUrl = null;

      const file = e.target.files[0];
      if (!file) return;
      if (!file.type.startsWith('audio/')) {
        alert('Veuillez sélectionner un fichier audio valide.');
        return;
      }

      if (objectUrl) {
        URL.revokeObjectURL(objectUrl);
      }
      objectUrl = URL.createObjectURL(file);

      // Extraire le nom du fichier sans extension et remplacer les _ par des -
      const nomSansExt = file.name
      .replace(/\.[^/.]+$/, "") // enlève l’extension
      .replace(/_/g, "-");      // remplace les _ par des -

      // Vider et reconstruire le lecteur
      lecteurDiv.innerHTML = '';

      $("#"+idAlea+" .box-title").text(nomSansExt);

      const audio = document.createElement('audio');
      audio.controls = true;
      audio.src = objectUrl;

      //lecteurDiv.appendChild(titreDiv);
      lecteurDiv.appendChild(audio);

  });
}

/* Ecouter une musique relaxante */
function modMusique() {
  $('.bt_musique').on('click', function () {
    const mus = $(this).attr("data-son");
    const nom = $(this).text();
    c = `<audio controls="" src="medias/musiques/`+mus+`.mp3"></audio>`;
    creerBox("id_"+mus, 350, 100, ["box-move", "box-resize", "lecteur_audio"], nom, 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_lecteur')).hide();
  });
}

function modVideo() {
  /* Ouvrir la box Lecteur vidéo */
  $('#box_bt_video').on('change', function (e) {
    const lectAlea = "lect_"+Date.now();
    const idAlea = "id_"+Date.now();
    creerBox(idAlea, 350, 260, ["box-move", "box-resize", "lecteur_video", "box-blob"], "Lecteur vidéo", 10, 10, html="<div id='"+lectAlea+"'></div>", null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_lecteur')).hide();

    const inputVideo = document.getElementById(idAlea);
    const lecteurVideoDiv = document.getElementById(lectAlea);
    let videoUrl = null;

      const file = e.target.files[0];
      if (!file) return;
      if (!file.type.startsWith('video/')) {
        alert('Veuillez sélectionner un fichier vidéo valide.');
        return;
      }

      if (videoUrl) {
        URL.revokeObjectURL(videoUrl);
      }
      videoUrl = URL.createObjectURL(file);

      // Extraire le nom du fichier sans extension et remplacer les _ par des -
      const nomSansExt = file.name
      .replace(/\.[^/.]+$/, "") // enlève l’extension
      .replace(/_/g, "-");      // remplace les _ par des -

      // Vider et reconstruire le lecteur
      lecteurVideoDiv.innerHTML = '';

      //const titreDiv = document.createElement('div');
      //titreDiv.className = 'nom_sans_ext';
      //titreDiv.textContent = nomSansExt;
      $("#"+idAlea+" .box-title").text(nomSansExt);

      const video = document.createElement('video');
      video.controls = true;
      video.src = videoUrl;

      //lecteurVideoDiv.appendChild(titreDiv);
      lecteurVideoDiv.appendChild(video);

  });
}


function modIntegration() {

  //* Vider le champ de saisie 
  $('#code_int_supprimer_saisie').on('click', function () {
    $("#lect_saisie_code_integration").val("");
    $("#lect_saisie_code_integration").focus();
  });

  //* Ouvrir la box Code d'intégration 
  $('#box_bt_integration').on('click', function () {
    const codeSaisi = $("#lect_saisie_code_integration").val().trim();
    console.log(codeSaisi);
    if (codeSaisi === "") {
      alert("Oups ! Aucun code n'a été saisi...");
      setTimeout(function(){ $("#lect_saisie_code_integration").focus(); }, 100);
      return;
    }
    if (!codeSaisi.indexOf("<iframe") == 0) {
      alert("Oups ! Le code devrait commencer par <iframe...");
      setTimeout(function(){ $("#lect_saisie_code_integration").focus(); }, 100);
      return;
    }
    
    const idAlea = "id_"+Date.now();
    creerBox(idAlea, 300, 250, ["box-move", "box-resize", "code_integration"], "Code d'intégration", 10, 10, html=sanitizeEmbed(codeSaisi), null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_lecteur')).hide();
  });
}
function sanitizeEmbed(code) {
  const parser = new DOMParser();
  const doc = parser.parseFromString(code, "text/html");
  
  // Supprimer tous les <script>, <link>, <style>
  doc.querySelectorAll("script, link, style").forEach(el => el.remove());
  
  // Supprimer tous les attributs suspects (onerror, onclick, etc.)
  doc.querySelectorAll("*").forEach(el => {
    [...el.attributes].forEach(attr => {
      if (/^on/i.test(attr.name)) {
        el.removeAttribute(attr.name);
      }
    });
  });
  
  // Retourner uniquement le contenu body
  return doc.body.innerHTML;
}

/*
function modIntegration() {

  // Effacer le champ 
  $('#code_int_supprimer_saisie').on('click', function () {
    $("#lect_saisie_code_integration").val("").focus();
  });

  // Ouvrir la box Code d'intégration
  $('#box_bt_integration').on('click', function () {

    const codeSaisi = $("#lect_saisie_code_integration").val().trim();

    if (codeSaisi === "") {
      alert("Oups ! Aucun code n'a été saisi...");
      setTimeout(() => $("#lect_saisie_code_integration").focus(), 100);
      return;
    }

    // Vérifier que cela contient bien un iframe
    if (!codeSaisi.toLowerCase().includes("<iframe")) {
      alert("Oups ! Le code doit contenir une balise <iframe>...");
      setTimeout(() => $("#lect_saisie_code_integration").focus(), 100);
      return;
    }

    // --- Nettoyage sécurisé ---
    const sanitized = sanitizeEmbed(codeSaisi);

    // --- Encodage Base64 pour empêcher toute corruption ---
    const encoded = btoa(unescape(encodeURIComponent(sanitized)));

    // Créer la box
    const idAlea = "id_" + Date.now();
    creerBox(
      idAlea,
      300,
      250,
      ["box-move", "box-resize", "code_integration"],
      "Code d'intégration",
      10,
      10,
      encoded,
      null,
      true
    );

    bootstrap.Modal.getInstance(
      document.getElementById('outils_modal_act_lecteur')
    ).hide();
  });
}

function sanitizeEmbed(code) {

  const parser = new DOMParser();
  const doc = parser.parseFromString(code, "text/html");

  // Supprimer totalement les éléments dangereux
  doc.querySelectorAll("script, link, style").forEach(el => el.remove());

  // Garder UNIQUEMENT iframe / video / audio / embed / object
  const allowed = ["IFRAME", "VIDEO", "AUDIO", "EMBED", "OBJECT"];

  doc.body.querySelectorAll("*").forEach(el => {
    if (!allowed.includes(el.tagName)) {
      el.remove();
      return;
    }

    // Supprimer les attributs dangereux (onerror, onclick…)
    [...el.attributes].forEach(attr => {
      if (/^on/i.test(attr.name)) el.removeAttribute(attr.name);
      if (attr.name === "srcdoc") el.removeAttribute("srcdoc");
      if (attr.name === "sandbox" && el.tagName !== "IFRAME") el.removeAttribute("sandbox");
    });

    // Sécurisation légère, sans casser les lecteurs vidéo
    if (el.tagName === "IFRAME") {
      // Forcer quelques attributs sûrs
      el.setAttribute("loading", "lazy");

      // Pas de sandbox ici : cela CASSERAIT YouTube/Vimeo/Dailymotion…
      // On ne l’ajoute donc PAS !
    }
  });

  return doc.body.innerHTML;
}
*/

function modLienQrcode() {
  let c = `<div class="conteneur_lien">`;
  c+= `<div class="input-group input-group-sm mb-1 lien_bts_saisie">`;
  c+= `<input type="text" class="form-control lien_saisie_url" placeholder="Saisir l'URL et valider">`;
  c+= `<button class="btn btn-success btn-sm lien_bt_valider px-2 py-0" type="button"><i class="bi bi-check-lg" style="font-size: 1.4em;"></i></button>`;
  c+= `</div>`;
  c+= `<div class="form-group input-group-sm lien_bts_saisie">`;
  c+= `<input type="text" class="form-control lien_bt_nom" placeholder="Nom du lien (facultatif)">`;
  c+= `</div>`;
  c+= `<div class="lien_retouretqr" style="display:none;">`;
  c+= `<div class="text-center"><button class="btn btn-info btn-sm lien_bt_retour" type="button">Voir l'URL</button></div>`;
  c+= `<div class="lien_qrcode"></div>`;
  c+= `</div>`;
  c+= `</div>`;

  /* Ouvrir la box Lien QRCode */
  $('#box_bt_lienqrcode').on('click', function () {
    const idAlea = "id_"+Date.now();
    creerBox(idAlea, 250, 260, ["box-move", "lecteur_lien"], "Lien QRCode", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_lecteur')).hide();

    $("#"+idAlea+" .lien_saisie_url").focus();
    box_bt_lienqrcodeCode();

  });
}

function box_bt_lienqrcodeCode() {
  /* Récupérer l'URL et afficher le QRCode */
  $('.lien_bt_valider').on('click', function () {
    const lien = $(this).prev().val().trim();

    // on vérifie l'URL
    try {
      const testUrl = new URL(lien);
      if (!/^https?:/.test(testUrl.protocol)) {
        alert("Oups ! Saisir une URL commençant par http:// ou https://...");
        return;
      }
    } catch {
      alert("Oups ! Saisir une URL dans le champ URL.");
      return;
    }

    $(this).closest(".conteneur_lien").find(".lien_retouretqr").show();

    $(this).closest(".conteneur_lien").find(".lien_qrcode").html("").attr({"title":"Cliquer pour ouvrir le lien" , "data-url":lien}).css("cursor","pointer").qrcode({
      text : lien,
      width : 150,
      height : 150
    });

    const nomLien = $(this).closest(".conteneur_lien").find(".lien_bt_nom").val().trim();
    $(".lien_bts_saisie").hide();
    if (nomLien !== "") $(".lecteur_lien .box-title").text(nomLien);
  });

  // Ouvrir le lien
  $('.lien_qrcode').on('click', function () {
    const lien = $(this).attr("data-url");
    window.open(lien,"_blank");
  });

  // Revenir à l'url
  $('.lien_bt_retour').on('click', function () {
    $(".lien_retouretqr").hide();
    $(".lien_bts_saisie").show();
  });

}

function modLienFavori() {
  let c = `<div id="replien_conteneur">`;
  c+= `<div id="replien_header" class="d-flex justify-content-between">`;
  c+= `<div>`;
  c+= `<button id="replien_bt_ajouter_bt" class="btn btn-info btn-sm me-1">Ajouter un bouton</button>`;
  c+= `<button id="replien_bt_editer_explorer" class="replien_explorer btn btn-secondary btn-sm" title="Cliquer pour passer en mode Édition"><i class="bi bi-box-arrow-up-right"></i></button>`;
  c+= `</div>`;
  c+= `<div>`;
  c+= `<button id="replien_bt_exporter_json" title="Exporter en JSON" class="btn btn-outline-dark btn-sm px-2 py-0 me-1"><i class="bi bi-upload" style="font-size: 1.4em;"></i></button>`;
  c+= `<button id="replien_bt_importer_json" title="Importer un ficher exporté" class="btn btn-outline-dark btn-sm px-2 py-0 me-1"><i class="bi bi-download" style="font-size: 1.4em;"></i></button>`;
  c+= `<input type="file" id="replien_input_importer_json" accept=".json" style="display:none;" />`;
  c+= `<button id="replien_bt_supprimer_ls" title="Supprimer tous les liens enregistrés sur ce poste" class="btn btn-outline-dark btn-sm px-2 py-0"><i class="bi bi-trash3" style="font-size: 1.4em;"></i></button>`;
  c+= `</div>`;
  c+= `<div id="replien_edition" class="bg-primary-subtle" style="display:none;">`;
  c+= `<div class="input-group mb-1">`;
  c+= `<span class="input-group-text" aria-describedby="replien_saisie_nom_lien">Nom</span>`;
  c+= `<input id="replien_saisie_nom_lien" type="text" class="form-control" placeholder="Nom du lien" aria-label="Nom du lien">`;
  c+= `</div>`;
  c+= `<div class="input-group mb-2">`;
  c+= `<span class="input-group-text" aria-describedby="replien_saisie_url_lien">URL</span>`;
  c+= `<input id="replien_saisie_url_lien" type="url" class="form-control" placeholder="URL du lien" aria-label="URL du lien">`;
  c+= `</div>`;
  c+= `<div class="d-flex justify-content-between">`;
  c+= `<div>`;
  c+= `<div data-coul="primary" class="replien_couleur bg-primary"></div>`;
  c+= `<div data-coul="warning" class="replien_couleur bg-warning on"></div>`;
  c+= `<div data-coul="secondary" class="replien_couleur bg-secondary"></div>`;
  c+= `<div data-coul="danger" class="replien_couleur bg-danger"></div>`;
  c+= `<div data-coul="success" class="replien_couleur bg-success"></div>`;
  c+= `</div>`;
  c+= `<div>`;
  c+= `<button id="relien_bt_supprimer_lien" class="btn btn-warning btn-sm px-2 py-0  me-1"><i class="bi bi-trash3" style="font-size: 1.4em;"></i></button>`;
  c+= `<button id="relien_bt_annuler" class="btn btn-secondary btn-sm px-2 py-0 me-1"><i class="bi bi-escape" style="font-size: 1.4em;"></i></button>`;
  c+= `<button id="relien_bt_valider_lien" class="btn btn-success btn-sm px-2 py-0"><i class="bi bi-check-lg" style="font-size: 1.4em;"></i></button>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div id="replien_body"></div>`;
  c+= `</div>`;

  
  /* Ouvrir la box Lien Favori */
  $('#box_bt_lienfavori').on('click', function () {
    creerBox('box_lienfavori', 320, 250, ["box-move", "box-resize"], "Liens Favoris", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_lecteur')).hide();
    box_lienfavoriCode();
  });
}
function box_lienfavoriCode() {
  /* --- Chargement initial depuis localStorage ou données par défaut --- */
  let replienData = [];
  if (localStorage.getItem("replienData")) {
    replienData = JSON.parse(localStorage.getItem("replienData"));
  }

  /* Fonction utilitaire pour trier par nom */
  function trierReplienData() {
    replienData.sort((a, b) => a.nom.localeCompare(b.nom, "fr", { sensitivity: "base" }));
  }

  /* Sauvegarde dans localStorage */
  function sauvegarderReplien() {
    localStorage.setItem("replienData", JSON.stringify(replienData));
  }

  /* Affichage des boutons */
  function repLienAfficherBoutons() {
    $("#replien_body").html("");
    replienData.forEach((lien) => {
      $("#replien_body").append(`<button id="${lien.id}" type="button" data-url="${lien.url}" class="replien_bt_lien btn btn-${lien.couleur} btn-sm m-1">${lien.nom}</button>`);
    });
  }
  repLienAfficherBoutons();

  /* Ajouter un nouveau bouton */
  $('#replien_bt_ajouter_bt').on('click', function () {
    $("#replien_edition").slideDown();
    $("#replien_saisie_nom_lien").val("");
    $("#replien_saisie_url_lien").val("");
    $(".replien_couleur").removeClass("on");
    $(".replien_couleur[data-coul='warning']").addClass("on");
    $("#replien_saisie_nom_lien").focus();
    $('#relien_bt_valider_lien').attr("data-ouverture","ajouter").removeAttr("data-id");
  });

  /* Passer du mode édition au mode exploration */
  $('#replien_bt_editer_explorer').on('click', function () {
    if ($(this).hasClass("replien_explorer")) {
      $(this).removeClass("replien_explorer").addClass("replien_editer").attr('title',"Cliquer pour passer en mode Exploration").html('<i class="bi bi-pencil-fill"></i>');
    } else {
      $(this).removeClass("replien_editer").addClass("replien_explorer").attr('title',"Cliquer pour passer en mode Édition").html('<i class="bi bi-box-arrow-up-right"></i>');
    }
  });

  /* Repérer la couleur de fond du bouton */
  $('.replien_couleur').on('click', function () {
    $('.replien_couleur').removeClass("on");
    $(this).addClass("on");
  });

  /* Ouvrir ou éditer un lien */
  $("#replien_body").on("click", ".replien_bt_lien", function () {
    const id = $(this).attr("id");
    if ($("#replien_bt_editer_explorer").hasClass("replien_explorer")) {
      const url = $(this).attr("data-url");
      window.open(url,"_blank");
    } else {
      const lien = replienData.find(l => l.id === id);
      if (lien) {
        $("#replien_edition").slideDown();
        $("#replien_saisie_nom_lien").val(lien.nom);
        $("#replien_saisie_url_lien").val(lien.url);
        $(".replien_couleur").removeClass("on");
        $(`.replien_couleur[data-coul="${lien.couleur}"]`).addClass("on");
        $('#relien_bt_valider_lien').attr("data-ouverture","modifier").attr("data-id", id);
        $("#replien_saisie_nom_lien").focus();
      }
    }
  });

  /* Valider le lien */
  $('#relien_bt_valider_lien').on('click', function () {
    const nom = $("#replien_saisie_nom_lien").val().trim();
    const url = $("#replien_saisie_url_lien").val().trim();
    const couleur = $(".replien_couleur.on").attr("data-coul");

    // Vérification nom
    if (!nom) {
      alert("Oups ! Saisir un nom pour le bouton...");
      return;
    }

    // Vérification URL
    try {
      const testUrl = new URL(url);
      if (!/^https?:/.test(testUrl.protocol)) {
        alert("Oups ! Saisir une URL commençant par http:// ou https:// dans le champ URL...");
        return;
      }
    } catch {
      alert("Oups ! Saisir une URL dans le champ URL.");
      return;
    }

    if ($('#relien_bt_valider_lien').attr("data-ouverture") === "ajouter") {
      const id = "id" + Date.now();
      replienData.push({ id, nom, url, couleur });
    } else {
      const id = $(this).attr("data-id");
      const lien = replienData.find(l => l.id === id);
      if (lien) {
        lien.nom = nom;
        lien.url = url;
        lien.couleur = couleur;
      }
    }
    trierReplienData();
    sauvegarderReplien();
    repLienAfficherBoutons();
    $("#replien_edition").slideUp();
  });

  /* Supprimer le lien */
  $('#relien_bt_supprimer_lien').on('click', function () {
    const id = $("#relien_bt_valider_lien").attr("data-id");
    replienData = replienData.filter(l => l.id !== id);
    trierReplienData();
    sauvegarderReplien();
    repLienAfficherBoutons();
    $("#replien_edition").slideUp();
  });

  /* Fermer l'éditeur de lien */
  $('#relien_bt_annuler').on('click', function () {
    $("#replien_edition").slideUp();
  });

  /* Supprimer l'item du localstorage */
  $('#replien_bt_supprimer_ls').on('click', function () {
    if (confirm("Voulez-vous vraiment supprimer tous les liens enregistrés sur ce poste ?")) {
      replienData = [];
      localStorage.removeItem("replienData");
      repLienAfficherBoutons();
    }
  });

  /* Exporter en JSON */
  $('#replien_bt_exporter_json').on('click', function () {
    const blob = new Blob([JSON.stringify(replienData, null, 2)], { type: "application/json" });
    const url = URL.createObjectURL(blob);
    const a = document.createElement("a");
    a.href = url;
    //a.download = "liens.json";
    a.download = "liens-"+afficherDateEnr()+".json";
    a.click();
    URL.revokeObjectURL(url);
  });

  /* Importer un fichier JSON */
  $('#replien_bt_importer_json').on('click', function () {
    $('#replien_input_importer_json').click();
  });
  $('#replien_input_importer_json').change(function (e) {
    const file = e.target.files[0];
    if (!file) return;
    const reader = new FileReader();
    reader.onload = function (evt) {
      try {
        const data = JSON.parse(evt.target.result);
        if (Array.isArray(data)) {
          replienData = data;
          trierReplienData();
          sauvegarderReplien();
          repLienAfficherBoutons();
        } else {
          alert("Fichier JSON invalide.");
        }
      } catch {
        alert("Erreur lors de la lecture du fichier.");
      }
    };
    reader.readAsText(file);
  });

}

function modRecherche() {
  let c = `<div id="rechercher_conteneur">`;
  c+= `<input id="rech_saisie" type="search" class="form-control mb-1" placeholder="Saisir un mot-clé">`;
  c+= `<div class="dropup-center dropdown mb-1">`;
  c+= `<button class="btn btn-secondary dropdown-toggle w-100 btn-sm" type="button" data-bs-toggle="dropdown" aria-expanded="false">Tout média</button>`;
  c+= `<ul class="dropdown-menu w-100">`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="bing">Bing</a></li>`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="duckduckgo">DuckDuckGo</a></li>`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="ecosia">Ecosia</a></li>`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="google">Google</a></li>`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="qwant_junior">Qwant Junior</a></li>`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="qwant">Qwant</a></li>`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="wikipedia">Wikipédia</a></li>`;
  c+= `</ul>`;
  c+= `</div>`;
  c+= `<div class="dropup-center dropdown mb-1">`;
  c+= `<button class="btn btn-secondary dropdown-toggle w-100 btn-sm" type="button" data-bs-toggle="dropdown" aria-expanded="false">Images</button>`;
  c+= `<ul class="dropdown-menu w-100">`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="pixabay_photos">Pixabay Photo</a></li>`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="pixabay_illustration">Pixabay illustration</a></li>`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="arassac_picto">ARASAAC Pictogramme</a></li>`;
  c+= `</ul>`;
  c+= `</div>`;
  c+= `<div class="dropup-center dropdown">`;
  c+= `<button class="btn btn-secondary dropdown-toggle w-100 btn-sm" type="button" data-bs-toggle="dropdown" aria-expanded="false">Multimédia</button>`;
  c+= `<ul class="dropdown-menu w-100">`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="pixabay_musique">Pixabay Musique</a></li>`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="pixabay_bruitage">Pixabay Bruitage</a></li>`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="pixabay_video">Pixabay Vidéo</a></li>`;
  c+= `<li><a class="dropdown-item btn-sm rech_item" href="#" data-choix="pixabay_gif">Pixabay GIF</a></li>`;
  c+= `</ul>`;
  c+= `</div>`;
  c+= `</div>`;

  /* Ouvrir la box Recherche */
  $('#box_bt_recherche').on('click', function () {
    creerBox('box_recherche', 200, 190, ["box-move"], "Rechercher", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_lecteur')).hide();
    box_rechercheCode();
  });
}
function box_rechercheCode() {
  /* Ouvrir un item pour rechercher */
  $('.rech_item').on('click', function () {
    const saisie = $("#rech_saisie").val().trim();
    if (saisie !== "") {
      const choix = $(this).attr("data-choix");
      if (choix == "bing") window.open("https://www.bing.com/search?q="+saisie,"_blank");
      if (choix == "duckduckgo") window.open("https://duckduckgo.com/?q="+saisie+"&t=h_&ia=web","_blank");
      if (choix == "ecosia") window.open("https://www.ecosia.org/search?q="+saisie,"_blank");
      if (choix == "google") window.open("https://www.google.fr/search?hl=fr&q="+saisie,"_blank");
      if (choix == "qwant_junior") window.open("https://www.qwantjunior.com/?q="+saisie+"&t=web","_blank");
      if (choix == "qwant") window.open("https://www.qwant.com/?q="+saisie+"&t=web","_blank");
      if (choix == "wikipedia") window.open("https://fr.wikipedia.org/wiki/"+saisie,"_blank");
      if (choix == "pixabay_photos") window.open("https://pixabay.com/fr/photos/search/"+saisie+"/","_blank");
      if (choix == "pixabay_illustration") window.open("https://pixabay.com/fr/illustrations/search/"+saisie+"/","_blank");
      if (choix == "pixabay_musique") window.open("https://pixabay.com/fr/music/search/"+saisie+"/","_blank");
      if (choix == "pixabay_bruitage") window.open("https://pixabay.com/fr/sound-effects/search/"+saisie+"/","_blank");
      if (choix == "pixabay_video") window.open("https://pixabay.com/fr/videos/search/"+saisie+"/","_blank");
      if (choix == "pixabay_gif") window.open("https://pixabay.com/fr/gifs/search/"+saisie+"/","_blank");
      if (choix == "arassac_picto") window.open("https://aulaabierta.arasaac.org/fr/moteur-de-recherche-pictogrammes-arasaac#/?q="+saisie,"_blank");
     } else alert("Oups ! Saisir un mot-clé...");
  });
}

/*
id=''
id='box_bt_video'
id='box_bt_integration'
id='box_bt_lienqrcode'
id='box_bt_lienfavori'
id='box_bt_recherche'
*/

/*
function modNombreHasard() {
  let c = ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;

  /* Ouvrir la box Nombre au hasard MODELE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  $('#box_bt_nombre_hasard').on('click', function () {
    creerBox('box_nombre_hasard', 350, 210, ["box-move", "box-resize"], "Nombre au hasard", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_lecteur')).hide();
    box_nombre_hasardCode();
  });
}
function box_nombre_hasardCode() {
  // script....
}
*/

