/*****************************************/
/* Fonctions de Groupe                   */
/*****************************************/

/* Générer et gérer la modale de groupe */
function genererModaleGroupe() {
  // Génération de la modale
  let c = "";
  c+= `<div class="modal fade premier_plan" id="outils_modal_act_groupe" tabindex="-1" aria-hidden="true">`;
  c+= `<div class="modal-dialog modal-lg">`;
  c+= `<div class="modal-content bg-info-subtle">`;
  c+= `<div class="modal-header bg-info d-flex align-items-start justify-content-between py-2 px-2">`;
  c+= `<h1 class="modal-title fs-4">Gérer le groupe</h1>`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<button class="btn btn-warning ms-2" data-bs-dismiss="modal" title="Fermer"><i class="bi bi-x-lg"></i></button>`;
  c+= `</div>`;
  c+= `</div>`;// fin .modal-header
  c+= `<div class="modal-body">`;

  c+= `<ul class="nav nav-tabs" id="groupe_tabs" role="tablist">`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link active" id="groupe_presence_tab" data-bs-toggle="tab" data-bs-target="#groupe_presence" type="button" role="tab" aria-controls="groupe_presence" aria-selected="true">Présence</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="groupe_sonometre_tab" data-bs-toggle="tab" data-bs-target="#groupe_sonometre" type="button" role="tab" aria-controls="groupe_sonometre" aria-selected="true">Sonomètre</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="groupe_modalite_tab" data-bs-toggle="tab" data-bs-target="#groupe_modalite" type="button" role="tab" aria-controls="groupe_modalite" aria-selected="true">Modalités</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="groupe_compteur_tab" data-bs-toggle="tab" data-bs-target="#groupe_compteur" type="button" role="tab" aria-controls="groupe_compteur" aria-selected="true">Compteur de points</button>`;
  c+= `</li>`;

  c+= `</ul>`;// fin #groupe_tabs

  c+= `<div class="tab-content tab_content" id="groupe_content">`;

  c+= `<div class="tab-pane active" id="groupe_presence" role="tabpanel" aria-labelledby="groupe_presence_tab">`;
  //c+= `contenu onglet Présence`;
	c+= "<h4 class='premier'>Visualiser les présent(e)s <button id='box_bt_repartir_groupe_presence' class='btn btn-primary btn-sm'>Afficher</button></h4>";
  c+= `<ul><li>Il s'agit en fait de l'outil "Répartition" du module "Tirer au sort" pour lequel 3 groupes sont définis par défaut : 🏠 À la maison - 🕑 À l'école - 🥣 À la cantine.</li><li>On peut l'utiliser pour matérialiser les élèves présent(e)s, soit avec leur prénom, soit avec leur photo.</li><li><b>Pour changer un élève de groupe</b>, cliquer dessus, relâcher, puis cliquer dans le groupe souhaité.</li><li><b>Pour exporter et importer les groupes</b>, <span style="color:red;">utiliser les boutons d'import/export de ce widget</span>, et non pas les boutons généraux d'import/export.</li></ul>`;
  c+= `</div>`;//fin #groupe_presence

  c+= `<div class="tab-pane fade" id="groupe_sonometre" role="tabpanel" aria-labelledby="groupe_sonometre_tab">`;
  //c+= `contenu onglet Sonomètre`;
	c+= "<h4 class='premier'>Capter le bruit ambiant <button id='box_bt_sonometre' class='btn btn-primary btn-sm'>Afficher</button></h4>";
  c+= `<ul><li>Une barre de pogression montre le niveau sonore ambiant <em>(de 0 à 100 db)</em:>.</li>`;
  c+= `<li>En déplacçant le curseur, on définit le seuil <em>(le niveau sonore)</em> à ne pas dépasser.</li>`;
  c+= `<li>Un compteur affiche en temps réel la durée pendant laquelle le seuil n'a pas été dépassé plus de 3 secondes. Si le seuil est dépassé plus de 3 secondes :`;
  c+= `<ul><li>Le compteur s'arrête et si la durée est supérieure au record, elle s'affiche comme nouveau record.</li>`;
  c+= `<li>La barre de progression se fige et le sonomètre clignote.</li>`;
  c+= `<li>Si la sonnerie est actve, elle sonne.</li></ul></ul>`;
  c+= `</div>`;//fin #groupe_sonometre

  c+= `<div class="tab-pane fade" id="groupe_modalite" role="tabpanel" aria-labelledby="groupe_modalite_tab">`;
  //c+= `contenu onglet Modalités`;
	c+= "<h4 class='premier'>Présenter les modalités de travail <button id='box_bt_modalites_travail' class='btn btn-primary btn-sm'>Afficher</button></h4><p>On affiche le pictogramme du comportement attendu, et les outils à disposition. La couleur du widget peut être associée à un groupe.</p>";
	c+= "<h4 class='premier'>Animer des rétroactions <button id='box_bt_retroactions' class='btn btn-primary btn-sm'>Afficher</button></h4><p>On affiche brièvement une animation sonore ou non, accompagnant une bonne réponse, une mauvaise réponse, des applaudissements, une victoire, le passage au joueur suivant, ou la fin de l'activité.</p>";
	c+= "<h4 class='premier'>Afficher des feux multicolores <button id='box_bt_feux' class='btn btn-primary btn-sm'>Afficher</button></h4><p>Chaque enseignant(e) pourra associer une information à chaque couleur du feu <em>(bleu, vert, jaune, rouge)</em>.</p>";
  c+= `</div>`;//fin #groupe_modalite

  c+= `<div class="tab-pane fade" id="groupe_compteur" role="tabpanel" aria-labelledby="groupe_compteur_tab">`;
  //c+= `contenu onglet Compteur`;
	c+= "<h4 class='premier'>Compter les points de plusieurs équipes <button id='box_bt_compteur_points' class='btn btn-primary btn-sm'>Afficher</button></h4><ul><li>Jusqu'à 6 compteurs peuvent être affichés, identifiés par un nom d'équipe et une couleur.</li><li>On peut ajouter ou retirer un point sur les compteurs souhaités pour afficher le score en cours.</li></ul>";
  c+= `</div>`;//fin #groupe_compteur

  c+= ``;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div></div></div>`;
  // Ajouter la modale dans le body
  $("body").append(c);

  modRepartirGroupesPresence();
  modSonometre();
  modModalitesTravail();
  modRetroactions();
  modFeux();
  modCompteurPoints();

}// FIN genererModaleGroupe()

function modRepartirGroupesPresence() {
  let c = `<div class="container-fluid">`;
  c+= `<div id="repart_aff_param" class="repart_presence">`;
  c+= `<div class="bg-info d-flex align-items-center justify-content-between px-2 py-1 mb-3">`;
  c+= `<div>`;
  c+= `<button id="repart_bt_choix_texte" class="btn btn-dark btn-sm repart_choix_type_item me-1" title="Répartir des items sous forme de texte">Texte</button>`;
  c+= `<button id="repart_bt_choix_image" class="btn btn-outline-dark btn-sm repart_choix_type_item me-1" title="Répartir des items sous forme d'image">Image</button>`;
  c+= `<input type="file" id="repart_input_importer_json" accept=".json" style="display:none;" />`;
  c+= `</div>`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<button id="repart_bt_importer_json" class="btn btn-outline-dark btn-sm me-1 px-2 py-0" title="Importer un fichier JSON"><i class="bi bi-download" style="font-size:1.4em;"></i></button>`;
  c+= `<button id="repart_bt_afficher_tout" class="btn btn-success btn-sm">Générer les groupes</button>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div id="repart_si_texte" class="repart_texteouimage text-center">`;
  c+= `<h5>Saisir les items séparés par un point-virgule.</h5>`;
  c+= `<textarea id="repart_saisie_mots" class="form-control mb-3"></textarea>`;
  c+= `</div>`;
  c+= `<div id="repart_si_image" class="repart_texteouimage" style="display:none;">`;
  c+= `<div class="zone-images zone_repart" data-image-selector data-max-size="80">`;
  c+= `<h5>Déposer ou sélectionner des images</h5>`;
  c+= `<div class="inputs">`;
  c+= `<input type="file" multiple accept="image/*" class="input-fichiers">`;
  c+= `<input type="file" multiple accept="image/*" webkitdirectory class="input-dossier">`;
  c+= `</div>`;
  c+= `<button class="btn-fichiers btn btn-secondary btn-sm mx-1">Choisir des images</button>`;
  c+= `<button class="btn-dossier btn btn-secondary btn-sm mx-1">Choisir un dossier d'images</button>`;
  c+= `<button class="btn-supprimer-tout btn btn-secondary btn-sm mx-1" type="button">Tout supprimer</button>`;
  c+= `<div id="repart_img_selectionnees" class="apercu"></div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<h5 class="text-center">Ajouter ou supprimer des groupes, et les nommer</h5>`;
  c+= `<div id="repart_groupes_a_ajouter" class="mb-3"></div>`;
  c+= `</div>`;
  c+= `<div id="repart_aff_groupes" style="display:none;">`;
  c+= `<div class="bg-info d-flex align-items-center justify-content-between px-2 py-1 mb-3">`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<button id="repart_bt_items_col1" class="btn btn-secondary btn-sm me-1 px-2 py-0" title="Placer tous les items dans la 1ère colonne"><i class="bi bi-layout-sidebar-inset" style="font-size:1.4em;"></i></button>`;
  c+= `<button id="repart_bt_items_alea" class="btn btn-secondary btn-sm me-1 px-2 py-0" title="Répartir aléatoirement"><i class="bi bi-shuffle" style="font-size:1.4em;"></i></button>`;
  c+= `<button id="repart_bt_item_alpha" class="btn btn-secondary btn-sm me-1 px-2 py-0" title="Présenter les items dans l'ordre alphabétique"><i class="bi bi-sort-alpha-down" style="font-size:1.4em;"></i></button>`;
  c+= `</div>`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<input id="repart_taille" type="number" min="1" max="6" value="2" style="font-size:1.05em;" class="ms-1" title="Changer la taille des items">`;
  c+= `<button id="repart_bt_exporter_json" class="btn btn-outline-dark btn-sm ms-1 px-2 py-0" title="Exporter au format JSON"><i class="bi bi-upload" style="font-size:1.4em;"></i></button>`;
  c+= `<button id="repart_bt_retour" class="btn btn-success btn-sm ms-1 px-2 py-0" title="Retourner au paramétrage"><i class="bi bi-escape" style="font-size:1.4em;"></i></button>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div id="repart_conteneur">`;
  c+= `<div class="row"></div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div>`;

  /* Ouvrir la box Visualiser les présent(e)s => en fait Répartir dans des groupes */
  $('#box_bt_repartir_groupe_presence').on('click', function () {
    creerBox('box_repartir_groupe', 600, 430, ["box-move", "box-resize"], "Visualiser les présent(e)s", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_groupe')).hide();
    box_repartir_groupeCode();// fonction déjà incluse dans outils_module_tirage.js
  });
}

function modSonometre() {
  let c = `<div id="sonometre">`;
  c+= `<div id="sono_barre">`;
  c+= `<div id="sono_niveau_db" class="progress" role="progressbar" aria-label="Niveau sonore" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">`;
  c+= `<div class="progress-bar bg-success" style="width: 0%"></div>`;
  c+= `</div>`;
  c+= `<input type="range" id="sono_seuil" min="0" max="100" value="50">`;
  c+= `</div>`;
  c+= `<div id="sono_param" class="row mt-3 gx-0">`;
  c+= `<div class="col-4"><span id="sono_init"><i class="bi bi-arrow-clockwise" title="Redémarrer le compteur de durée courante"></i></span>`;
  c+= `<span id="sono_micro"><i class="bi bi-mic-mute" title="Activer le micro et démarrer le compteur"></i></span> <span id="sono_sonnerie"><i class="bi bi-bell-slash" title="Activer la sonnerie qui se déclenchera si le seuil est dépassé plus de 3 secondes"></i></span></div>`;
  c+= `<div class="col-4 text-end" title="Durée courante pendant laquelle le seuil n'a pas été dépassé plus de 3 secondes"><span id="sono_duree_sous_seuil">00:00</span></div>`;
  c+= `<div class="col-4 text-end" title="Durée record pendant laquelle le seuil n'a pas été dépassé plus de 3 secondes"><span id="sono_duree_record">00:00</span></div>`;
  c+= `</div>`;
  c+= `</div>`;

  /* Ouvrir la box Sonomètre */
  $('#box_bt_sonometre').on('click', function () {
    stopSono = box_sonometreCode(); // stocke la fonction de cleanup
    creerBox('box_sonometre', 350, 210, ["box-move", "box-resize"], "Sonomètre", 10, 10, html=c, null, true, $('#box-container'),
      function (boxId) {
        console.log('Box fermée :', boxId);
        // Comment arrêter proprement le sonomètre quand on ferme la box ?
        if (stopSono) stopSono(); // <- arrêt propre
      }
    );
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_groupe')).hide();
    //box_sonometreCode();
    // Initialisation unique du sonomètre après que le HTML soit en place
    stopSono = box_sonometreCode();
  });
}

let stopSono = null;
function box_sonometreCode() {
  let microActif = false;
  let sonnerieActive = false;
  let seuil = parseInt($("#sono_seuil").val());
  let dureeSousSeuil = 0;
  let record = 0;
  let depassementTemps = 0;
  let audioCtx = null;
  let analyser = null;
  let dataArray = null;
  let source = null;
  let stream = null;
  let animationId = null;
  const audio = new Audio("sonnerie.mp3");
  let modeSimulation = false;

  function majAffichageDuree(elem, sec) {
    let m = String(Math.floor(sec / 60)).padStart(2, "0");
    let s = String(sec % 60).padStart(2, "0");
    $(elem).text(`${m}:${s}`);
  }

  function getNiveauDb() {
    if (modeSimulation) {
      return Math.floor(Math.random() * 101);
    }
    analyser.getByteTimeDomainData(dataArray);
    let sum = 0;
    for (let i = 0; i < dataArray.length; i++) {
      let val = (dataArray[i] - 128) / 128;
      sum += val * val;
    }
    let rms = Math.sqrt(sum / dataArray.length);
    return Math.min(100, Math.max(0, Math.floor(rms * 200)));
  }

  function analyserSon() {
    seuil = parseInt($("#sono_seuil").val());
    let niveauDb = getNiveauDb();

    if (!$("#sonometre").hasClass("clignote")) {
      $("#sono_niveau_db .progress-bar")
        .css("width", niveauDb + "%")
        .attr("aria-valuenow", niveauDb);
    }

    if (niveauDb > seuil) {
      depassementTemps += 1 / 60;
      if (depassementTemps > 3) {
        if (dureeSousSeuil > record) {
          record = dureeSousSeuil;
          majAffichageDuree("#sono_duree_record", Math.floor(record));
        }
        $("#sonometre").addClass("clignote");
        $("#sono_niveau_db .progress-bar").addClass("bg-danger");
        if (sonnerieActive) {
          audio.play();
        }
        return;
      }
    } else {
      depassementTemps = 0;
      dureeSousSeuil += 1 / 60;
      majAffichageDuree("#sono_duree_sous_seuil", Math.floor(dureeSousSeuil));
    }

    animationId = requestAnimationFrame(analyserSon);
  }

  async function demarrerMicro() {
    try {
      audioCtx = new (window.AudioContext || window.webkitAudioContext)();
      stream = await navigator.mediaDevices.getUserMedia({ audio: true });
      source = audioCtx.createMediaStreamSource(stream);
      analyser = audioCtx.createAnalyser();
      analyser.fftSize = 256;
      dataArray = new Uint8Array(analyser.fftSize);
      source.connect(analyser);
      analyserSon();
    } catch (err) {
      alert(
        "Accès micro refusé ou impossible.\nCause probable : fichier ouvert en file:// dans Chrome/Edge/Safari.\nEssayez Firefox ou lancez via un petit serveur local."
      );
      modeSimulation = true;
      analyserSon();
    }
  }

  // CSS clignotement
  $("<style>")
    .prop("type", "text/css")
    .html(`
      .clignote { animation: blink 1s infinite; }
      @keyframes blink { 50% { opacity: 0.2; } }
    `)
    .appendTo("head");

  // Handlers
  $("#sono_micro > i").off("click").on("click", function () {
    microActif = !microActif;
    if (microActif) {
      demarrerMicro();
      $(this)
        .removeClass("bi-mic-mute")
        .addClass("bi-mic")
        .attr("title", "Désactiver le micro et arrêter le compteur");
    } else {
      if (animationId) cancelAnimationFrame(animationId);
      if (stream) stream.getTracks().forEach(track => track.stop());
      if (audioCtx) audioCtx.close();
      $(this)
        .removeClass("bi-mic")
        .addClass("bi-mic-mute")
        .attr("title", "Activer le micro et démarrer le compteur");
    }
  });

  $("#sono_sonnerie > i").off("click").on("click", function () {
    sonnerieActive = !sonnerieActive;
    if (sonnerieActive) {
      $(this)
        .removeClass("bi-bell-slash")
        .addClass("bi-bell")
        .attr("title", "Désactiver la sonnerie");
    } else {
      $(this)
        .removeClass("bi-bell")
        .addClass("bi-bell-slash")
        .attr("title", "Activer la sonnerie qui se déclenchera si le seuil est dépassé plus de 3 secondes");
    }
  });

  $("#sono_init").off("click").on("click", function () {
    dureeSousSeuil = 0;
    depassementTemps = 0;
    majAffichageDuree("#sono_duree_sous_seuil", 0);
    $("#sonometre").removeClass("clignote");
    $("#sono_niveau_db .progress-bar")
      .removeClass("bg-danger")
      .addClass("bg-success");
    if (microActif) {
      if (animationId) cancelAnimationFrame(animationId);
      analyserSon();
    }
  });

  // Valeurs initiales
  majAffichageDuree("#sono_duree_sous_seuil", 0);
  majAffichageDuree("#sono_duree_record", 0);

  // Fonction de nettoyage à appeler dans onClose
  return function stopSon() {
    if (animationId) cancelAnimationFrame(animationId);
    if (stream) stream.getTracks().forEach(track => track.stop());
    if (audioCtx) audioCtx.close();

    microActif = false;
    sonnerieActive = false;

    $("#sono_micro > i")
      .removeClass("bi-mic")
      .addClass("bi-mic-mute")
      .attr("title", "Activer le micro et démarrer le compteur");

    $("#sono_sonnerie > i")
      .removeClass("bi-bell")
      .addClass("bi-bell-slash")
      .attr("title", "Activer la sonnerie qui se déclenchera si le seuil est dépassé plus de 3 secondes");

    $("#sonometre").removeClass("clignote");
    $("#sono_niveau_db .progress-bar")
      .removeClass("bg-danger")
      .addClass("bg-success")
      .css("width", "0%");

    majAffichageDuree("#sono_duree_sous_seuil", 0);
    majAffichageDuree("#sono_duree_record", 0);

    // Supprimer les handlers
    $("#sono_micro > i").off("click");
    $("#sono_sonnerie > i").off("click");
    $("#sono_init").off("click");

    console.log("Sonomètre arrêté et réinitialisé");
  };
}

function modModalitesTravail() {
  let c = `<div class="modalite_w_conteneur" style="background-color: #FFF;">`;
  c+= `<div class="mod_aides row g-0 mb-1 py-1">`;
  c+= `<div class="col"><img src="medias/modalites/mod_ecriture.png" alt="Outils pour écrire" title="Outils pour écrire"></div>`;
  c+= `<div class="col"><img src="medias/modalites/mod_livre.png" alt="Outils pour lire" title="Outils pour lire"></div>`;
  c+= `<div class="col"><img src="medias/modalites/mod_pc.png" alt="Ordinateur ou tablette" title="Ordinateur ou tablette"></div>`;
  c+= `<div class="col"><img src="medias/modalites/mod_prof.png" alt="Aide de l'enseignant(e)" title="Aide de l'enseignant(e)"></div>`;
  c+= `<div class="col"><img src="medias/modalites/mod_eleve.png" alt="Aide d'un(e) élève" title="Aide d'un(e) élève"></div>`;
  c+= `</div>`;
  c+= `<div class="mod_travail">`;
  c+= `<img src="medias/modalites/modalite_0.png" alt="Observer et écouter">`;
  c+= `</div>`;
  c+= `<i class="mod_bt_changer_travail bi bi-arrow-right-circle" title="Changer de modalité de travail"></i>`;
  c+= `<i class="mod_bt_changer_couleur bi bi-palette" title="Changer de couleur"></i>`;
  c+= `</div>`;

  /* Ouvrir la box Modalités de travail */
  $('#box_bt_modalites_travail').on('click', function () {
    creerBox('box_id_'+Date.now(), 210, 260, ["box-move", "box-mod-w"], "Modalités", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_groupe')).hide();
    box_modalitesTravailCode();
  });
}
function box_modalitesTravailCode() {
  const modTabTra = ["Observer et écouter" , "Demander la parole" , "Tavailler seul(e)" , "Travailler à deux" , "Travailler en groupe"];
  const modTabCou = ["#FFF" , "#FFCECE" , "#C4FFC4" , "#D2D2FF" , "#FFFFC4" , "#FFC6FF"];
  let modTraEC = 0;
  let modCouEC = 0;

  /* Activer ou désactiver l'aide possible */
  $('.mod_aides img').on('click', function () {
    $(this).toggleClass("on");
  });

  /* Changer de modalité de travail */
  $('.mod_bt_changer_travail').on('click', function () {
    modTraEC = (modTraEC+1) % modTabTra.length;
    $(this).prev().find("img").attr({"src":"medias/modalites/modalite_"+modTraEC+".png" , "alt":modTabTra[modTraEC]});
  });

  /* Changer de couleur */
  $('.mod_bt_changer_couleur').on('click', function () {
    modCouEC = (modCouEC+1) % modTabCou.length;
    $(this).parent().css("background-color",modTabCou[modCouEC]);
  });
}

function modRetroactions() {
  let c = `<div id="retro_conteneur">`;
  c+= `<div id="retro_choix">`;
  c+= `<img data-choix="oui" src="medias/retroaction/retro_oui.png" alt="Bonne réponse" title="Bonne réponse">`;
  c+= `<img data-choix="non" src="medias/retroaction/retro_non.png" alt="Mauvaise réponse" title="Mauvaise réponse">`;
  c+= `<img data-choix="applaudissement" src="medias/retroaction/retro_applaudissement.png" alt="Applaudissements" title="Applaudissements">`;
  c+= `<img data-choix="gagne" src="medias/retroaction/retro_gagne.png" alt="Gagné !" title="Gagné !">`;
  c+= `<img data-choix="suivant" src="medias/retroaction/retro_suivant.png" alt="Au suivant !" title="Au suivant !">`;
  c+= `<img data-choix="fini" src="medias/retroaction/retro_fini.png" alt="Terminé !" title="Terminé !">`;
  c+= `</div>`;
  c+= `<div id="retro_param" class="d-flex justify-content-between mt-2">`;
  c+= `<div class="form-check form-switch">`;
  c+= `<input class="form-check-input" type="checkbox" role="switch" id="retro_animation" checked>`;
  c+= `<label class="form-check-label" for="retro_animation">Animation</label>`;
  c+= `</div>`;
  c+= `<div class="form-check form-switch">`;
  c+= `<input class="form-check-input" type="checkbox" role="switch" id="retro_bruitage" checked>`;
  c+= `<label class="form-check-label" for="retro_bruitage">Bruitage</label>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div>`;

  /* Ouvrir la box Rétroactions */
  $('#box_bt_retroactions').on('click', function () {
    creerBox('box_retroactions', 300, 135, ["box-move"], "Rétroactions", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_groupe')).hide();
    box_retroactionsCode();
  });
}
function box_retroactionsCode() {
  /* Jouer la rétroaction */
  $('#retro_choix img').on('click', function () {
    const choix = $(this).attr("data-choix");
    setTimeout(function(){$('#retro_choix img').removeClass("on"); }, 500);
    $('#retro_choix img').removeClass("on");
    $(this).addClass("on");
    if ($("#retro_bruitage").is(":checked")) {
      let sonNew = new Audio();
      sonNew.src = "medias/retroaction/retro_"+choix+".mp3";
      sonNew.play();
    }
    if ($("#retro_animation").is(":checked")) {
      const limage = "<img id='retro_limage' alt='"+choix+"' src='medias/retroaction/retro_"+choix+".png'>";
      $("#retro_body").show().addClass("on").append(limage);
      $("#box-container").hide();
      setTimeout(function () {
        $('#retro_limage').addClass('fade-out');
        // Attendre la fin de l'animation CSS (500ms)
        setTimeout(function () {
          $('#retro_limage').remove();
          $('#retro_body').removeClass("on");
        }, 500);
      }, 2000);
      setTimeout(function () {
        $("#box-container").show();
        $("#retro_body").hide();
      }, 2500);
    }
  });
}

function modFeux() {
  let c = `<div class="feux_conteneur">`;
  c+= `<div class="feux_feu">`;
  c+= `<div data-coul="rouge" class="feux_cercle feux_rouge"></div>`;
  c+= `<div data-coul="orange" class="feux_cercle feux_orange"></div>`;
  c+= `<div data-coul="vert" class="feux_cercle feux_vert"></div>`;
  c+= `<div data-coul="bleu" class="feux_cercle feux_bleu"></div>`;
  c+= `</div>`;
  c+= `<i class="feux_bt_changer_couleur bi bi-palette" title="Changer la couleur du fond"></i>`;
  c+= `</div>`;
  
  /* Ouvrir la box Feux multicolores */
  $('#box_bt_feux').on('click', function () {
    creerBox('box_id_'+Date.now(), 125, 310, ["box-move feux"], "Feux", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_groupe')).hide();
    box_feuxCode();
  });
}
function box_feuxCode() {
  const feuxTabCou = ["#FFF" , "#FFCECE" , "#C4FFC4" , "#D2D2FF" , "#FFFFC4" , "#FFC6FF"];
  let feuxCouEC = 0;

  /* Changer la coleur du feu */
  $('.feux_cercle').on('click', function () {
    if ($(this).hasClass("on")) $(this).removeClass("on");
    else {
      const dataCoul = $(this).attr("data-coul");
      $(this).siblings().removeClass("on");
      $(this).addClass("feux_"+dataCoul+" on");
    }
  });

  /* Changer la couleur du fond */
  $('.feux_bt_changer_couleur').on('click', function () {
    feuxCouEC = (feuxCouEC+1) % feuxTabCou.length;
    //$("#feux_conteneur").css("background-color",feuxTabCou[feuxCouEC]);
    $(this).parent().parent().css("background-color",feuxTabCou[feuxCouEC]);
  });
}

function modCompteurPoints() {
  let c = `<div id="cptp_conteneur"></div>`;

  /* Ouvrir la box Compteur de points */
  $('#box_bt_compteur_points').on('click', function () {
    creerBox('box_compteur_points', 350, 210, ["box-move", "box-resize"], "Compteur de points", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_groupe')).hide();
    box_compteurPointsCode();
  });
}
function box_compteurPointsCode() {
    let cptpNbEquipe = 2;
    const cptpHtmlBox =   `<div class="cptp_boite">
                            <div class="cptp_header" contenteditable>???</div>
                            <div class="cptp_points">0</div>
                            <div class="cptp_footer">
                            <button class="btn btn-outline-secondary btn-sm py-0 px-1 cptp_bt_supprimer_equipe" title="Supprimer cette équipe"><i class="bi bi-dash-circle"></i></button>
                            <button class="btn btn-warning btn-sm py-0 px-1 cptp_bt_supprimer_point" title="Supprimer 1 point" style="visibility:hidden;">-1</button>
                            <button class="btn btn-success btn-sm py-0 px-1 cptp_bt_ajouter_point" title="Ajouter 1 point">+1</button>
                            <button class="btn btn-outline-secondary btn-sm py-0 px-1 cptp_bt_ajouter_equipe" title="Ajouter une équipe"><i class="bi bi-plus-circle"></i></button>
                            </div></div>`;
  
  $("#cptp_conteneur").append(cptpHtmlBox);
  $("#cptp_conteneur").append(cptpHtmlBox);
  cptpVerifierNbEquipes();

  /* Ajouter une équipe */
  $("#cptp_conteneur").on("click", ".cptp_bt_ajouter_equipe", function () {
    if (cptpNbEquipe < 6) $(this).parent().parent().after(cptpHtmlBox);
    cptpNbEquipe++;
    cptpVerifierNbEquipes();
    document.querySelector('.cptp_header').addEventListener('keydown', function(e) {
      if (e.key === 'Enter') {
        e.preventDefault(); // empêche le retour à la ligne
      }
    });
  });

  /* Ajouter un point */
  $("#cptp_conteneur").on("click", ".cptp_bt_ajouter_point", function () {
    const nbPoint = parseInt($(this).parent().prev().text());
    const rang = $(this).parent().parent().index();
    $(".cptp_boite:eq("+rang+") .cptp_bt_supprimer_point").css("visibility","visible");
    $(this).parent().prev().text(nbPoint+1);
  });

  /* Supprimer un point */
  $("#cptp_conteneur").on("click", ".cptp_bt_supprimer_point", function () {
    const nbPoint = parseInt($(this).parent().prev().text());
    const rang = $(this).parent().parent().index();
    if (nbPoint <=1 ) $(".cptp_boite:eq("+rang+") .cptp_bt_supprimer_point").css("visibility","hidden");
    $(this).parent().prev().text(nbPoint-1);
  });

  /* Supprimer une équipe */
  $("#cptp_conteneur").on("click", ".cptp_bt_supprimer_equipe", function () {
    if (cptpNbEquipe > 1) $(this).parent().parent().remove();
    cptpNbEquipe--;
    cptpVerifierNbEquipes();
  });

  function cptpVerifierNbEquipes() {
    if (cptpNbEquipe <=1 ) $(".cptp_bt_supprimer_equipe").css("visibility","hidden");
    else  $(".cptp_bt_supprimer_equipe").css("visibility","visible");
    if (cptpNbEquipe >=6 ) $(".cptp_bt_ajouter_equipe").css("visibility","hidden");
    else $(".cptp_bt_ajouter_equipe").css("visibility","visible");
  }

}


/*
function modNombreHasard() {
  let c = ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;
  c+= ``;

  /* Ouvrir la box Nombre au hasard MODELE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  $('#box_bt_nombre_hasard').on('click', function () {
    creerBox('box_nombre_hasard', 350, 210, ["box-move", "box-resize"], "Nombre au hasard", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_groupe')).hide();
    box_nombre_hasardCode();
  });
}
function box_nombre_hasardCode() {
  // script....
}
*/
