/*****************************************/
/* Fonctions de Fonds                    */
/*****************************************/

/* Générer et gérer la modale des fonds */
function genererModaleFonds() {
  // Génération de la modale
  let c = "";
  c+= `<div class="modal fade premier_plan" id="outils_modal_act_fonds" tabindex="-1" aria-hidden="true">`;
  c+= `<div class="modal-dialog modal-lg">`;
  c+= `<div class="modal-content bg-info-subtle">`;
  c+= `<div class="modal-header bg-info d-flex align-items-start justify-content-between py-2 px-2">`;
  c+= `<h1 class="modal-title fs-4">Changer le fond d'écran</h1>`;
  c+= `<div>`;
  c+= `<button id="outils_bt_importer_fond_ecran" class="btn btn-secondary">Importer un fond d'écran</button>`;
  c+= `<input type="file" id="outils_input_importer_fond_ecran" accept="image/*" style="display:none">`;
  c+= `<button id="outils_bt_supprimer_fond_ecran" class="btn btn-danger ms-2" title="Supprimer le fond d'écran"><i class="bi bi-trash3-fill"></i></button>`;
  c+= `<button class="btn btn-warning ms-2" data-bs-dismiss="modal" title="Fermer"><i class="bi bi-x-lg"></i></button>`;
  c+= `</div>`;
  c+= `</div>`;// fin .modal-header
  c+= `<div class="modal-body">`;
  c+= `<ul class="nav nav-tabs" id="fonds_tabs" role="tablist">`;
  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link active" id="fonds_cahier_tab" data-bs-toggle="tab" data-bs-target="#fonds_cahier" type="button" role="tab" aria-controls="fonds_cahier" aria-selected="true">Cahier d'écolier</button>`;
  c+= `</li>`;
  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="fonds_quadrillage_tab" data-bs-toggle="tab" data-bs-target="#fonds_quadrillage" type="button" role="tab" aria-controls="fonds_quadrillage" aria-selected="false">Quadrilage</button>`;
  c+= `</li>`;
  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="fonds_autre_tab" data-bs-toggle="tab" data-bs-target="#fonds_autre" type="button" role="tab" aria-controls="fonds_autre" aria-selected="false">Autre</button>`;
  c+= `</li>`;
  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="fonds_couleur_tab" data-bs-toggle="tab" data-bs-target="#fonds_couleur" type="button" role="tab" aria-controls="fonds_couleur" aria-selected="false">Couleur</button>`;
  c+= `</li>`;
  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="fonds_langage_tab" data-bs-toggle="tab" data-bs-target="#fonds_langage" type="button" role="tab" aria-controls="fonds_langage" aria-selected="false">Langage</button>`;
  c+= `</li>`;
  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="fonds_oeuvres_tab" data-bs-toggle="tab" data-bs-target="#fonds_oeuvres" type="button" role="tab" aria-controls="fonds_oeuvres" aria-selected="false">Oeuvres</button>`;
  c+= `</li>`;
  c+= `</ul>`;
  c+= `<div class="tab-content tab_content" id="fonds_content">`;
  c+= `<div class="tab-pane active li_bouton_li" id="fonds_cahier" role="tabpanel" aria-labelledby="fonds_cahier_tab">`;
  //c+= `contenu onglet cahier`;
	c+= "<h4 class='premier'>Lignes Seyes rails (ligne unique)</h4>";
	c+= fondsGAenVF("apprentissage_1.png","50px 500px","","","repeat-x");
	c+= fondsGAenVF("apprentissage_1aide.png","50px 500px","","","repeat-x");
	c+= fondsGAenVF("apprentissage_2.png","42px 450px","","","repeat-x");
	c+= fondsGAenVF("apprentissage_2aide.png","42px 450px","","","repeat-x");
	c+= fondsGAenVF("apprentissage_3.png","35px 420px","","","repeat-x");
	c+= fondsGAenVF("apprentissage_3aide.png","35px 420px","","","repeat-x");
	c+= fondsGAenVF("apprentissage_4.png","25px 380px","","","repeat-x");
	c+= fondsGAenVF("apprentissage_4aide.png","25px 380px","","","repeat-x");
	c+= "<h4>Lignes Seyes rails (multilignes)</h4>";
	c+= fondsGAenVF("seyes_rail_1.png","12px 191px","","","repeat");
	c+= fondsGAenVF("seyes_rail_2.png","10px 159px","","","repeat");
	c+= fondsGAenVF("seyes_rail_3.png","8px 127px","","","repeat");
	c+= fondsGAenVF("seyes_rail_4.png","6px 96px","","","repeat");
	c+= "<h4>Lignes Seyes sans colonne</h4>";
	c+= fondsGAenVF("seyes_4lignes_108.png","108px","","","repeat");
	c+= fondsGAenVF("seyes_4lignes_96.png","96px","","","repeat");
	c+= fondsGAenVF("seyes_4lignes_84.png","84px","","","repeat");
	c+= fondsGAenVF("seyes_4lignes_72.png","72px","","","repeat");
	c+= fondsGAenVF("seyes_4lignes_56.png","56px","","","repeat");
	c+= fondsGAenVF("seyes_4lignes_48.png","48px","","","repeat");
	c+= fondsGAenVF("seyes_4lignes_40.png","40px","","","repeat");
	c+= fondsGAenVF("seyes_4lignes_27.png","27px","","","repeat");
	c+= "<h4>Lignes Seyes avec colonne</h4>";
	c+= fondsGAenVF("seyes_4lignes_108c.png","108px","","left","repeat");
	c+= fondsGAenVF("seyes_4lignes_96c.png","96px","","left","repeat");
	c+= fondsGAenVF("seyes_4lignes_84c.png","84px","","left","repeat");
	c+= fondsGAenVF("seyes_4lignes_72c.png","72px","","left","repeat");
	c+= fondsGAenVF("seyes_4lignes_56c.png","56px","","left","repeat");
	c+= fondsGAenVF("seyes_4lignes_48c.png","48px","","left","repeat");
	c+= fondsGAenVF("seyes_4lignes_40c.png","40px","","left","repeat");
	c+= fondsGAenVF("seyes_4lignes_27c.png","27px","","left","repeat");
	c+= "<h4>Lignes Seyes avec colonne et marge</h4>";
	c+= fondsGAenVF("seyes_4lignes_108cm.png","3000px 108px","","left","repeat-y");
	c+= fondsGAenVF("seyes_4lignes_96cm.png","3000px 96px","","left","repeat");
	c+= fondsGAenVF("seyes_4lignes_84cm.png","3000px 84px","","left","repeat");
	c+= fondsGAenVF("seyes_4lignes_72cm.png","3000px 72px","","left","repeat");
	c+= fondsGAenVF("seyes_4lignes_56cm.png","3000px 56px","","left","repeat");
	c+= fondsGAenVF("seyes_4lignes_48cm.png","3000px 48px","","left","repeat");
	c+= fondsGAenVF("seyes_4lignes_40cm.png","3000px 40px","","left","repeat");
	c+= fondsGAenVF("seyes_4lignes_27cm.png","3000px 27px","","left","repeat-y");
  c+= `</div>`;//fin fonds_cahier
  //c+= `contenu onglet quadrillage`;
  c+= `<div class="tab-pane fade li_bouton_li" id="fonds_quadrillage" role="tabpanel" aria-labelledby="fonds_quadrillage_tab">`;
	c+= "<h4 class='premier'>Quadrillage simple</h4>";
	c+= fondsGAenVF("carreau_152.png","152px","","","repeat");
	c+= fondsGAenVF("carreau_121.png","121px","","","repeat");
	c+= fondsGAenVF("carreau_102.png","102px","","","repeat");
	c+= fondsGAenVF("carreau_76.png","76px","","","repeat");
	c+= fondsGAenVF("carreau_56.png","56px","","","repeat");
	c+= fondsGAenVF("carreau_45.png","45px","","","repeat");
	c+= fondsGAenVF("carreau_35.png","35px","","","repeat");
	c+= fondsGAenVF("carreau_30.png","30px","","","repeat");
	c+= "<h4>Quadrillage (papier millimétré)</h4>";
	c+= fondsGAenVF("millimetre_152.png","152px","","","repeat");
	c+= fondsGAenVF("millimetre_121.png","121px","","","repeat");
	c+= fondsGAenVF("millimetre_102.png","102px","","","repeat");
	c+= fondsGAenVF("millimetre_76.png","76px","","","repeat");
	c+= fondsGAenVF("millimetre_56.png","56px","","","repeat");
	c+= fondsGAenVF("millimetre_45.png","45px","","","repeat");
	c+= fondsGAenVF("millimetre_35.png","35px","","","repeat");
	c+= fondsGAenVF("millimetre_30.png","30px","","","repeat");
	c+= "<h4>Quadrillage en points</h4>";
	c+= fondsGAenVF("point_152.png","152px","","","repeat");
	c+= fondsGAenVF("point_121.png","121px","","","repeat");
	c+= fondsGAenVF("point_102.png","102px","","","repeat");
	c+= fondsGAenVF("point_76.png","76px","","","repeat");
	c+= fondsGAenVF("point_56.png","56px","","","repeat");
	c+= fondsGAenVF("point_45.png","45px","","","repeat");
	c+= fondsGAenVF("point_35.png","35px","","","repeat");
	c+= fondsGAenVF("point_30.png","30px","","","repeat");
  c+= `</div>`;// fin fonds_quadrillage
  c+= `<div class="tab-pane fade li_bouton_li" id="fonds_autre" role="tabpanel" aria-labelledby="fonds_autre_tab">`;
  //c+= `contenu onglet autre`;
	c+= "<h4 class='premier'>Colonnes</h4>";
	c+= fondsGAenVF("colonne_50.png","50px 2px","","left","repeat");
	c+= fondsGAenVF("colonne_100.png","100px 2px","","left","repeat");
	c+= fondsGAenVF("colonne_150.png","150px 2px","","left","repeat");
	c+= fondsGAenVF("colonne_200.png","200px 2px","","left","repeat");
	c+= fondsGAenVF("colonne_250.png","250px 2px","","left","repeat");
	c+= fondsGAenVF("colonne_300.png","300px 2px","","left","repeat");
	c+= fondsGAenVF("colonne_350.png","350px 2px","","left","repeat");
	c+= fondsGAenVF("colonne_400.png","400px 2px","","left","repeat");
	c+= "<h4>Lignes</h4>";
	c+= fondsGAenVF("ligne_50.png","2px 50px","","top","repeat");
	c+= fondsGAenVF("ligne_100.png","2px 100px","","top","repeat");
	c+= fondsGAenVF("ligne_150.png","2px 150px","","top","repeat");
	c+= fondsGAenVF("ligne_200.png","2px 200px","","top","repeat");
	c+= fondsGAenVF("ligne_250.png","2px 250px","","top","repeat");
	c+= fondsGAenVF("ligne_300.png","2px 300px","","top","repeat");
	c+= fondsGAenVF("ligne_350.png","2px 350px","","top","repeat");
	c+= fondsGAenVF("ligne_400.png","2px 400px","","top","repeat");
	c+= "<h4>Partition de musique</h4>";
	c+= fondsGAenVF("musique_228.png","10px 228px","","","repeat");
	c+= fondsGAenVF("musique_114.png","10px 114px","","","repeat");
  c+= `</div>`;// fin fonds_autre
  c+= `<div class="tab-pane fade li_bouton_li" id="fonds_couleur" role="tabpanel" aria-labelledby="fonds_couleur_tab">`;
  //c+= `contenu onglet couleur`;
	c+= "<h4 class='premier'>Gamme 1</h4>";
  c+= fondsGAenVF("fond_a0.png","90px","","","repeat");
  c+= fondsGAenVF("fond_a1.png","90px","","","repeat");
  c+= fondsGAenVF("fond_a2.png","90px","","","repeat");
  c+= fondsGAenVF("fond_a3.png","90px","","","repeat");
  c+= fondsGAenVF("fond_a4.png","90px","","","repeat");
  c+= fondsGAenVF("fond_a5.png","90px","","","repeat");
	c+= "<h4>Gamme 2</h4>";
  c+= fondsGAenVF("fond_b1.png","90px","","","repeat");
  c+= fondsGAenVF("fond_b2.png","90px","","","repeat");
  c+= fondsGAenVF("fond_b3.png","90px","","","repeat");
  c+= fondsGAenVF("fond_b4.png","90px","","","repeat");
  c+= fondsGAenVF("fond_b5.png","90px","","","repeat");
	c+= "<h4>Gamme 3</h4>";
  c+= fondsGAenVF("fond_c1.png","90px","","","repeat");
  c+= fondsGAenVF("fond_c2.png","90px","","","repeat");
  c+= fondsGAenVF("fond_c3.png","90px","","","repeat");
  c+= fondsGAenVF("fond_c4.png","90px","","","repeat");
  c+= fondsGAenVF("fond_c5.png","90px","","","repeat");
	c+= "<h4>Gamme 4</h4>";
  c+= fondsGAenVF("fond_d1.png","90px","","","repeat");
  c+= fondsGAenVF("fond_d2.png","90px","","","repeat");
  c+= fondsGAenVF("fond_d3.png","90px","","","repeat");
  c+= fondsGAenVF("fond_d4.png","90px","","","repeat");
  c+= fondsGAenVF("fond_d5.png","90px","","","repeat");
	c+= "<h4>Gamme 5</h4>";
  c+= fondsGAenVF("fond_e1.png","90px","","","repeat");
  c+= fondsGAenVF("fond_e2.png","90px","","","repeat");
  c+= fondsGAenVF("fond_e3.png","90px","","","repeat");
  c+= fondsGAenVF("fond_e4.png","90px","","","repeat");
  c+= fondsGAenVF("fond_e5.png","90px","","","repeat");
	c+= "<h4>Gamme 6</h4>";
  c+= fondsGAenVF("fond_f1.png","90px","","","repeat");
  c+= fondsGAenVF("fond_f2.png","90px","","","repeat");
  c+= fondsGAenVF("fond_f3.png","90px","","","repeat");
  c+= fondsGAenVF("fond_f4.png","90px","","","repeat");
  c+= fondsGAenVF("fond_f5.png","90px","","","repeat");
  c+= fondsGAenVF("fond_f6.png","90px","","","repeat");
  c+= fondsGAenVF("fond_f7.png","90px","","","repeat");
  c+= fondsGAenVF("fond_f8.png","90px","","","repeat");
  c+= `</div>`;// fin fonds_couleur

  c+= `<div class="tab-pane fade" id="fonds_langage" role="tabpanel" aria-labelledby="fonds_langage_tab">`;
  c+= `<p>Ces images sont produites et diffusées sur le site <a href="https://ulisauquotidien.eklablog.com/les-images-comme-supports-de-travail-a212451985" target="_blank"><b>Ulis au quotidien</b></a>, accompagnées de supports de langage, de production d'écrits et de lecture compréhension.</p>`;
  c+= retournerVigLangage();
  c+= `</div>`;// fin fonds_langage

  c+= `<div class="tab-pane fade" id="fonds_oeuvres" role="tabpanel" aria-labelledby="fonds_oeuvres_tab">`;
  c+= `<p>Ces oeuvres du domaine public ont été téléchargées sur le site <a target="_blank" href="https://www.artic.edu/">Art Institute of Chicago</a>.</p>`;
  c+= retournerVigOeuvres();
  c+= `</div>`;// fin fonds_oeuvres

  c+= ``;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div></div></div>`;
  // Ajouter la modale dans le body
  $("body").append(c);

  // Récupérer src à partir de nom
  function getSrcByNom(nom) {
    const image = imagesFond.find(img => img.nom === nom);
    return image ? image.src : null; // ou undefined selon ton besoin
  }

  // Générer les vignettes des images de fond
  function fondsGAenVF(bgI,bgS,bgA,bgP,bgR) {
    return "<li><img data-bgi='"+bgI+"' data-bgs='"+bgS+"' data-bga='"+bgA+"' data-bgp='"+bgP+"' data-bgr='"+bgR+"' src='medias/outils_vignettes_fonds/"+bgI+"' /></li>";
  }

  // Déclencher l'événement pour afficher le fond d'écran sélectionné
  $('#fonds_content li img').click(function () {
		var backgroundImage = $(this).attr("data-bgi");
    //backgroundImage = getSrcByNom(backgroundImage);
		var backgroundSize = $(this).attr("data-bgs");
		var backgroundAttachment = $(this).attr("data-bga");
		var backgroundPosition = $(this).attr("data-bgp");
		var backgroundRepeat = $(this).attr("data-bgr");
    let url = "url(assets/css/outils_fonds/"+backgroundImage+")";
    //let url = "url("+backgroundImage+")";
		$("#outils_ecran_activites").css({"background-image":url, "background-size":backgroundSize, "background-attachment":backgroundAttachment, "background-position":backgroundPosition, "background-repeat":backgroundRepeat});
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_fonds')).hide();
  });

  // Afficher le fond d'écran langage et oeuvres
  $('.bloc_vig_fond > img').click(function () {
    const img = $(this).attr("data-img");
    const theme = $(this).attr("data-theme")
    const url = "medias/"+theme+"/"+img+".jpg";
    $("#outils_ecran_activites").css("background","url("+url+") center / contain no-repeat");
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_fonds')).hide();
  });

  // Importer un fond d'écran => bouton
  $('#outils_bt_importer_fond_ecran').click(() => {
    $('#outils_input_importer_fond_ecran').click();
  });

  // Importer un fond d'écran => input file
  document.getElementById('outils_input_importer_fond_ecran').addEventListener('change', function (e) {
    const fichier = e.target.files[0];
    //const apercu = document.getElementById('apercu');
    //apercu.innerHTML = ''; // Réinitialiser l'aperçu

    if (!fichier || !fichier.type.startsWith('image/')) return;

    const reader = new FileReader();
    reader.onload = function (event) {
      const img = new Image();
      img.onload = function () {
        const maxSize = 800;
        let width = img.width;
        let height = img.height;

        if (width > height) {
          if (width > maxSize) {
            height *= maxSize / width;
            width = maxSize;
          }
        } else {
          if (height > maxSize) {
            width *= maxSize / height;
            height = maxSize;
          }
        }

        const canvas = document.createElement('canvas');
        canvas.width = width;
        canvas.height = height;
        const ctx = canvas.getContext('2d');
        ctx.drawImage(img, 0, 0, width, height);

        const miniature = new Image();
        miniature.src = canvas.toDataURL();
        //apercu.appendChild(miniature);
        $("#outils_ecran_activites").css("background","url('"+miniature.src+"') center / cover no-repeat");
        bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_fonds')).hide();
      };
      img.src = event.target.result;
    };
    reader.readAsDataURL(fichier);
  });

  // Supprimer le fond d'écran
  $('#outils_bt_supprimer_fond_ecran').click(() => {
    $("#outils_ecran_activites").css("background","");
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_fonds')).hide();
  });

  /* Générer les vignettes des fonds langage */
  function retournerVigLangage() {
    let ctn = "";
    for (let i=0 ; i < tabLangage.length ; i++) {
      ctn += `<div class="bloc_vig_fond"><figure>`+tabLangage[i][1]+`</figure><img data-theme="langage" data-img="`+tabLangage[i][0]+`" src="medias/langage/vig/`+tabLangage[i][0]+`.jpg" alt="`+tabLangage[i][1]+`"></div>`;
    }
    return ctn;
  }

  /* Générer les vignettes des fonds oeuvres */
  function retournerVigOeuvres() {
    let ctn = "";
    for (let i=0 ; i < tabOeuvres.length ; i++) {
      ctn += `<div class="bloc_vig_fond"><figure><a target="_blank" href="`+tabOeuvres[i][3]+`">`+tabOeuvres[i][1]+`</a></figure><img  data-theme="oeuvres" data-img="`+tabOeuvres[i][0]+`" src="medias/oeuvres/vig/`+tabOeuvres[i][0]+`.jpg" alt="`+tabOeuvres[i][2]+`" title="`+tabOeuvres[i][2]+`"></div>`;
    }
    return ctn;
  }

}// FIN genererModaleFonds()


let tabLangage = [];
tabLangage[0] = ["a-la-boulangerie","À la boulangerie"];
tabLangage[1] = ["a-la-plage","À la plage"];
tabLangage[2] = ["a-travers-champ","À travers champ"];
tabLangage[3] = ["au-calme","Au calme"];
tabLangage[4] = ["au-camping","Au camping"];
tabLangage[5] = ["au-cinema","Au cinéma"];
tabLangage[6] = ["au-magasin","Au magasin"];
tabLangage[7] = ["au-parc","Au parc"];
tabLangage[8] = ["chambre-d-ado","Chambre d’ado"];
tabLangage[9] = ["chez-le-medecin","Chez le médecin"];
tabLangage[10] = ["dans-la-chambre","Dans la chambre"];
tabLangage[11] = ["dans-la-cuisine","Dans la cuisine"];
tabLangage[12] = ["dans-la-salle-de-bain","Dans la salle de bain"];
tabLangage[13] = ["dans-le-jardin","Dans le jardin"];
tabLangage[14] = ["dans-le-salon","Dans le salon"];
tabLangage[15] = ["en-foret","En forêt"];
tabLangage[16] = ["halloween","Halloween"];
tabLangage[17] = ["jardinage","Jardinage"];
tabLangage[18] = ["jeux-en-exterieur","Jeux en extérieur"];
tabLangage[19] = ["la-classe","La classe"];
tabLangage[20] = ["la-fete-foraine","La fête foraine"];
tabLangage[21] = ["l-anniversaire","L’anniversaire"];
tabLangage[22] = ["la-panne","La panne"];
tabLangage[23] = ["la-peche","La pêche"];
tabLangage[24] = ["le-barbecue","Le barbecue"];
tabLangage[25] = ["le-bureau-de-vote","Le bureau de vote"];
tabLangage[26] = ["le-desordre","Le désordre"];
tabLangage[27] = ["le-marche","Le marché"];
tabLangage[28] = ["le-musee","Le musée"];
tabLangage[29] = ["les-crepes","Les crêpes"];
tabLangage[30] = ["les-jeux-videos","Les jeux vidéos"];
tabLangage[31] = ["l-espace","L’espace"];
tabLangage[32] = ["les-premiers-pas","Les premiers pas"];
tabLangage[33] = ["le-zoo","Le zoo"];
tabLangage[34] = ["l-heure-du-coucher","L’heure du coucher"];
tabLangage[35] = ["l-hiver","L’hiver"];
tabLangage[36] = ["nuit-noel","La nuit de Noël"];
tabLangage[37] = ["reveillon","Le réveillon"];
tabLangage[38] = ["st-valentin","La Saint-Valentin"];
tabLangage[39] = ["sur-la-cour","Sur la cour"];

let tabOeuvres = [];
tabOeuvres[0] = ["battle","After Cornelis Cort","The Battle of Zama","https://www.artic.edu/artworks/111618/the-battle-of-zama"];
tabOeuvres[1] = ["marly","Alfred Sisley","The Seine at Port-Marly, Piles of Sand","https://www.artic.edu/artworks/16633/the-seine-at-port-marly-piles-of-sand"];
tabOeuvres[2] = ["bank","Claude Monet","On the Bank of the Seine, Bennecourt","https://www.artic.edu/artworks/81539/on-the-bank-of-the-seine-bennecourt"];
tabOeuvres[3] = ["beach","Claude Monet","The Beach at Sainte-Adresse","https://www.artic.edu/artworks/14598/the-beach-at-sainte-adresse"];
tabOeuvres[4] = ["cafe","Fernand Lungren","In the Café","https://www.artic.edu/artworks/59908/in-the-cafe"];
tabOeuvres[5] = ["garden","Francesco Guardi","The Garden of Palazzo Contarini dal Zaffo","https://www.artic.edu/artworks/111610/the-garden-of-palazzo-contarini-dal-zaffo"];
tabOeuvres[6] = ["guard","Frederic Remington","The Advance-Guard, or The Military Sacrifice","https://www.artic.edu/artworks/97910/the-advance-guard-or-the-military-sacrifice-the-ambush"];
tabOeuvres[7] = ["flower-girl","George Hitchcock","Flower Girl in Holland","https://www.artic.edu/artworks/138/flower-girl-in-holland"];
tabOeuvres[8] = ["armida","Giovanni Battista Tiepolo","Armida Abandoned by Rinaldo","https://www.artic.edu/artworks/16492/armida-abandoned-by-rinaldo"];
tabOeuvres[9] = ["meeting","Giuseppe Cades","The Meeting of Gautier, Count of Antwerp, and his Daughter, Violante","https://www.artic.edu/artworks/19200/the-meeting-of-gautier-count-of-antwerp-and-his-daughter-violante"];
tabOeuvres[10] = ["street","Gustave Caillebotte ","Paris Street; Rainy Day","https://www.artic.edu/artworks/20684/paris-street-rainy-day"];
tabOeuvres[11] = ["emperor","Guy-Louis Vernansal","The Emperor Sailing, from The Story of the Emperor of China","https://www.artic.edu/artworks/189775/the-emperor-sailing-from-the-story-of-the-emperor-of-china"];
tabOeuvres[12] = ["woman","Henri Matisse","Woman before an Aquarium","https://www.artic.edu/artworks/27984/woman-before-an-aquarium"];
tabOeuvres[13] = ["monte","Jean-Baptiste-Camille Corot","Monte Pincio, Rome","https://www.artic.edu/artworks/45267/monte-pincio-rome"];
tabOeuvres[14] = ["plates","Katsushika Hokusai","The Mansion of the Plates","https://www.artic.edu/artworks/47407/the-mansion-of-the-plates-sara-yashiki-from-the-series-one-hundred-ghost-tales-hyaku-monogatari"];
tabOeuvres[15] = ["movement","Marsden Hartley","Movement","https://www.artic.edu/artworks/65916/movement"];
tabOeuvres[16] = ["light","Martin Johnson Heade","Magnolias on Light Blue Velvet Cloth","https://www.artic.edu/artworks/100829/magnolias-on-light-blue-velvet-cloth"];
tabOeuvres[17] = ["tennessee","Narcissa Niblack Thorne","Tennessee Entrance Hall, 1835","https://www.artic.edu/artworks/45401/a31-tennessee-entrance-hall-1835"];
tabOeuvres[18] = ["basket","Paul Cezanne","The Basket of Apples","https://www.artic.edu/artworks/111436/the-basket-of-apples"];
tabOeuvres[19] = ["amsterdam","Piet Mondrian","Amsterdam Skyline Viewed from the West","https://www.artic.edu/artworks/186314/amsterdam-skyline-viewed-from-the-west"];
tabOeuvres[20] = ["farm","Piet Mondrian","Farm near Duivendrecht","https://www.artic.edu/artworks/144467/farm-near-duivendrecht"];
tabOeuvres[21] = ["lozenge","Piet Mondrian","Lozenge Composition with Yellow, Black, Blue, Red, and Gray","https://www.artic.edu/artworks/109819/lozenge-composition-with-yellow-black-blue-red-and-gray"];
tabOeuvres[22] = ["stream","Totoya Hokkei","A Mountainous Landscape with a Stream ","https://www.artic.edu/artworks/23773/a-mountainous-landscape-with-a-stream"];
tabOeuvres[23] = ["hamamatsu","Utagawa Hiroshige","Hamamatsu, from the series Fifty-three Stations of the Tokaido","https://www.artic.edu/artworks/4371/hamamatsu-from-the-series-fifty-three-stations-of-the-tokaido-tokaido-gojusan-tsugi-also-known-as-the-tokaido-with-poem-kyoka-iri-tokaido"];
tabOeuvres[24] = ["crossing","Utagawa Hiroshige","Mitsuke: Ferries Crossing the Tenryu River","https://www.artic.edu/artworks/4368/mitsuke-ferries-crossing-the-tenryu-river-mitsuke-tenryugawa-funawatashi-from-the-series-fifty-three-stations-of-the-tokaido-tokaido-gojusan-tsugi-also-known-as-the-tokaido-with-poem-kyoka-iri-tokaido"];
tabOeuvres[25] = ["shinagawa","Utagawa Hiroshige","Shinagawa, from the series “Fifty-three Stations of the Tokaido","https://www.artic.edu/artworks/4280/shinagawa-from-the-series-fifty-three-stations-of-the-tokaido-tokaido-gojusan-tsugi-also-known-as-the-tokaido-with-poem-kyoka-iri-tokaido"];
tabOeuvres[26] = ["pine","Utagawa Hiroshige","The Beautiful Pine Trees at Mount Hiramatsu","https://www.artic.edu/artworks/18347/minakuchi-the-beautiful-pine-trees-at-mount-hiramatsu-minakuchi-hiramatsuyama-bisho-no-51-from-the-series-fifty-three-stations-of-the-tokaido-tokaido-gojusan-tsugi-also-known-as-the-reisho-tokaido"];
tabOeuvres[27] = ["mouth","Utagawa Hiroshige","The Mouth of the Aji River in Settsu Province","https://www.artic.edu/artworks/29517/the-mouth-of-the-aji-river-in-settsu-province-settsu-ajikawaguchi-from-the-series-wrestling-matches-between-mountains-and-seas-sankai-mitate-zumo"];
tabOeuvres[28] = ["cannons","Vasily Kandinsky","Improvisation No. 30 (Cannons)","https://www.artic.edu/artworks/8991/improvisation-no-30-cannons"];
tabOeuvres[29] = ["poplars","Vasily Kandinsky","Landscape with Two Poplars","https://www.artic.edu/artworks/8980/landscape-with-two-poplars"];
tabOeuvres[30] = ["green","Vasily Kandinsky","Painting with Green Center","https://www.artic.edu/artworks/8987/painting-with-green-center"];
tabOeuvres[31] = ["troika","Vasily Kandinsky","Painting with Troika","https://www.artic.edu/artworks/8983/painting-with-troika"];
tabOeuvres[32] = ["spring","Vincent van Gogh","Fishing in Spring, the Pont de Clichy (Asnières) ","https://www.artic.edu/artworks/109314/fishing-in-spring-the-pont-de-clichy-asnieres"];
tabOeuvres[33] = ["terrace","Vincent van Gogh","Terrace and Observation Deck at the Moulin de Blute-Fin, Montmartre","https://www.artic.edu/artworks/27954/terrace-and-observation-deck-at-the-moulin-de-blute-fin-montmartre"];
tabOeuvres[34] = ["bedroom","Vincent van Gogh","The Bedroom","https://www.artic.edu/artworks/28560/the-bedroom"];
tabOeuvres[35] = ["drinkers","Vincent van Gogh","The Drinkers","https://www.artic.edu/artworks/79349/the-drinkers"];
tabOeuvres[36] = ["nones","William A. Mitchell","Rack Picture for Dr. Nones","https://www.artic.edu/artworks/154496/rack-picture-for-dr-nones"];
tabOeuvres[37] = ["labrador","William Bradford","The Coast of Labrador","https://www.artic.edu/artworks/100489/the-coast-of-labrador"];
tabOeuvres[38] = ["park","William Merritt Chase","A City Park","https://www.artic.edu/artworks/28849/a-city-park"];
tabOeuvres[39] = ["scarborough","Winslow Homer","Fishing off Scarborough","https://www.artic.edu/artworks/16788/fishing-off-scarborough"];

