/*****************************************/
/* Fonctions de Déplacement              */
/*****************************************/

/* Générer et gérer la modale de deplacement */
function genererModaleDeplacement() {
  // Génération de la modale
  let c = "";
  c+= `<div class="modal fade premier_plan" id="outils_modal_act_deplacement" tabindex="-1" aria-hidden="true">`;
  c+= `<div class="modal-dialog modal-lg">`;
  c+= `<div class="modal-content bg-info-subtle">`;
  c+= `<div class="modal-header bg-info d-flex align-items-start justify-content-between py-2 px-2">`;
  c+= `<h1 class="modal-title fs-4">Déplacer des objets</h1>`;
  c+= `<div class="d-flex align-items-center">`;
  c+= `<button class="btn btn-warning ms-2" data-bs-dismiss="modal" title="Fermer"><i class="bi bi-x-lg"></i></button>`;
  c+= `</div>`;
  c+= `</div>`;// fin .modal-header
  c+= `<div class="modal-body">`;

  c+= `<ul class="nav nav-tabs" id="deplacement_tabs" role="tablist">`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link active" id="deplacement_etiquette_tab" data-bs-toggle="tab" data-bs-target="#deplacement_etiquette" type="button" role="tab" aria-controls="deplacement_etiquette" aria-selected="true">Étiquette</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="deplacement_image_tab" data-bs-toggle="tab" data-bs-target="#deplacement_image" type="button" role="tab" aria-controls="deplacement_image" aria-selected="true">Image</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="deplacement_picto_tab" data-bs-toggle="tab" data-bs-target="#deplacement_picto" type="button" role="tab" aria-controls="deplacement_picto" aria-selected="true">Picto</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="deplacement_masque_tab" data-bs-toggle="tab" data-bs-target="#deplacement_masque" type="button" role="tab" aria-controls="deplacement_masque" aria-selected="true">Masque</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="deplacement_postit_tab" data-bs-toggle="tab" data-bs-target="#deplacement_postit" type="button" role="tab" aria-controls="deplacement_postit" aria-selected="true">Post-it</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="deplacement_parcours_tab" data-bs-toggle="tab" data-bs-target="#deplacement_parcours" type="button" role="tab" aria-controls="deplacement_parcours" aria-selected="true">Parcours</button>`;
  c+= `</li>`;

  c+= `<li class="nav-item" role="presentation">`;
  c+= `<button class="nav-link" id="deplacement_plateau_tab" data-bs-toggle="tab" data-bs-target="#deplacement_plateau" type="button" role="tab" aria-controls="deplacement_plateau" aria-selected="true">Plateau de jeu</button>`;
  c+= `</li>`;

  c+= `</ul>`;// fin #deplacement_tabs

  c+= `<div class="tab-content tab_content" id="deplacement_content">`;

  c+= `<div class="tab-pane active" id="deplacement_etiquette" role="tabpanel" aria-labelledby="deplacement_etiquette_tab">`;
  //c+= `contenu onglet Étiquette`;
	c+= "<h4 class='premier'>Déplacer des étiquettes <button class='btn btn-outline-primary btn-sm etiquette_taille' data-t='t_p' title='petite taille de police'>P</button> <button class='btn btn-primary etiquette_taille' data-t='t_m' title='moyenne taille de police'>M</button> <button class='btn btn-outline-primary btn-lg etiquette_taille' data-t='t_g' title='grande taille de police'>G</button></h4>";
  c+= `<h5>Saisir le texte de l'étiquette et cliquer sur une couleur.</h5>`;
  c+= `<p>Chaque couleur cliquée insère une étiquette <em>(à déplacer)</em> dans l'angle supérieur gauche.</p>`;
  c+= `<div class="row">`;
  c+= `<div class="col-4"><input id="etiquette_saisie" type="text" class="form-control" placeholder="Texte de l'étiquette"></div>`;
  c+= `<div class="col-8 d-flex align-items-center">`;
  c+= `<div class="coul_etiq c_red mx-1 effet_bt_zoom" data-coul="c_red" title="fond rouge"></div>`;
  c+= `<div class="coul_etiq c_deepPink mx-1 effet_bt_zoom" data-coul="c_deepPink" title="fond rose"></div>`;
  c+= `<div class="coul_etiq c_orange mx-1 effet_bt_zoom" data-coul="c_orange" title="fond orange"></div>`;
  c+= `<div class="coul_etiq c_yellow mx-1 effet_bt_zoom" data-coul="c_yellow" title="fond jaune"></div>`;
  c+= `<div class="coul_etiq c_purple mx-1 effet_bt_zoom" data-coul="c_purple" title="fond violet"></div>`;
  c+= `<div class="coul_etiq c_green mx-1 effet_bt_zoom" data-coul="c_green" title="fond vert"></div>`;
  c+= `<div class="coul_etiq c_blue mx-1 effet_bt_zoom" data-coul="c_blue" title="fond bleu"></div>`;
  c+= `<div class="coul_etiq c_brown mx-1 effet_bt_zoom" data-coul="c_brown" title="fond maron"></div>`;
  c+= `<div class="coul_etiq c_white mx-1 effet_bt_zoom" data-coul="c_white" title="fond blanc"></div>`;
  c+= `<div class="coul_etiq c_gray mx-1 effet_bt_zoom" data-coul="c_gray" title="fond gris"></div>`;
  c+= `<div class="coul_etiq c_black mx-1 effet_bt_zoom" data-coul="c_black" title="fond noir"></div>`;
  c+= `<div class="coul_etiq c_transparent mx-1 effet_bt_zoom" data-coul="c_transparent" title="fond transparent"></div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div class="text-center mt-3">`;
  c+= `<p>Le texte de l'étiquette pourra être modifié en cliquant sur <i class="bi bi-pencil-square"></i>.<br><b>Faire un double-clic</b> sur une étiquette pour la supprimer.</p>`;
  c+= `<button id="etiquette_bt_supprimer_toutes" class="btn btn-warning btn-sm">Supprimer toutes les étiquettes</button>`;
  c+= `</div>`;
  c+= `</div>`;//fin #deplacement_etiquette

  c+= `<div class="tab-pane fade" id="deplacement_image" role="tabpanel" aria-labelledby="deplacement_image_tab">`;
  //c+= `contenu onglet Image`;
	c+= `<h4 class='premier'>Déplacer ses images personnelles <div style="font-size:16px; color:black;" class="ms-2 form-check form-switch form-check-inline"><input class="form-check-input" type="checkbox" role="switch" id="image_switch_transparent"><label class="form-check-label" for="image_switch_transparent">Fond transparent</label></div></h4>`;

  c+= `<div class="zone-images" data-image-selector data-max-size="300">`;
  c+= `<h5>Déposer ou sélectionner des images</h5>`;
  c+= `<div class="inputs">`;
  c+= `<input type="file" multiple accept="image/*" class="input-fichiers">`;
  c+= `<input type="file" multiple accept="image/*" webkitdirectory class="input-dossier">`;
  c+= `</div>`;
  c+= `<button class="btn-fichiers btn btn-secondary btn-sm mx-1">Choisir des images</button>`;
  c+= `<button class="btn-dossier btn btn-secondary btn-sm mx-1">Choisir un dossier d'images</button>`;
  c+= `<button class="btn-supprimer-tout btn btn-secondary btn-sm mx-1" type="button">Tout supprimer</button>`;
  c+= `<div id="depl_images_apercu" class="apercu"></div>`;
  c+= `</div>`;
  c+= `<div class="text-center">`;
  c+= `<h5>Cliquer sur une image l'insère dans l'angle supérieur gauche.</h5>`;
  c+= `<p>L'image pourra être dupliquée en cliquant sur <i class="bi bi-copy"></i>.<br><b>Faire un double-clic</b> sur une image insérée pour la supprimer.</p>`;
  c+= `<button id="depl_image_bt_supprimer_toutes" class="btn btn-warning btn-sm " type="button">Supprimer toutes les images insérées</button>`;
  c+= `</div>`;

  c+= `</div>`;//fin #deplacement_image

  c+= `<div class="tab-pane fade" id="deplacement_picto" role="tabpanel" aria-labelledby="deplacement_picto_tab">`;
  //c+= `contenu onglet Picto`;
	c+= `<h4 class='premier'>Déplacer des pictogrammes <div style="font-size:16px; color:black;" class="ms-2 form-check form-switch form-check-inline"><input class="form-check-input" type="checkbox" role="switch" id="picto_switch_transparent"><label class="form-check-label" for="picto_switch_transparent">Fond transparent</label></div></h4>`;
  c+= `<p><b>Faire un double-clic</b> sur un picto pour le supprimer. <button id='picto_bt_supprimer_tous_pictos' class='btn btn-warning btn-sm'>Supprimer tous les pictos insérés</button></p>`;

  c+= `<div id="picto_bts">`;
  c+= `<button class="btn btn-secondary btn-sm m-1" data-p="action">Actions</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="alimentation">Alimentation</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="animaux">Animaux</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="chiffre">Chiffres</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="cuisine">Cuisine</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="de">Dés</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="forme">Formes</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="jeton">Jetons</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="lettre">Lettres</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="lieu">Lieux</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="meteo">Météo</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="monnaie">Monnaie</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="musique">Musique</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="pion">Pions</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="smiley">Smiley</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="transport">Transport</button>`;
  c+= `<button class="btn btn-outline-secondary btn-sm m-1" data-p="vetement">Vêtements</button>`;
  c+= `</div>`;// fin #picto_bts
  c+= `<div id="picto_content">`;
  c+= `<div id="picto_action">`+genererPicto(1, 237, "action")+`</div>`;
  c+= `<div id="picto_alimentation" style="display:none">`+genererPicto(1, 23, "alimentation")+`</div>`;
  c+= `<div id="picto_animaux" style="display:none">`+genererPicto(1, 96, "animaux")+`</div>`;
  c+= `<div id="picto_chiffre" style="display:none">`+genererPicto(0, 9, "chiffre")+`</div>`;
  c+= `<div id="picto_cuisine" style="display:none">`+genererPicto(1, 38, "cuisine")+`</div>`;
  c+= `<div id="picto_de" style="display:none">`+genererPicto(1, 6, "de")+`</div>`;
  c+= `<div id="picto_forme" style="display:none">`+genererPicto(1, 48, "forme")+`</div>`;
  c+= `<div id="picto_jeton" style="display:none">`+genererPicto(1, 18, "jeton")+`</div>`;
  c+= `<div id="picto_lettre" style="display:none">`+genererPicto(1, 26, "lettre")+`</div>`;
  c+= `<div id="picto_lieu" style="display:none">`+genererPicto(1, 40, "lieu")+`</div>`;
  c+= `<div id="picto_meteo" style="display:none">`+genererPicto(1, 23, "meteo")+`</div>`;
  c+= `<div id="picto_monnaie" style="display:none">`+genererPicto(1, 17, "monnaie")+`</div>`;
  c+= `<div id="picto_musique" style="display:none">`+genererPicto(1, 51, "musique")+`</div>`;
  c+= `<div id="picto_pion" style="display:none">`+genererPicto(1, 5, "pion")+`</div>`;
  c+= `<div id="picto_smiley" style="display:none">`+genererPicto(1, 60, "smiley")+`</div>`;
  c+= `<div id="picto_transport" style="display:none">`+genererPicto(1, 30, "transport")+`</div>`;
  c+= `<div id="picto_vetement" style="display:none">`+genererPicto(1, 32, "vetement")+`</div>`;
  c+= `</div>`;// fin #picto_content
  c+= `</div>`;//fin #deplacement_picto

  c+= `<div class="tab-pane fade" id="deplacement_masque" role="tabpanel" aria-labelledby="deplacement_masque_tab">`;
  //c+= `contenu onglet Masque`;
	c+= "<h4 class='premier'>Déplacer des masques <button class='btn btn-outline-primary btn-sm masque_taille' data-t='t_p' title='petite taille de police'>P</button> <button class='btn btn-primary masque_taille' data-t='t_m' title='moyenne taille de police'>M</button> <button class='btn btn-outline-primary btn-lg masque_taille' data-t='t_g' title='grande taille de police'>G</button></h4>";
  c+= `<h5>Cliquer sur une couleur pour insérer un masque dans l'angle supérieur gauche.</h5>`;
  c+= `<div class="row">`;
  c+= `<div class="col d-flex align-items-center">`;
  c+= `<div class="coul_masque c_red mx-1 effet_bt_zoom" data-coul="c_red"></div>`;
  c+= `<div class="coul_masque c_deepPink mx-1 effet_bt_zoom" data-coul="c_deepPink"></div>`;
  c+= `<div class="coul_masque c_orange mx-1 effet_bt_zoom" data-coul="c_orange"></div>`;
  c+= `<div class="coul_masque c_yellow mx-1 effet_bt_zoom" data-coul="c_yellow"></div>`;
  c+= `<div class="coul_masque c_purple mx-1 effet_bt_zoom" data-coul="c_purple"></div>`;
  c+= `<div class="coul_masque c_green mx-1 effet_bt_zoom" data-coul="c_green"></div>`;
  c+= `<div class="coul_masque c_blue mx-1 effet_bt_zoom" data-coul="c_blue"></div>`;
  c+= `<div class="coul_masque c_brown mx-1 effet_bt_zoom" data-coul="c_brown"></div>`;
  c+= `<div class="coul_masque c_white mx-1 effet_bt_zoom" data-coul="c_white"></div>`;
  c+= `<div class="coul_masque c_gray mx-1 effet_bt_zoom" data-coul="c_gray"></div>`;
  c+= `<div class="coul_masque c_black mx-1 effet_bt_zoom" data-coul="c_black"></div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div class="text-center mt-3">`;
  c+= `<p><b>Faire un double-clic</b> sur un masque pour le supprimer.</p>`;
  c+= `<button id="masque_bt_supprimer_tous" class="btn btn-warning btn-sm">Supprimer tous les masques</button>`;
  c+= `</div>`;
  c+= `</div>`;//fin #deplacement_masque

  c+= `<div class="tab-pane fade" id="deplacement_postit" role="tabpanel" aria-labelledby="deplacement_postit_tab">`;
  //c+= `contenu onglet Post-it`;
	c+= "<h4 class='premier'>Renseigner et déplacer des post-its <button id='box_bt_postit' class='btn btn-primary btn-sm'>Afficher</button></h4>";
  c+= `</div>`;//fin #deplacement_postit

  c+= `<div class="tab-pane fade" id="deplacement_parcours" role="tabpanel" aria-labelledby="deplacement_parcours_tab">`;
  //c+= `contenu onglet Parcours`;
	c+= "<h4 class='premier'>Déplacer des pions sur des parcours <button id='box_bt_parcours' class='btn btn-primary btn-sm'>Afficher</button></h4>";
  c+= `<p>Chaque parcours étant constitué de cases sur lesquelles on positionne un pion. 6 parcours peuvent être affichés simultanément.</p>`;
  c+= `</div>`;//fin #deplacement_parcours

  c+= `<div class="tab-pane fade" id="deplacement_plateau" role="tabpanel" aria-labelledby="deplacement_plateau_tab">`;
  //c+= `contenu onglet Plateau`;
  c+= `<p>Dans le plateau de jeu, <b>faire un double-clic</b> sur un pion pour le supprimer.</p>`;
	c+= "<h4 class='premier'>Jouer au jeu de Dames <button id='box_bt_jeudedames88' class='btn btn-primary btn-sm'>Damier 8*8</button> <button id='box_bt_jeudedames1010' class='btn btn-primary btn-sm'>Damier 10*10</button></h4>";
	c+= "<h4>Jouer au jeu d'Échec <button id='box_bt_jeudechecs' class='btn btn-primary btn-sm'>Afficher</button></h4>";
	c+= `<h4>Jouer avec des plateaux de jeu <button id='plateau_bt_importer_fond_ecran' class='btn btn-primary btn-sm'>Insérer son image de plateau</button> <button id="plateau_bt_supprimer_fond_ecran" class="btn btn-danger btn-sm ms-1 mx-2 my-0" title="Supprimer le fond d'écran"><i class="bi bi-trash3-fill"></i></button> <button id='plateau_bt_lancer_des' class='btn btn-secondary btn-sm'>Lancer des dés</button></h4>`;
  c+= `<input type="file" id="plateau_input_importer_fond_ecran" accept="image/*" style="display:none">`;
  c+= `<h6>Cliquer sur un pion pour l'insérer : <img class="plateau_pion_mini effet_bt_zoom" src="medias/pion/pion_1.png" alt="pion 1" title="Insérer ce pion"><img class="plateau_pion_mini effet_bt_zoom" src="medias/pion/pion_2.png" alt="pion 2" title="Insérer ce pion"><img class="plateau_pion_mini effet_bt_zoom" src="medias/pion/pion_3.png" alt="pion 3" title="Insérer ce pion"><img class="plateau_pion_mini effet_bt_zoom" src="medias/pion/pion_4.png" alt="pion 4" title="Insérer ce pion"><img class="plateau_pion_mini effet_bt_zoom" src="medias/pion/pion_5.png" alt="pion 5" title="Insérer ce pion"> <button id='plateau_bt_supprimer_pions' class='btn btn-warning btn-sm'>Supprimer tous les pions</button></h6>`;
  
  c+= `<div id="conteneur_plateau" class="bg-info-subtle">`;
  c+= `<div class="row">`;
  c+= `<div class="col">`;
  c+= `<div class="input-group mb-2">`;
  c+= `<span class="input-group-text">Nombre de cases</span>`;
  c+= `<input id="plateau_nb_cases" type="number" min="10" max="63" value="20" class="form-control">`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div class="col d-flex align-items-center">`;
  c+= `<div class="form-check form-switch mb-2">`;
  c+= `<input class="form-check-input" type="checkbox" id="mode_spirale">`;
  c+= `<label class="form-check-label" for="mode_spirale">En spirale</label>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div class="col d-flex align-items-center">`;
  c+= `<div class="form-check form-switch mb-2">`;
  c+= `<input class="form-check-input" type="checkbox" id="mode_trace">`;
  c+= `<label class="form-check-label" for="mode_trace">Tracé du parcours</label>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div class="row">`;
  c+= `<div class="col-7">`;
  c+= `<div id="cases_speciales">`;
  c+= `<h6>Cases spéciales <em>(numéros séparés par des virgules)</em></h6>`;
  c+= `<div class="choix_case_speciale"><img src="" title="Hôtel" alt="Hôtel" id="img_hotel"><input type="text" class="form-control mt-1 choix_hotel"></div>`;
  c+= `<div class="choix_case_speciale"><img src="" title="Labyrinthe" alt="Labyrinthe" id="img_labyrinthe"><input type="text" class="form-control mt-1 choix_labyrinthe"></div>`;
  c+= `<div class="choix_case_speciale"><img src="" title="Moins 3" alt="Moins 3" id="img_moins3"><input type="text" class="form-control mt-1 choix_moins3"></div>`;
  c+= `<div class="choix_case_speciale"><img src="" title="Mort" alt="Mort" id="img_mort"><input type="text" class="form-control mt-1 choix_mort"></div>`;
  c+= `<div class="choix_case_speciale"><img src="" title="Oie" alt="Oie" id="img_oie"><input type="text" class="form-control mt-1 choix_oie"></div>`;
  c+= `<div class="choix_case_speciale"><img src="" title="Plus 3" alt="Plus 3" id="img_plus3"><input type="text" class="form-control mt-1 choix_plus3"></div>`;
  c+= `<div class="choix_case_speciale"><img src="" title="Pont" alt="Pont" id="img_pont"><input type="text" class="form-control mt-1 choix_pont"></div>`;
  c+= `<div class="choix_case_speciale"><img src="" title="Prison" alt="Prison" id="img_prison"><input type="text" class="form-control mt-1 choix_prison"></div>`;
  c+= `<div class="choix_case_speciale"><img src="" title="Puits" alt="Puits" id="img_puits"><input type="text" class="form-control mt-1 choix_puits"></div>`;
  c+= `<div class="choix_case_speciale"><img src="" title="Question" alt="Question" id="img_question"><input type="text" class="form-control mt-1 choix_question"></div>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div id="apercu_jeu" class="col-5">`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div class="row mt-2">`;
  c+= `<div class="col-7">`;
  c+= `<button id="plateau_bt_generer" class="btn btn-success btn-sm me-2">Générer le plateau</button>`;
  c+= `<button id="plateau_bt_export" class="btn btn-primary btn-sm disabled" disabled>Exporter en PNG</button>`;
  c+= `</div>`;
  c+= `<div class="col-5 text-end">`;
  c+= `<button id="plateau_bt_valider_fond" class="btn btn-warning btn-sm disabled" disabled>Placer en fond d'écran</button>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div style="font-size:90%; margin-top:5px; font-style:italic; color:red; text-align:center;">Attention ! Les fonds d'écrans ne sont pas récupérés lorsque l'on exporte les widgets.</div>`;
  c+= `</div>`;// fin #conteneur_plateau
  
  c+= `</div>`;//fin #deplacement_plateau
  c+= `</div>`;
  c+= `</div>`;
  c+= `</div></div></div>`;
  // Ajouter la modale dans le body
  $("body").append(c);

  
  modDeplEtiquettes();
  modDeplImages();
  modDeplPictos();
  modDeplMasques();
  modPostit();
  modParcours();
  modjeudedames88();
  modjeudedames1010();
  modjeudechecs();
  modPlateaux();
  modLancerDesPlateau();
  modGenererPlateau();

}// FIN genererModaleDeplacement()

function genererPicto(debut, fin, theme) {
  let bt = "";
  for (let i=debut ; i <= fin ; i++) {
    bt += `<img src="medias/`+theme+`/`+theme+`_`+i+`.png">`;
  }
  return bt;
}

function modDeplEtiquettes() {
  
  /* Focus sur champ de saisie de l'onglet Etiquette */
  if ($("#deplacement_etiquette_tab").hasClass("active")) {
    $('#outils_modal_act_deplacement').on('shown.bs.modal', function () {
      $('#etiquette_saisie').focus();
    })
  }

  /* Insérer une étiquette */
  $('.coul_etiq').on('click', function () {
    const idAlea = "id_"+Date.now();
    const texte = $("#etiquette_saisie").val().trim();
    const coul = $(this).attr("data-coul");
    const taille = $(".etiquette_taille.btn-primary").attr("data-t");
    creerEtiquette(idAlea, ["txt-move", "txt-resize", "etiq", coul, taille], 10, 10, texte, null, true);
    $("#etiquette_saisie").val("").focus();
  });

  /* Mettre le focus sur le champ de saisie au clic sur l'onglet Etiquette */
  $('#deplacement_etiquette_tab').on('click', function () {
    $("#etiquette_saisie").focus();
  });

  /* Switcher entre les tailles d'étiquette */
  $('.etiquette_taille').on('click', function () {
    $(".etiquette_taille").removeClass("btn-primary").addClass("btn-outline-primary");
    $(this).removeClass("btn-outline-primary").addClass("btn-primary");
  });

  /* Supprimer toutes les étiquettes */
  $('#etiquette_bt_supprimer_toutes').on('click', function () {
    $("#box-container .txt-widget.etiq").remove();
  });

}

function modDeplImages() {

  /* Insérer une image */
  $("#deplacement_image").on("click", "#depl_images_apercu img", function () {
    const alt = $(this).attr("alt");
    const src = $(this).attr("src");
    const idAlea = "id_"+Date.now();
    const largeur = $(this).width();
    const hauteur = $(this).height();
    const ratio = largeur / hauteur
    let fond = "txt-blanc";
    if ($("#image_switch_transparent").is(":checked")) fond = "txt-tranparent";
    creerImage(idAlea, ["txt-move", "txt-resize", "depl_image", fond], 10, 10, src, alt, 100 * ratio, 100, null, true);
  });

  /* Supprimer toutes les images insérées */
  $('#depl_image_bt_supprimer_toutes').on('click', function () {
    $("#box-container .txt-widget.depl_image").remove();
  });

}

function modDeplPictos() {

  /* Insérer un picto */
  $("#picto_content").on("click", "img", function () {
    const alt = $(this).attr("alt");
    const src = $(this).attr("src");
    const idAlea = "id_"+Date.now();
    let fond = "txt-blanc";
    if ($("#picto_switch_transparent").is(":checked")) fond = "txt-tranparent";
    creerImage(idAlea, ["txt-move", "txt-resize", "depl_picto", fond], 10, 10, src, alt, 100, 100, null, true);
  });

  /* Switcher le boutons actifs */
  $('#picto_bts > button').on('click', function () {
    const theme = $(this).attr("data-p");
    $('#picto_bts > button').removeClass("btn-secondary").addClass("btn-outline-secondary");
    $(this).removeClass("btn-outline-secondary").addClass("btn-secondary");
    $("#picto_content > div").hide();
    $("#picto_"+theme).show();
  });

  /* Supprimer tous les pictos */
  $('#picto_bt_supprimer_tous_pictos').on('click', function () {
    $("#box-container .txt-widget.depl_picto").remove();
  });

}

function modDeplMasques() {
  
  /* Insérer une étiquette */
  $('.coul_masque').on('click', function () {
    const idAlea = "id_"+Date.now();
    const coul = $(this).attr("data-coul");
    const taille = $(".masque_taille.btn-primary").attr("data-t");
    creerEtiquette(idAlea, ["txt-move", "txt-resize", "masque", coul, taille], 10, 10, "", null, true);
  });

  /* Switcher entre les tailles d'étiquette */
  $('.masque_taille').on('click', function () {
    $(".masque_taille").removeClass("btn-primary").addClass("btn-outline-primary");
    $(this).removeClass("btn-outline-primary").addClass("btn-primary");
  });

  /* Supprimer tous les masques */
  $('#masque_bt_supprimer_tous').on('click', function () {
    $("#box-container .txt-widget.masque").remove();
  });

}

function modPostit() {

  $('#box_bt_postit').on('click', function () {
    const idAlea = Date.now();
    c= `<div><div id="postit_`+idAlea+`"></div></div>`;
    creerBox('id_'+idAlea, 450, 200, ["box-move", "box-resize", "box-postit"], "Post-it", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_deplacement')).hide();
    activerQuill(idAlea);
  });

}

function activerQuill(id) {
  const quill_postit = new Quill('#postit_'+id, {
    theme: 'snow',
    modules: {
      toolbar: [
        ['bold', 'strike'],
        [{ 'list': 'ordered'}, { 'list': 'bullet' }],
        [{ 'align': [] }],
        [{ 'size': ['small', false, 'large', 'huge'] }],
        [{ 'color': [] }, { 'background': [] }],
        ['link'],
      ]
    }
  });  
  setTimeout(() => {quill_postit.focus();}, 100);
}

function modParcours() {
  let c = `<div id="parc_param">`;
  c+= `<div class="input-group input-group-sm mb-1">`;
  c+= `<span class="input-group-text">Nombre de cases par parcours</span>`;
  c+= `<input id="parc_nb_cases" type="number" min="1" value="10" style="width: 60px;">`;
  c+= `</div>`;
  c+= `<div class="input-group input-group-sm mb-2">`;
  c+= `<span class="input-group-text">Nombre de parcours</span>`;
  c+= `<button class="btn btn-secondary btn-sm parc_nb_parcours mx-1">1</button>`;
  c+= `<button class="btn btn-secondary btn-sm parc_nb_parcours mx-1">2</button>`;
  c+= `<button class="btn btn-secondary btn-sm parc_nb_parcours mx-1">3</button>`;
  c+= `<button class="btn btn-secondary btn-sm parc_nb_parcours mx-1">4</button>`;
  c+= `<button class="btn btn-secondary btn-sm parc_nb_parcours mx-1">5</button>`;
  c+= `<button class="btn btn-secondary btn-sm parc_nb_parcours mx-1">6</button>`;
  c+= `</div>`;
  c+= `</div>`;
  c+= `<div id="parc_conteneur"></div>`;

  /* Ouvrir la box Parcours */
  $('#box_bt_parcours').on('click', function () {
    creerBox('box_parcours', 600, 310, ["box-move", "box-resize"], "Parcours", 10, 10, html=c, null, true);
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_deplacement')).hide();
    box_parcoursCode();
  });
}
function box_parcoursCode() {
  function parcCreerParcours(nbParcours) {
    let nbCase = parseInt($("#parc_nb_cases").val());
    if (nbParcours < 1) nbParcours = 1;
    $("#parc_conteneur").html("");
    let leparcours = "";
    let tabParcours = [];
    let cpt = 0;
    for (let p=0 ; p < nbParcours ; p++) {
      let lescases = "";
      for (let i=0 ; i < nbCase+1 ; i++) {
        if (i === 0) lescases += `<div class="parc_case"><div class="parc_fond">`+i+`</div><div class='parc_pion'></div></div>`;
        else lescases += `<div class="parc_case"><div class="parc_fond">`+i+`</div></div>`;
      }
      tabParcours.push("<div class='parc_parcours' data-parc='"+cpt+"'><div class='parc_titre' contenteditable>???</div>"+lescases+"</div>");
      cpt++;
    }
    $("#parc_conteneur").append(tabParcours.join("<br>"));
    document.querySelector('.parc_titre').addEventListener('keydown', function(e) {
      if (e.key === 'Enter') {
        e.preventDefault(); // empêche le retour à la ligne
      }
    });
  }

  $("#parc_conteneur").on("click", ".parc_fond", function () {
    const indexParcours = $(this).closest(".parc_parcours").attr("data-parc");
    const indexCase = $(this).parent().index();
    $(".parc_parcours:eq("+indexParcours+") .parc_pion").remove();
    $(".parc_parcours:eq("+indexParcours+") .parc_case:eq("+(indexCase-1)+")").append("<div class='parc_pion'></div>");
  });

  $('.parc_nb_parcours').on('click', function (i) {
    const nbParcours = parseInt($(this).text());
    parcCreerParcours(nbParcours);
  });

}

function modjeudedames88() {
  let c = `<img src="medias/plateau/damier-8-8-couleur.png" />`;

  /* Ouvrir la box Jeu de Dames (damier 8-8) */
  $('#box_bt_jeudedames88').on('click', function () {
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_deplacement')).hide();
    creerBox('box_jeudedames88', 420, 450, ["box-move"], "Jeu de Dames (8*8)", 10, 10, html=c, null, true);
    creerImage("dame_88_noir_1", ["txt-move", "txt-transparent", "jeux_plateau"], 63, 13, "medias/jeton/jeton_18.png", "jeton noir 1", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_noir_2", ["txt-move", "txt-transparent", "jeux_plateau"], 163, 13, "medias/jeton/jeton_18.png", "jeton noir 2", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_noir_3", ["txt-move", "txt-transparent", "jeux_plateau"], 263, 13, "medias/jeton/jeton_18.png", "jeton noir 3", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_noir_4", ["txt-move", "txt-transparent", "jeux_plateau"], 363, 13, "medias/jeton/jeton_18.png", "jeton noir 4", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_noir_5", ["txt-move", "txt-transparent", "jeux_plateau"], 13, 63, "medias/jeton/jeton_18.png", "jeton noir 5", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_noir_6", ["txt-move", "txt-transparent", "jeux_plateau"], 113, 63, "medias/jeton/jeton_18.png", "jeton noir 6", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_noir_7", ["txt-move", "txt-transparent", "jeux_plateau"], 213, 63, "medias/jeton/jeton_18.png", "jeton noir 7", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_noir_8", ["txt-move", "txt-transparent", "jeux_plateau"], 313, 63, "medias/jeton/jeton_18.png", "jeton noir 8", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_noir_9", ["txt-move", "txt-transparent", "jeux_plateau"], 63, 113, "medias/jeton/jeton_18.png", "jeton noir 9", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_noir_10", ["txt-move", "txt-transparent", "jeux_plateau"], 163, 113, "medias/jeton/jeton_18.png", "jeton noir 10", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_noir_11", ["txt-move", "txt-transparent", "jeux_plateau"], 263, 113, "medias/jeton/jeton_18.png", "jeton noir 11", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_noir_12", ["txt-move", "txt-transparent", "jeux_plateau"], 363, 113, "medias/jeton/jeton_18.png", "jeton noir 12", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_blanc_1", ["txt-move", "txt-transparent", "jeux_plateau"], 13, 263, "medias/jeton/jeton_17.png", "jeton blanc 1", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_blanc_2", ["txt-move", "txt-transparent", "jeux_plateau"], 113, 263, "medias/jeton/jeton_17.png", "jeton blanc 2", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_blanc_3", ["txt-move", "txt-transparent", "jeux_plateau"], 213, 263, "medias/jeton/jeton_17.png", "jeton blanc 3", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_blanc_4", ["txt-move", "txt-transparent", "jeux_plateau"], 313, 263, "medias/jeton/jeton_17.png", "jeton blanc 4", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_blanc_5", ["txt-move", "txt-transparent", "jeux_plateau"], 63, 313, "medias/jeton/jeton_17.png", "jeton blanc 5", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_blanc_6", ["txt-move", "txt-transparent", "jeux_plateau"], 163, 313, "medias/jeton/jeton_17.png", "jeton blanc 6", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_blanc_7", ["txt-move", "txt-transparent", "jeux_plateau"], 263, 313, "medias/jeton/jeton_17.png", "jeton blanc 7", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_blanc_8", ["txt-move", "txt-transparent", "jeux_plateau"], 363, 313, "medias/jeton/jeton_17.png", "jeton blanc 8", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_blanc_9", ["txt-move", "txt-transparent", "jeux_plateau"], 13, 363, "medias/jeton/jeton_17.png", "jeton blanc 9", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_blanc_10", ["txt-move", "txt-transparent", "jeux_plateau"], 113, 363, "medias/jeton/jeton_17.png", "jeton blanc 10", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_blanc_11", ["txt-move", "txt-transparent", "jeux_plateau"], 213, 363, "medias/jeton/jeton_17.png", "jeton blanc 11", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
    creerImage("dame_88_blanc_12", ["txt-move", "txt-transparent", "jeux_plateau"], 313, 363, "medias/jeton/jeton_17.png", "jeton blanc 12", 40, 40, null, true, container = $('#box_jeudedames88 .box-content'));
  });
}

function modjeudedames1010() {
  let c = `<img src="medias/plateau/damier-10-10-couleur.png" />`;

  /* Ouvrir la box Jeu de Dames (damier 10*10) */
  $('#box_bt_jeudedames1010').on('click', function () {
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_deplacement')).hide();
    creerBox('box_jeudedames1010', 420, 450, ["box-move"], "Jeu de Dames (10*10)", 10, 10, html=c, null, true);
    creerImage("dame_1010_noir_1", ["txt-move", "txt-transparent", "jeux_plateau"], 50, 10, "medias/jeton/jeton_18.png", "jeton noir 1", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_2", ["txt-move", "txt-transparent", "jeux_plateau"], 130, 10, "medias/jeton/jeton_18.png", "jeton noir 2", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_3", ["txt-move", "txt-transparent", "jeux_plateau"], 210, 10, "medias/jeton/jeton_18.png", "jeton noir 3", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_4", ["txt-move", "txt-transparent", "jeux_plateau"], 290, 10, "medias/jeton/jeton_18.png", "jeton noir 4", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_5", ["txt-move", "txt-transparent", "jeux_plateau"], 370, 10, "medias/jeton/jeton_18.png", "jeton noir 5", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_6", ["txt-move", "txt-transparent", "jeux_plateau"], 10, 50, "medias/jeton/jeton_18.png", "jeton noir 6", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_7", ["txt-move", "txt-transparent", "jeux_plateau"], 90, 50, "medias/jeton/jeton_18.png", "jeton noir 7", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_8", ["txt-move", "txt-transparent", "jeux_plateau"], 170, 50, "medias/jeton/jeton_18.png", "jeton noir 8", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_9", ["txt-move", "txt-transparent", "jeux_plateau"], 250, 50, "medias/jeton/jeton_18.png", "jeton noir 9", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_10", ["txt-move", "txt-transparent", "jeux_plateau"], 330, 50, "medias/jeton/jeton_18.png", "jeton noir 10", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_11", ["txt-move", "txt-transparent", "jeux_plateau"], 50, 90, "medias/jeton/jeton_18.png", "jeton noir 11", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_12", ["txt-move", "txt-transparent", "jeux_plateau"], 130, 90, "medias/jeton/jeton_18.png", "jeton noir 12", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_13", ["txt-move", "txt-transparent", "jeux_plateau"], 210, 90, "medias/jeton/jeton_18.png", "jeton noir 13", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_14", ["txt-move", "txt-transparent", "jeux_plateau"], 290, 90, "medias/jeton/jeton_18.png", "jeton noir 14", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_15", ["txt-move", "txt-transparent", "jeux_plateau"], 370, 90, "medias/jeton/jeton_18.png", "jeton noir 15", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_16", ["txt-move", "txt-transparent", "jeux_plateau"], 10, 130, "medias/jeton/jeton_18.png", "jeton noir 16", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_17", ["txt-move", "txt-transparent", "jeux_plateau"], 90, 130, "medias/jeton/jeton_18.png", "jeton noir 17", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_18", ["txt-move", "txt-transparent", "jeux_plateau"], 170, 130, "medias/jeton/jeton_18.png", "jeton noir 18", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_19", ["txt-move", "txt-transparent", "jeux_plateau"], 250, 130, "medias/jeton/jeton_18.png", "jeton noir 19", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_noir_20", ["txt-move", "txt-transparent", "jeux_plateau"], 330, 130, "medias/jeton/jeton_18.png", "jeton noir 20", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_1", ["txt-move", "txt-transparent", "jeux_plateau"], 50, 250, "medias/jeton/jeton_17.png", "jeton blanc 1", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_2", ["txt-move", "txt-transparent", "jeux_plateau"], 130, 250, "medias/jeton/jeton_17.png", "jeton blanc 2", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_3", ["txt-move", "txt-transparent", "jeux_plateau"], 210, 250, "medias/jeton/jeton_17.png", "jeton blanc 3", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_4", ["txt-move", "txt-transparent", "jeux_plateau"], 290, 250, "medias/jeton/jeton_17.png", "jeton blanc 4", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_5", ["txt-move", "txt-transparent", "jeux_plateau"], 370, 250, "medias/jeton/jeton_17.png", "jeton blanc 5", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_6", ["txt-move", "txt-transparent", "jeux_plateau"], 10, 290, "medias/jeton/jeton_17.png", "jeton blanc 6", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_7", ["txt-move", "txt-transparent", "jeux_plateau"], 90, 290, "medias/jeton/jeton_17.png", "jeton blanc 7", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_8", ["txt-move", "txt-transparent", "jeux_plateau"], 170, 290, "medias/jeton/jeton_17.png", "jeton blanc 8", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_9", ["txt-move", "txt-transparent", "jeux_plateau"], 250, 290, "medias/jeton/jeton_17.png", "jeton blanc 9", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_10", ["txt-move", "txt-transparent", "jeux_plateau"], 330, 290, "medias/jeton/jeton_17.png", "jeton blanc 10", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_11", ["txt-move", "txt-transparent", "jeux_plateau"], 50, 330, "medias/jeton/jeton_17.png", "jeton blanc 11", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_12", ["txt-move", "txt-transparent", "jeux_plateau"], 130, 330, "medias/jeton/jeton_17.png", "jeton blanc 12", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_13", ["txt-move", "txt-transparent", "jeux_plateau"], 210, 330, "medias/jeton/jeton_17.png", "jeton blanc 13", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_14", ["txt-move", "txt-transparent", "jeux_plateau"], 290, 330, "medias/jeton/jeton_17.png", "jeton blanc 14", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_15", ["txt-move", "txt-transparent", "jeux_plateau"], 370, 330, "medias/jeton/jeton_17.png", "jeton blanc 15", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_16", ["txt-move", "txt-transparent", "jeux_plateau"], 10, 370, "medias/jeton/jeton_17.png", "jeton blanc 16", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_17", ["txt-move", "txt-transparent", "jeux_plateau"], 90, 370, "medias/jeton/jeton_17.png", "jeton blanc 17", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_18", ["txt-move", "txt-transparent", "jeux_plateau"], 170, 370, "medias/jeton/jeton_17.png", "jeton blanc 18", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_19", ["txt-move", "txt-transparent", "jeux_plateau"], 250, 370, "medias/jeton/jeton_17.png", "jeton blanc 19", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
    creerImage("dame_1010_blanc_20", ["txt-move", "txt-transparent", "jeux_plateau"], 330, 370, "medias/jeton/jeton_17.png", "jeton blanc 20", 36, 36, null, true, container = $('#box_jeudedames1010 .box-content'));
  });
}

function modjeudechecs() {
  let c = `<img src="medias/plateau/echiquier.png" />`;

  /* Ouvrir la box Jeu d'échecs) */
  $('#box_bt_jeudechecs').on('click', function () {
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_deplacement')).hide();
    creerBox('box_jeudechecs', 420, 450, ["box-move"], "jeu d'Échec", 10, 10, html=c, null, true);
    creerImage("echec_tour_noire1", ["txt-move", "txt-transparent", "jeux_plateau"], 13, 13, "medias/echec/echec_noir_tour.png", "tour noire", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_cavalier_noir1", ["txt-move", "txt-transparent", "jeux_plateau"], 63, 13, "medias/echec/echec_noir_cavalier.png", "tour noire", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_fou_noir1", ["txt-move", "txt-transparent", "jeux_plateau"], 113, 13, "medias/echec/echec_noir_fou.png", "fou noir", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_roi_noir", ["txt-move", "txt-transparent", "jeux_plateau"], 163, 13, "medias/echec/echec_noir_roi.png", "roi noir", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_dame_noire", ["txt-move", "txt-transparent", "jeux_plateau"], 213, 13, "medias/echec/echec_noir_dame.png", "dame noire", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_fou_noir2", ["txt-move", "txt-transparent", "jeux_plateau"], 263, 13, "medias/echec/echec_noir_fou.png", "fou noir", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_cavalier_noir2", ["txt-move", "txt-transparent", "jeux_plateau"], 313, 13, "medias/echec/echec_noir_cavalier.png", "tour noire", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_tour_noire2", ["txt-move", "txt-transparent", "jeux_plateau"], 363, 13, "medias/echec/echec_noir_tour.png", "tour noire", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_noir1", ["txt-move", "txt-transparent", "jeux_plateau"], 13, 63, "medias/echec/echec_noir_pion.png", "pion noir", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_noir2", ["txt-move", "txt-transparent", "jeux_plateau"], 63, 63, "medias/echec/echec_noir_pion.png", "pion noir", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_noir3", ["txt-move", "txt-transparent", "jeux_plateau"], 113, 63, "medias/echec/echec_noir_pion.png", "pion noir", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_noir4", ["txt-move", "txt-transparent", "jeux_plateau"], 163, 63, "medias/echec/echec_noir_pion.png", "pion noir", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_noir5", ["txt-move", "txt-transparent", "jeux_plateau"], 213, 63, "medias/echec/echec_noir_pion.png", "pion noir", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_noir6", ["txt-move", "txt-transparent", "jeux_plateau"], 263, 63, "medias/echec/echec_noir_pion.png", "pion noir", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_noir7", ["txt-move", "txt-transparent", "jeux_plateau"], 313, 63, "medias/echec/echec_noir_pion.png", "pion noir", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_noir8", ["txt-move", "txt-transparent", "jeux_plateau"], 363, 63, "medias/echec/echec_noir_pion.png", "pion noir", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_blanc1", ["txt-move", "txt-transparent", "jeux_plateau"], 13, 313, "medias/echec/echec_blanc_pion.png", "pion blanc", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_blanc2", ["txt-move", "txt-transparent", "jeux_plateau"], 63, 313, "medias/echec/echec_blanc_pion.png", "pion blanc", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_blanc3", ["txt-move", "txt-transparent", "jeux_plateau"], 113, 313, "medias/echec/echec_blanc_pion.png", "pion blanc", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_blanc4", ["txt-move", "txt-transparent", "jeux_plateau"], 163, 313, "medias/echec/echec_blanc_pion.png", "pion blanc", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_blanc5", ["txt-move", "txt-transparent", "jeux_plateau"], 213, 313, "medias/echec/echec_blanc_pion.png", "pion blanc", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_blanc6", ["txt-move", "txt-transparent", "jeux_plateau"], 263, 313, "medias/echec/echec_blanc_pion.png", "pion blanc", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_blanc7", ["txt-move", "txt-transparent", "jeux_plateau"], 313, 313, "medias/echec/echec_blanc_pion.png", "pion blanc", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_pion_blanc8", ["txt-move", "txt-transparent", "jeux_plateau"], 363, 313, "medias/echec/echec_blanc_pion.png", "pion blanc", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_tour_blanche1", ["txt-move", "txt-transparent", "jeux_plateau"], 13, 363, "medias/echec/echec_blanc_tour.png", "tour blanche", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_cavalier_blanc1", ["txt-move", "txt-transparent", "jeux_plateau"], 63, 363, "medias/echec/echec_blanc_cavalier.png", "tour blanche", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_fou_blanc1", ["txt-move", "txt-transparent", "jeux_plateau"], 113, 363, "medias/echec/echec_blanc_fou.png", "fou blanc", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_roi_blanc", ["txt-move", "txt-transparent", "jeux_plateau"], 163, 363, "medias/echec/echec_blanc_roi.png", "roi blanc", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_dame_blanche", ["txt-move", "txt-transparent", "jeux_plateau"], 213, 363, "medias/echec/echec_blanc_dame.png", "dame blanche", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_fou_blanc2", ["txt-move", "txt-transparent", "jeux_plateau"], 263, 363, "medias/echec/echec_blanc_fou.png", "fou blanc", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_cavalier_blanc2", ["txt-move", "txt-transparent", "jeux_plateau"], 313, 363, "medias/echec/echec_blanc_cavalier.png", "tour blanche", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
    creerImage("echec_tour_blanche2", ["txt-move", "txt-transparent", "jeux_plateau"], 363, 363, "medias/echec/echec_blanc_tour.png", "tour blanche", 40, 40, null, true, container = $('#box_jeudechecs .box-content'));
  });
}

function modPlateaux() {

  // Importer un fond d'écran pour plateau => bouton
  $('#plateau_bt_importer_fond_ecran').click(() => {
    $('#plateau_input_importer_fond_ecran').click();
  });

  // Importer un fond d'écran pour plateau => input file
  document.getElementById('plateau_input_importer_fond_ecran').addEventListener('change', function (e) {
    const fichier = e.target.files[0];

    if (!fichier || !fichier.type.startsWith('image/')) return;

    const reader = new FileReader();
    reader.onload = function (event) {
      const img = new Image();
      img.onload = function () {
        const maxSize = 800;
        let width = img.width;
        let height = img.height;

        if (width > height) {
          if (width > maxSize) {
            height *= maxSize / width;
            width = maxSize;
          }
        } else {
          if (height > maxSize) {
            width *= maxSize / height;
            height = maxSize;
          }
        }

        const canvas = document.createElement('canvas');
        canvas.width = width;
        canvas.height = height;
        const ctx = canvas.getContext('2d');
        ctx.drawImage(img, 0, 0, width, height);

        const miniature = new Image();
        miniature.src = canvas.toDataURL();
        $("#outils_ecran_activites").css("background","url("+miniature.src+") center / contain no-repeat");
      };
      img.src = event.target.result;
    };
    reader.readAsDataURL(fichier);
  });

  // Supprimer le fond d'écran pour plateau
  $('#plateau_bt_supprimer_fond_ecran').click(() => {
    $("#outils_ecran_activites").css("background","");
    //bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_deplacement')).hide();
  });

  /* Insérer un pion */
  $('.plateau_pion_mini').on('click', function () {
    const alt = $(this).attr("alt");
    const src = $(this).attr("src");
    const idAlea = "id_"+Date.now();
    const largeur = $(this).width();
    const hauteur = $(this).height();
    const ratio = largeur / hauteur
    creerImage(idAlea, ["txt-move", "depl_pion"], 10, 10, src, alt, 40 * ratio, 40, null, true);
  });

  /* Supprimer tous les pions */
  $('#plateau_bt_supprimer_pions').on('click', function () {
    $(".depl_pion").remove();
  });

}

function modLancerDesPlateau() {
  let c = ``;
  c+= `<div class="d-flex justify-content-center text-center">`;
  c+= `<select id="de_choix_nb" style="width:100px;" class="me-2">`;
  c+= `<option value="1">1 dé</option>`;
  c+= `<option value="2">2 dés</option>`;
  c+= `<option value="3">3 dés</option>`;
  c+= `<option value="4">4 dés</option>`;
  c+= `<option value="5">5 dés</option>`;
  c+= `<option value="6">6 dés</option>`;
  c+= `</select>`;
  c+= `<button class="btn btn-success" id="de_bt_jouer">Jouer !</button>`;
  c+= `</div>`;
  c+= `<div id="de_lesdes" class="mt-3 text-center">`;
  c+= `<div class="de-container"><img id="de_1" src="medias/de/de_logo.png" alt="Dé 1" class="de"></div>`;
  c+= `</div>`;
  
  /* Ouvrir la box Lancer de dés */
  $('#plateau_bt_lancer_des').on('click', function () {
    creerBox('box_lancer_des', 250, 210, ["box-move", "box-resize"], 'Lancer de dés', 10, 10, html=c, null, true);
    box_lancer_desCode();
  });
}

function modGenererPlateau() {
  // assigner les images base64 aux aperçus
  $("#img_hotel").attr("src", plateauImagesBase64.hotel);
  $("#img_labyrinthe").attr("src", plateauImagesBase64.labyrinthe);
  $("#img_moins3").attr("src", plateauImagesBase64.moins3);
  $("#img_mort").attr("src", plateauImagesBase64.mort);
  $("#img_oie").attr("src", plateauImagesBase64.oie);
  $("#img_plus3").attr("src", plateauImagesBase64.plus3);
  $("#img_pont").attr("src", plateauImagesBase64.pont);
  $("#img_prison").attr("src", plateauImagesBase64.prison);
  $("#img_puits").attr("src", plateauImagesBase64.puits);
  $("#img_question").attr("src", plateauImagesBase64.question);

  $("#plateau_bt_generer").on("click", function(){
    const nb = parseInt($("#plateau_nb_cases").val());
    const spiral = $("#mode_spirale").is(":checked");
    const showTrace = $("#mode_trace").is(":checked");
    const specialCases = {};
    $(".choix_case_speciale").each(function(){
      const cls = $(this).find("input").attr("class").split(" ").pop().replace("choix_","");
      const nums = $(this).find("input").val().split(",");
      nums.forEach(n=>{
        const num = parseInt(n.trim());
        if(!isNaN(num)) specialCases[num] = cls;
      });
    });

    const W = 900, H = 600, T = 64;
    const canvas = document.createElement("canvas");
    canvas.width = W; canvas.height = H;
    const ctx = canvas.getContext("2d");
    ctx.clearRect(0,0,W,H);
    ctx.font = "20px sans-serif"; ctx.textBaseline = "top";

    const positions = [];
    if(!spiral){
      let colsMax = Math.floor(W/T);
      let rowsUtil = Math.ceil((nb+2)/colsMax);

      // si la dernière ligne n’est pas pleine
      let colsUtilLast = (nb+2) % colsMax || colsMax;

      // largeur et hauteur réellement utilisées
      let usedW = colsMax * T;
      let usedH = rowsUtil * T;

      // offsets pour centrer
      let offsetX = Math.floor((W - usedW) / 2);
      let offsetY = Math.floor((H - usedH) / 2);

      for(let i=0;i<nb+2;i++){
        let row = Math.floor(i/colsMax);
        let col = i%colsMax;
        if(row%2===1) col = colsMax-1-col; // zigzag
        let x = col*T + offsetX;
        let y = row*T + offsetY;
        positions.push({x,y});
      }
    }else{
      let cx = Math.floor(W/2/T)*T, cy = Math.floor(H/2/T)*T;
      let dir = [[1,0],[0,1],[-1,0],[0,-1]];
      let step=1, d=0, x=0,y=0;
      positions.push({x:cx,y:cy});
      while(positions.length<nb+2){
        for(let rep=0;rep<2;rep++){
          for(let s=0;s<step;s++){
            if(positions.length>=nb+2) break;
            x+=dir[d][0]; y+=dir[d][1];
            positions.push({x:cx+x*T,y:cy+y*T});
          }
          d=(d+1)%4;
        }
        step++;
      }
    }

    // … le reste de ton code de dessin (inchangé) …

    // dessiner les cases avec bordures etc.
    for(let i=0;i<positions.length;i++){
      const {x,y}=positions[i];
      if(i === 0){
        ctx.fillStyle = "yellow";
      } else if(i === positions.length-1){
        ctx.fillStyle = "#00FF00";
      } else {
        ctx.fillStyle = "#fff";
      }
      ctx.fillRect(x,y,T,T);
      ctx.lineWidth = 3;
      const voisins = [];
      if(i > 0) voisins.push(positions[i-1]);
      if(i < positions.length-1) voisins.push(positions[i+1]);
      function estVoisin(px,py){
        return voisins.some(v => v.x === px && v.y === py);
      }
      // Haut
      ctx.beginPath(); ctx.moveTo(x, y); ctx.lineTo(x+T, y);
      ctx.strokeStyle = estVoisin(x, y-T) ? "#CDCDCD" : "blue"; ctx.stroke();
      // Bas
      ctx.beginPath(); ctx.moveTo(x, y+T); ctx.lineTo(x+T, y+T);
      ctx.strokeStyle = estVoisin(x, y+T) ? "#CDCDCD" : "blue"; ctx.stroke();
      // Gauche
      ctx.beginPath(); ctx.moveTo(x, y); ctx.lineTo(x, y+T);
      ctx.strokeStyle = estVoisin(x-T, y) ? "#CDCDCD" : "blue"; ctx.stroke();
      // Droite
      ctx.beginPath(); ctx.moveTo(x+T, y); ctx.lineTo(x+T, y+T);
      ctx.strokeStyle = estVoisin(x+T, y) ? "#CDCDCD" : "blue"; ctx.stroke();
      if(i===0){
        let img=new Image(); img.src=plateauImagesBase64.depart;
        img.onload=()=>{ctx.drawImage(img,x+12,y+12,40,40); $("#apercu_jeu").html(`<img src="${canvas.toDataURL()}" alt="plateau"/>`);}
      } else if(i===positions.length-1){
        let img=new Image(); img.src=plateauImagesBase64.arrivee;
        img.onload=()=>{ctx.drawImage(img,x+12,y+12,40,40); $("#apercu_jeu").html(`<img src="${canvas.toDataURL()}" alt="plateau"/>`);}
      } else {
        ctx.fillStyle="black"; ctx.fillText(i, x+4, y+2);
        if(specialCases[i]){
          let key=specialCases[i];
          let img=new Image(); img.src=plateauImagesBase64[key];
          img.onload=()=>{ctx.drawImage(img,x+12,y+12,40,40); $("#apercu_jeu").html(`<img src="${canvas.toDataURL()}" alt="plateau"/>`);}
        }
      }
    }

    // tracer le chemin rouge si activé
    if(showTrace){
      ctx.strokeStyle="#FF4D4D"; ctx.lineWidth=2; ctx.beginPath();
      for(let i=0;i<positions.length;i++){
        const {x,y}=positions[i];
        const cx=x+T/2, cy=y+T/2;
        if(i===0) ctx.moveTo(cx,cy); else ctx.lineTo(cx,cy);
      }
      ctx.stroke();
      for(let i=1;i<positions.length;i++){
        const {x:x1,y:y1}=positions[i-1];
        const {x:x2,y:y2}=positions[i];
        const cx1=x1+T/2, cy1=y1+T/2;
        const cx2=x2+T/2, cy2=y2+T/2;
        const angle=Math.atan2(cy2-cy1,cx2-cx1);
        const midX=(cx1+cx2)/2, midY=(cy1+cy2)/2;
        ctx.fillStyle="#FF4D4D";
        ctx.beginPath();
        ctx.moveTo(midX,midY);
        ctx.lineTo(midX-6*Math.cos(angle-Math.PI/6), midY-6*Math.sin(angle-Math.PI/6));
        ctx.lineTo(midX-6*Math.cos(angle+Math.PI/6), midY-6*Math.sin(angle+Math.PI/6));
        ctx.closePath(); ctx.fill();
      }
    }

    // afficher l'image
    window.lastCanvas=canvas;
    $("#apercu_jeu").html(`<img src="${canvas.toDataURL("image/png")}" alt="Plateau généré"/>`);

    $("#plateau_bt_export").removeAttr("disabled").removeClass("disabled");
    $("#plateau_bt_valider_fond").removeAttr("disabled").removeClass("disabled");
  });

  $("#plateau_bt_export").on("click",function(){
    if(window.lastCanvas){
      const link=document.createElement("a");
      //link.download="plateau.png";
      link.download="plateau-"+afficherDateEnr()+".png";
      link.href=window.lastCanvas.toDataURL("image/png");
      link.click();
    } else {
      alert("Veuillez d'abord générer un plateau.");
    }
  });

  $("#plateau_bt_valider_fond").on("click",function(){
    const src = $("#apercu_jeu img").attr("src");
    $("#outils_ecran_activites").css("background","url("+src+") center / contain no-repeat");
    bootstrap.Modal.getInstance(document.getElementById('outils_modal_act_deplacement')).hide();
  });

}