<?php
/* Indexation des dossiers */
$listeItems = array();
$listeDossiers = array();

# Répertoire racine
$cheminRacine = "./mes-series-dimages";
# Chemin à parcourir
$repertoire = opendir($cheminRacine) or die("Erreur : le repertoire $cheminRacine n'existe pas.");
while($dossierSerie = @readdir($repertoire))
{
	// Suppression des traitements inutiles
	if ($dossierSerie == "." || $dossierSerie == "..") continue;
	$cheminConfig = $cheminRacine.'/'.$dossierSerie.'/index.html';
	// Vérification de la conformité du répertoire
	if(is_dir($cheminRacine.'/'.$dossierSerie) && file_exists($cheminConfig))
	{
		// Récupération du contenu de la configuration
		$contenuConfig = file_get_contents($cheminConfig);
		// Recherche du titre dans la configuration
		preg_match('/const\s?titrePage\s?=\s?"(.*)";/', $contenuConfig, $resTitre);
		// Recherche de l'auteur dans la configuration
		preg_match('/const\s?auteurPage\s?=\s?"(.*)";/', $contenuConfig, $resAuteur);
		// Recherche de l'extension image dans la configuration
		preg_match('/const\s?formatImage\s?=\s?"(.*)";/', $contenuConfig, $resExtension);
		// Affichage uniquement si le titre et l'extension ne sont pas vides
		if (isset($resTitre[1]) && !empty($resTitre[1]) && isset($resExtension[1]) && !empty($resExtension[1]))
		{
			$cheminImage = $cheminRacine.'/'.$dossierSerie.'/images-et-sons/image1.'.$resExtension[1];
			$cheminSerie = $cheminRacine.'/'.$dossierSerie.'/index.html';
			// Affichage uniquement si le titre n'est pas vide et que l'image1 existe
			if (file_exists($cheminSerie) && file_exists($cheminImage))
			{
				$titre = $resTitre[1];
				// création du sous tableau s'il n'existe pas à cet index de titre
				if (!isset($listeItems[$titre]))
				{ 
					$listeItems[$titre] = array(); 
				}
				$idx = count($listeItems[$titre]);

				$listeDossiers[] = $dossierSerie;
				$listeItems[$titre][$idx] = array(
					'titre' =>  $titre,
					'chemin' =>  $cheminSerie,
					'dossier' =>  $dossierSerie,
					'auteur' =>  $resAuteur[1],
				);
			}
		}
	}
}
// Fermeture du répertoire
closedir($repertoire);
// Tri du tabeau
ksort($listeItems);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>Images parlantes</title>
	<style>
		*, *::before, *::after {box-sizing: border-box;}
		body {background-color:#CCCCFF; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji"; font-size: 1rem; font-weight: 400; line-height: 1.5; color: #212529;}
		table {border-collapse: collapse; background-color: #F7EEC6; width:100%; margin:auto;}
		table td, table th {padding: 0.3rem; vertical-align: top; border-top: 1px solid #E9BE95; font-weight:500;}
		table tr:hover {background-color: #E0BF25; cursor:pointer; color:#FFF;}
		table th, table th:hover {background-color: #E9BE95; cursor:default; font-weight:bold; color: #212529;}
		.filtre {display:block; float:none; width: 240px;}
		#filtre {width: 200px; padding: 0.375rem 0.75rem; font-size: 1rem; line-height: 1.5; color: #495057; background-color: #fff; background-clip: padding-box; border: 1px solid #ced4da; border-radius: 0.25rem; transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;}
		#serie_hasard {cursor:pointer; float:right; -ms-transition: 2s; -webkit-transition: 2s; transition: 2s;}
		#serie_hasard:hover {-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);}
		.container {width: 100%; padding-right: 15px; padding-left: 15px; margin-right: auto; margin-left: auto;}
		@media (min-width: 576px) {.container {max-width: 540px;}  .filtre {float:right;}}
		@media (min-width: 768px) {.container {max-width: 720px;}}
		@media (min-width: 992px) {.container {max-width: 960px;}}
		@media (min-width: 1200px) {.container {max-width: 1140px;}}
	</style>
</head>
<body>
<div class="container">
	<div class="filtre">
		<img id="serie_hasard" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAAsgAAALIBa5Ro4AAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAATzSURBVFiFrZdbbFRFGMd/c87ZPbvtdsuWlgSo8RZFSLwgMUZUiEZeMBg1ESTQByEx0oJgTQQjalvBB4zcoWIMKoIEIYKJ0dholEBijCGKRYqoBYReaKHdbrt7ds+eM+NDL7Dt3gp8bzvzzf//m5lv5swKriGiK9aO11y3DkUFoAH70OUb/k01/41WS4wmWdXUeBOX9CUKVQcEh3VbQqjNpt+3Vqxb2XvDAeLLaucoJTYCt+VIbRVQa5bKj0RNjbxugOiyuqmaYgMwM0/WQeFjSmor/NtXH70mgEjVu2MNnLeEoArQR2N+VSiBOKAM9zX/xpqzeQGoF3d4Et6OSoWqBYqv0Xh4xIRQW9LVRwpArKr2GSHEe8DtOSWFQL9nEug67vEmcHNuN8B5YJVv65t7BUKlAMSW1m0TUJmPCoAx62GMpx4HwPnhZ5xD3+c7FKXUnoJtby+E/jNMT0X1bKuzpdKJx/IXicev/IjmP87qi9B+5tSC9rkvLQIwANDkdOk6xMOd6F4f3qIQusebVcg9cgx1pgV0DXmuNadx0k4QvtiCFY30j3ech4CdBoCSaqjKXTuOdbkNw1eIGSxBaFpGUXmhPaexlJLerg4ilztQ6qo6EUqDwRVIE048imNbmIVBPAVBEKO6NAGI9nTR3dmGdJIZc0YAaFPuhEgUeaEFpCTRGyZpRfEWhTBMf17GthWlq6MV24oOtclxZciSEMap01kA/D7MlS+DUtjvb8dtbOof7CSJd3egm37MYAhN96Q1dp0k4Y5WopEwoK6033IzfUsWg65TtGYdWrjnyoRTFKw48s+/QNPQpt070iBhEetsw+7tStlPJSWRrou0NTcRjXSnmAMkp9wFuo5x7jxaTyTLCgD2hnq0++5G/v1v2lmCwo72kozHMAMh7IFZO0k7Qz6Yh4+it7RinDwFKhVuBIBKOri//pZRbCjPdYn3XKI7EkZJlTVXRKN4jjem7ct4CtKFt3oJojSEvf0T1IXcZz+fyHzI04QIBNDKJ+KZ/2xe+W75BGQodOMA7A8/xf39BLLpdM7cxGMz6FtRRaxiXta81C0QAs9zT6F6enEafhxRMKq9A3t9fX6wD9zfb5CxmNMBmF6M2U+ApoGSOA0/5WWWLvwHDqICQTyNJ7LmaQAKHADiCZxD34CUECy6ZnMAo/kcnj8aR6ziYCihJWFgBZSH77BYDZA89C3JhsNgWdcFkCs0XWuAgRUo2bnpqOEv/HqoNxZLSy5CYxAlWapaCNyJ40HPVtuCgqLiIxP27fhyCAAg9NnmOd6CwALd4+3JNNR8fTm+9XXoD05Lax5dVEHfK0tJzHgk7XiP6Y8FS8YtvengxzMG21JQi3dt+rxkb/0Ywx9Yo2mGM1xANp8FTcOYNfKFLsvG4kyeBEqhn29J6dMNQxYWl+y+teCO0Pgv6relcGearaqsDIT7jF2uFXtaKSUAhMeDNnM6qrUNebL/Lhi6ioXAfnQ6Wmsbxj/NA+ICbyB4PBA0nyzd9UFLOp+cr4zuxdVTVTyxx03EJ6ftz/AtMAsKLxaagXll++sPZ9PP+5nT9UL1QuLWVjdpp/xXGA7gMf0xMxBYNXHfji356I76ndVdsfwdmYivktIxrgbQDUOageBX5aL8ebG/JvO3+XoBACLzXy11jeReaSdmdkd68fp8v/gLg3PLdm9sG63W/7dJEjqSZLb0AAAAAElFTkSuQmCC" alt="une série d'images au hasard ?" title="une série d'images au hasard ?" />
		<input type='text' id='filtre' onkeyup="filtrerTab()" placeholder='Filtrer...' />
	</div>
	<h1 style='padding:0; margin:10px 0 30px 0; color:#B35F34; font-weight:600;'>Images parlantes</h1>
	<table id="tab_series">
		<tr><th>Titre de la série</th><th>Auteur</th></tr>
		<?php 
			foreach ($listeItems as $itemTab)
			{
				foreach ($itemTab as $item)
				{
					echo "<tr class='ligne-serie' onclick=\"document.location.href='".$item['chemin']."'\"><td>".$item['titre']."</td><td>".$item['auteur']."</td></tr>";
				}
			}
		?>
	</table>
</div>

<script>

	/* Générer un tableau JS des dossiers */
	var listeNomsDossiers = new Array();
	<?php foreach($listeDossiers as $nomDossier) { ?>
		listeNomsDossiers.push('<?php echo $nomDossier;?>')
	<?php } ?>

	/* Ouvrir la série d'images tirée au sort */
	document.querySelector('#serie_hasard').onclick = function () {
		var indDossierAleatoire = Math.floor((listeNomsDossiers.length)*Math.random());
		document.location.href="mes-series-dimages/"+listeNomsDossiers[indDossierAleatoire]+"/index.html";
	};

	/* Filtrer le tableau des séries */
	function filtrerTab() {
		var input, filter, table, tr, td, i, txtValue;
		input = document.getElementById("filtre");
		filter = input.value.toUpperCase();
		table = document.getElementById("tab_series");
		tr = table.getElementsByTagName("tr");
		for (i = 0; i < tr.length; i++) {
			td = tr[i].getElementsByTagName("td")[0];
			td2 = tr[i].getElementsByTagName("td")[1];
			if (td) {
				txtValue = td.textContent + td2.textContent || td.innerText + td2.innerText;
				if (txtValue.toUpperCase().indexOf(filter) > -1) {
					tr[i].style.display = "";
				} else {
					tr[i].style.display = "none";
				}
			}       
		}
	}

</script>

</body>
</html>


