/*!
* Digipadons v1.0 (https://pragmatice.net/lesite/spip.php?article1571)
* Copyright 2001-2025 Pragmatice (https://pragmatice.net)
* Licensed CC-by-SA (https://creativecommons.org/licenses/by-sa/4.0/legalcode.txt)
*/
var tabDigipad = [];
const urlDigipad = "https://digipad.app";
var idPad = "";
var tokenPad = "";
var stockageMediasPad = "";
const infoPragmatice = "<div class='info_pragmatice'>Document généré avec l'application <a href='https://pragmatice.net/lesite/spip.php?article1571' target='_blank'>Digipadons</a>, mise à disposition gratuitement par l'association <a href='https://pragmatice.net' target='_blank'>PragmaTICE</a></div>";

$(document).ready(function() {

	// Afficher le qrcode de l'appli
	$('#qrcode_appli').qrcode({
		text	: document.location.href,
		width: 80,
		height: 80
	});

	// Imprimer la page en cours
	$(".bt_imprimer").click(function() {
	//$('body').on('click', '.bt_imprimer', function () {
		window.print();
	});

	// Accéder à la page d'accueil
    $(".bt_acces_accueil").click(function() {
        changeEcran("accueil");
		$("head title").text("Digipadons");
    });

    // Importer un Digipad
    $(".bt_importer_digipad").click(function() {
        $('#gruge_parcourir_importer_digipad').click();
    });
    $('#gruge_parcourir_importer_digipad').change(function() {
		var reader = new FileReader();
        reader.onload = function (e) {
            var ctnImporte = e.target.result;
            tabDigipad = JSON.parse(ctnImporte);
            if (!verifDigipad(tabDigipad)) {
                alert("Oups ! Ce fichier n'est pas un export de Digipad valide (donnees.json)...");
                return false;
            }
			idPad = tabDigipad.pad.id;
			tokenPad = tabDigipad.pad.token;
			stockageMediasPad = $("#stockage_medias_pad").val().trim();
			const urlPad = urlDigipad+"/p/"+idPad+"/"+tokenPad;

			// on insère le qrcode et le titre du pad, avec lien
			$("#titre-pad").html("<a target='_blank' href='"+urlPad+"' />"+tabDigipad.pad.titre+"</a>");
			$("#url-pad").html("<a target='_blank' href='"+urlPad+"' />"+urlPad+"</a>");
			$('#qrcode-pad').html("").qrcode({
				text	: urlPad,
				width: 90,
				height: 90
			});
	
			// on génère le tableau des capsules du pad
			if (tabDigipad.pad.affichage == "colonnes") {// Digipad en colonnes
				$("#aff_col_cachee").show();
				const tabColonnes = JSON.parse(tabDigipad.pad.colonnes);
				const tabAffichageColonnes = JSON.parse(tabDigipad.pad.affichageColonnes);
				var tabHtmlColonnes = [];
				var tabCapsules = genererTableau(tabDigipad);
				for (c=0 ; c < tabColonnes.length ; c++) {
					var ctn = "<div"+(tabAffichageColonnes[c] == false ? ' class=\"c_cachee\"' : '')+">";
					ctn += "<h3>"+tabColonnes[c]+"</h3>";
					ctn += "<table class='table table-sm'><tbody class='t_col t_col_"+c+"' data-col='"+c+"'></tbody></table>";
					ctn += "</div>";
					tabHtmlColonnes.push(ctn);
				}
				$("#zone_contenu").html(tabHtmlColonnes.join("")+infoPragmatice);
				for (f=0 ; f < tabCapsules.length ; f++) {
					$(".t_col_"+parseInt(tabCapsules[f][1])).append(tabCapsules[f][0]);
				}
			} else {// Digipad en mur ou flux vertical
				$("#aff_col_cachee").hide();
				$("#zone_contenu").html("<table class='table table-sm'><tbody>"+genererTableau(tabDigipad).join("")+"</tbody></table>"+infoPragmatice);
			}

			// on ajoute les qrcode
			$(".t_qrc").each(function(){
				var lelien = $(this).attr("data-lien");
				if (lelien != "") {
					$(this).qrcode({
						text	: lelien,
						width: 90,
						height: 90
					});
				}
			});

			verifierCasePrivee();
			verifierCaseVignette();
			verifierCaseQrcode();
			if (tabDigipad.pad.affichage == "colonnes") verifierColonneCachee();
			changeEcran("contenu");
			$("head title").text(tabDigipad.pad.titre);
		};
        reader.readAsText($('#gruge_parcourir_importer_digipad').prop('files')[0], 'utf-8');
    });

	// Agir sur la case Capsule privée
	$('#case_privee').click(function () {
		verifierCasePrivee();
	});

	// Agir sur la case Vignette
	$('#case_vignette').click(function () {
		verifierCaseVignette();
	});

	// Agir sur la case Case QRCode
	$('#case_qrcode').click(function () {
		verifierCaseQrcode();
	});

	// Agir sur la case Case Colonne cachée
	$('#colonne_cachee').click(function () {
		verifierColonneCachee();
	});
	
	// Gérer le look des tableaux de contenu
	$('.modalite_affichage > img').click(function () {
		$('.modalite_affichage > img').removeClass("on");
		$(this).addClass("on");
		gererLookTableaux();
	});

	$('body').on('click', '.plier_deplier_suivant', function () {
        var chevron = $(this).find(".chevron");
        if (chevron.hasClass("fa-angle-down")) {
            chevron.removeClass("fa-angle-down").addClass("fa-angle-up");
            $(this).next().slideDown();
        } else {
            chevron.removeClass("fa-angle-up").addClass("fa-angle-down");
            $(this).next().slideUp();
        }
	});

    /*	Ajouter le bouton de retour en haut de page */
    $('body').append('<div id="returnOnTop" title="Retour en haut">&nbsp;</div>');
	//	Aller en haut de page au clic sur le bouton retour
    $('#returnOnTop').click( function() {
		$('html,body').animate({scrollTop: 0}, 'slow');
    });
	retourHaut();

}); // Fin $(document).ready(function()

function verifDigipad(digip) {
    if (typeof digip.pad === "undefined") return false;
    if (typeof digip.pad.id === "undefined") return false;
    if (!digip.pad.id) return false;
	if (typeof digip.pad.affichage === "undefined") return false;
    if (!digip.pad.affichage) return false;
    if (typeof digip.blocs === "undefined") return false;
    return true;
}

function genererTableau(tablo) {
	// on crée un nouveau tableau js avec les blocs dans l'ordre
	var tabIdBlocs = [];
	var tabloOrdre = [];
	for (i=0 ; i < tablo.blocs.length ; i++) {
		const elementCourant = tablo.blocs[i];

		// on crée le tableau des ID des blocs
		tabIdBlocs.push(elementCourant.id);

		// on alimente le tableau des blocs dans l'ordre
		for (o=0 ; o < tabIdBlocs.length ; o++) {
			if (tabIdBlocs[o] == elementCourant.id) tabloOrdre.push(elementCourant);
		}
	}

	// on crée le contenu de chaque cellule
	var tabHtmlTr = [];
	for (b=0 ; b < tabloOrdre.length ; b++) {
		const elementCourant = tabloOrdre[b];
		const letitre = elementCourant.titre;
		const letexte = elementCourant.texte;
		var lelien,lavignette;
		if (elementCourant.type == "") {
			lelien = "";
			lavignette = "";
		} else if (elementCourant.type == "image") {
			lelien = urlDigipad+"/"+stockageMediasPad+"/"+idPad+"/"+elementCourant.media;
			lavignette = urlDigipad+"/"+stockageMediasPad+"/"+idPad+"/"+elementCourant.media;
		} else {
			if (elementCourant.media.indexOf("http") == 0) lelien = elementCourant.media;
			else lelien = urlDigipad+"/"+stockageMediasPad+"/"+idPad+"/"+elementCourant.media;
			if (elementCourant.vignette.indexOf("http") == 0) lavignette = elementCourant.vignette;
			else lavignette = urlDigipad+elementCourant.vignette;
		}
		if (tabDigipad.pad.affichage == "colonnes") {
			tabHtmlTr.push(["<tr"+(elementCourant.visibilite == 'privee' ? ' class=\"capsule_privee\"' : '')+"><td class='t_vig'>"+(lavignette == '' ? '' : "<img src='"+lavignette+"'")+" /></td><td class='t_tit'>"+(lelien == '' ? letitre : "<a href='"+lelien+"' target='_blank'>"+letitre+"</a>")+"</td><td class='t_tex'>"+letexte+"</td><td class='t_qrc' data-lien='"+lelien+"'></td></tr>",elementCourant.colonne]);
		} else {
			tabHtmlTr.push("<tr"+(elementCourant.visibilite == 'privee' ? ' class=\"capsule_privee\"' : '')+"><td class='t_vig'>"+(lavignette == '' ? '' : "<img src='"+lavignette+"'")+" /></td><td class='t_tit'>"+(lelien == '' ? letitre : "<a href='"+lelien+"' target='_blank'>"+letitre+"</a>")+"</td><td class='t_tex'>"+letexte+"</td><td class='t_qrc' data-lien='"+lelien+"'></td></tr>");
		}
	}
	return tabHtmlTr;
}

function verifierCasePrivee() {
	if ($('#case_privee').prop('checked')) $("#zone_contenu .capsule_privee").show(); //alert("case privée cochée");
	else $("#zone_contenu .capsule_privee").hide();//alert("case privée pas cochée");
}
function verifierCaseVignette() {
	if ($('#case_vignette').prop('checked')) $("#zone_contenu .t_vig").show();// alert("case vignette cochée");
	else $("#zone_contenu .t_vig").hide();// alert("case vignette pas cochée");
}
function verifierCaseQrcode() {
	if ($('#case_qrcode').prop('checked')) $("#zone_contenu .t_qrc").show();// alert("case qrcode cochée");
	else $("#zone_contenu .t_qrc").hide();// alert("case qrcode pas cochée");
}
function verifierColonneCachee() {
	if ($('#colonne_cachee').prop('checked')) $("#zone_contenu .c_cachee").show(); //alert("case privée cochée");
	else $("#zone_contenu .c_cachee").hide();//alert("case privée pas cochée");
}

function gererLookTableaux() {
	$("#zone_contenu .table").removeClass("table-striped table-bordered");
	if ($(".modalite_affichage > img.on").attr("src") == "images/bt_aff_b0_s1.png") $("#zone_contenu .table").addClass("table-striped");
	if ($(".modalite_affichage > img.on").attr("src") == "images/bt_aff_b1_s0.png") $("#zone_contenu .table").addClass("table-bordered");
	if ($(".modalite_affichage > img.on").attr("src") == "images/bt_aff_b1_s1.png") $("#zone_contenu .table").addClass("table-striped table-bordered");
}

// Changer d'écran
function changeEcran(ecran) {
    $(".ecran_tous").hide();
    $(".ecran_"+ecran).fadeIn(2000);
}

// Gérer la flèche de retour en haut de page
function retourHaut() {
	$(window).scroll(function() {
		//	Afficher le bouton si absence d'ascenseur
		if ( $(window).scrollTop() == 0 ) $('#returnOnTop').fadeOut();
		else $('#returnOnTop').fadeIn();
	});
}
